/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.model.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Feature;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.model.internal.FeatureBag;
import org.glassfish.jersey.model.internal.ProviderBag;

public class DefaultConfig
implements Configurable {
    private ProviderBag providerBag;
    private FeatureBag featureBag;
    private final Map<String, Object> properties;
    private final Map<String, Object> immutablePropertiesView;
    private volatile boolean locked = false;

    public DefaultConfig() {
        this.providerBag = new ProviderBag.Builder().build();
        this.featureBag = new FeatureBag.Builder().build();
        this.properties = new HashMap<String, Object>();
        this.immutablePropertiesView = Collections.unmodifiableMap(this.properties);
    }

    public DefaultConfig(DefaultConfig configurable) {
        this(configurable.properties, configurable.providerBag, configurable.featureBag);
    }

    public DefaultConfig(Map<String, Object> properties) {
        this();
        this.properties.putAll(properties);
    }

    public DefaultConfig(Map<String, Object> properties, ProviderBag providerBag, FeatureBag featureBag) {
        this.providerBag = new ProviderBag.Builder(providerBag).build();
        this.featureBag = new FeatureBag.Builder(featureBag).build();
        this.properties = new HashMap<String, Object>(properties);
        this.immutablePropertiesView = Collections.unmodifiableMap(this.properties);
    }

    public Map<String, Object> getProperties() {
        return this.immutablePropertiesView;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Configurable setProperties(Map<String, ?> properties) {
        if (this.locked) {
            throw new IllegalStateException(LocalizationMessages.CONFIGURABLE_NOT_MODIFIABLE());
        }
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll(properties);
        }
        return this;
    }

    public Configurable setProperty(String name, Object value) {
        if (this.locked) {
            throw new IllegalStateException(LocalizationMessages.CONFIGURABLE_NOT_MODIFIABLE());
        }
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
        return this;
    }

    public Collection<Feature> getFeatures() {
        return this.featureBag.getEnabledFeatures();
    }

    public Set<Class<?>> getProviderClasses() {
        return this.providerBag.getClasses();
    }

    public Set<Object> getProviderInstances() {
        return this.providerBag.getInstances();
    }

    public Configurable register(Class<?> providerClass) {
        return this.register(providerClass, -1);
    }

    public Configurable register(Object provider) {
        return this.register(provider, -1);
    }

    public Configurable register(Class<?> providerClass, int bindingPriority) {
        if (providerClass == null) {
            throw new IllegalArgumentException(LocalizationMessages.PROVIDER_CLASS_CANNOT_BE_NULL());
        }
        return this.register(providerClass, bindingPriority, Providers.getProviderContracts(providerClass));
    }

    public <P> Configurable register(Class<P> providerClass, Class<? super P> ... contracts) {
        return this.register(providerClass, -1, contracts);
    }

    public <P> Configurable register(Class<P> providerClass, int bindingPriority, Class<? super P> ... contracts) {
        return this.register(providerClass, bindingPriority, new HashSet(Arrays.asList(contracts)));
    }

    public Configurable register(Object provider, int bindingPriority) {
        if (provider == null) {
            throw new IllegalArgumentException(LocalizationMessages.PROVIDER_CANNOT_BE_NULL());
        }
        return this.register(provider, bindingPriority, Providers.getProviderContracts(provider.getClass()));
    }

    public <P> Configurable register(Object provider, Class<? super P> ... contracts) {
        return this.register(provider, -1, contracts);
    }

    public <P> Configurable register(Object provider, int bindingPriority, Class<? super P> ... contracts) {
        return this.register(provider, bindingPriority, new HashSet(Arrays.asList(contracts)));
    }

    protected Set<Class<?>> checkContracts(Class<?> providerClass, Set<Class<?>> allProviderContracts, Set<Class<?>> bindingContracts) {
        bindingContracts.retainAll(allProviderContracts);
        return bindingContracts;
    }

    public ProviderBag getProviderBag() {
        return this.providerBag;
    }

    public FeatureBag getFeatureBag() {
        return this.featureBag;
    }

    public boolean isEnabled(Class<? extends Feature> featureClass) {
        return this.getFeatureBag().isEnabled(featureClass);
    }

    private <P> Configurable register(Class<P> providerClass, int bindingPriority, Set<Class<?>> contracts) {
        return this.register(providerClass, null, bindingPriority, contracts);
    }

    private Configurable register(Object provider, int bindingPriority, Set<Class<?>> contracts) {
        if (provider == null) {
            throw new IllegalArgumentException(LocalizationMessages.PROVIDER_CANNOT_BE_NULL());
        }
        return this.register(provider.getClass(), provider, bindingPriority, contracts);
    }

    private <P> Configurable register(Class<P> providerClass, Object provider, int bindingPriority, Set<Class<?>> contracts) {
        if (this.locked) {
            throw new IllegalStateException(LocalizationMessages.CONFIGURABLE_NOT_MODIFIABLE());
        }
        if (providerClass == null) {
            throw new IllegalArgumentException(LocalizationMessages.PROVIDER_CLASS_CANNOT_BE_NULL());
        }
        Set<Class<?>> allProviderContracts = Providers.getProviderContracts(providerClass);
        contracts.remove(null);
        if (contracts.isEmpty()) {
            contracts = allProviderContracts;
        }
        contracts = this.checkContracts(providerClass, allProviderContracts, contracts);
        if (Feature.class.isAssignableFrom(providerClass) && contracts.contains(Feature.class)) {
            FeatureBag.Builder featureBagBuilder = new FeatureBag.Builder(this.featureBag);
            if (provider != null) {
                featureBagBuilder.add((Feature)provider);
            } else {
                featureBagBuilder.add(providerClass);
            }
            this.featureBag = featureBagBuilder.build();
            contracts.remove(Feature.class);
        }
        if (!contracts.isEmpty()) {
            ProviderBag.Builder providerBagBuilder = new ProviderBag.Builder(this.providerBag);
            if (provider != null) {
                providerBagBuilder.register(provider, bindingPriority, contracts);
            } else {
                providerBagBuilder.register(providerClass, bindingPriority, contracts);
            }
            this.providerBag = providerBagBuilder.build();
        }
        return this;
    }

    public void lock() {
        this.locked = true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultConfig)) {
            return false;
        }
        DefaultConfig other = (DefaultConfig)obj;
        return !(this != other && (this.properties != other.properties && !((Object)this.properties).equals(other.properties) || this.providerBag != other.providerBag && !this.providerBag.equals(other.providerBag) || this.featureBag != other.featureBag && !this.featureBag.equals(other.featureBag)));
    }

    public int hashCode() {
        int hash = 23;
        hash = 7 * hash + ((Object)this.properties).hashCode();
        hash = 7 * hash + this.providerBag.hashCode();
        hash = 7 * hash + this.featureBag.hashCode();
        return hash;
    }
}

