/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import java.net.URI;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.internal.LocalizationMessages;

public class UriInfoInjectee
implements UriInfo {
    private UriInfo wrapped;

    public void set(UriInfo uriInfo) {
        if (this.wrapped != null) {
            throw new IllegalStateException(LocalizationMessages.URI_INFO_WAS_ALREADY_SET());
        }
        this.wrapped = uriInfo;
    }

    public URI getRequestUri() {
        this.checkStatus();
        return this.wrapped.getRequestUri();
    }

    public String getPath() {
        this.checkStatus();
        return this.wrapped.getPath();
    }

    public String getPath(boolean decode) {
        this.checkStatus();
        return this.wrapped.getPath(decode);
    }

    public List<PathSegment> getPathSegments() {
        this.checkStatus();
        return this.wrapped.getPathSegments();
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        this.checkStatus();
        return this.wrapped.getPathSegments(decode);
    }

    public UriBuilder getRequestUriBuilder() {
        this.checkStatus();
        return this.wrapped.getRequestUriBuilder();
    }

    public URI getAbsolutePath() {
        this.checkStatus();
        return this.wrapped.getAbsolutePath();
    }

    public UriBuilder getAbsolutePathBuilder() {
        this.checkStatus();
        return this.wrapped.getAbsolutePathBuilder();
    }

    public URI getBaseUri() {
        this.checkStatus();
        return this.wrapped.getBaseUri();
    }

    public UriBuilder getBaseUriBuilder() {
        this.checkStatus();
        return this.wrapped.getBaseUriBuilder();
    }

    public MultivaluedMap<String, String> getPathParameters() {
        this.checkStatus();
        return this.wrapped.getPathParameters();
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        this.checkStatus();
        return this.wrapped.getPathParameters(decode);
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        this.checkStatus();
        return this.wrapped.getQueryParameters();
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        this.checkStatus();
        return this.wrapped.getQueryParameters(decode);
    }

    public List<String> getMatchedURIs() {
        this.checkStatus();
        return this.wrapped.getMatchedURIs();
    }

    public List<String> getMatchedURIs(boolean decode) {
        this.checkStatus();
        return this.wrapped.getMatchedURIs(decode);
    }

    public List<Object> getMatchedResources() {
        this.checkStatus();
        return this.wrapped.getMatchedResources();
    }

    public URI resolve(URI uri) {
        this.checkStatus();
        return this.wrapped.resolve(uri);
    }

    public URI resolve(URI baseUri, URI uri) {
        this.checkStatus();
        return this.wrapped.resolve(baseUri, uri);
    }

    public URI relativize(URI uri) {
        this.checkStatus();
        return this.wrapped.relativize(uri);
    }

    public URI relativize(URI from, URI uri) {
        this.checkStatus();
        return this.wrapped.relativize(from, uri);
    }

    private void checkStatus() throws IllegalStateException {
        if (this.wrapped == null) {
            throw new IllegalStateException(LocalizationMessages.URI_INFO_WAS_NOT_SET());
        }
    }
}

