/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.Feature;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.inject.CustomAnnotationImpl;
import org.glassfish.jersey.internal.inject.ProviderToService;
import org.glassfish.jersey.model.ContractProvider;
import org.glassfish.jersey.model.internal.RankedComparator;
import org.glassfish.jersey.model.internal.RankedProvider;
import org.glassfish.jersey.spi.Contract;

public class Providers {
    private static final Logger LOGGER = Logger.getLogger(Providers.class.getName());
    private static final Map<Class<?>, ProviderRuntime> EXTERNAL_PROVIDER_INTERFACE_WHITELIST = Providers.getExternalProviderInterfaces();

    private static Map<Class<?>, ProviderRuntime> getExternalProviderInterfaces() {
        HashMap interfaces = new HashMap();
        ProviderRuntime BOTH = new ProviderRuntime(null);
        ProviderRuntime SERVER = new ProviderRuntime(RuntimeType.SERVER);
        ProviderRuntime CLIENT = new ProviderRuntime(RuntimeType.CLIENT);
        interfaces.put(ContextResolver.class, BOTH);
        interfaces.put(ExceptionMapper.class, BOTH);
        interfaces.put(MessageBodyReader.class, BOTH);
        interfaces.put(MessageBodyWriter.class, BOTH);
        interfaces.put(ReaderInterceptor.class, BOTH);
        interfaces.put(WriterInterceptor.class, BOTH);
        interfaces.put(ParamConverterProvider.class, BOTH);
        interfaces.put(Feature.class, BOTH);
        interfaces.put(ContainerRequestFilter.class, SERVER);
        interfaces.put(ContainerResponseFilter.class, SERVER);
        interfaces.put(DynamicFeature.class, SERVER);
        interfaces.put(ClientResponseFilter.class, CLIENT);
        interfaces.put(ClientRequestFilter.class, CLIENT);
        interfaces.put(Binder.class, BOTH);
        return interfaces;
    }

    private Providers() {
    }

    public static <T> Factory<T> factoryOf(final T instance) {
        return new Factory<T>(){

            public T provide() {
                return instance;
            }

            public void dispose(T instance2) {
            }
        };
    }

    public static <T> Set<T> getProviders(ServiceLocator locator, Class<T> contract) {
        List<ServiceHandle<T>> hk2Providers = Providers.getAllServiceHandles(locator, contract, new Annotation[0]);
        return Providers.getClasses(hk2Providers);
    }

    public static <T> Set<T> getCustomProviders(ServiceLocator locator, Class<T> contract) {
        List<ServiceHandle<T>> hk2Providers = Providers.getAllServiceHandles(locator, contract, new CustomAnnotationImpl());
        return Providers.getClasses(hk2Providers);
    }

    public static <T> Iterable<T> getAllProviders(ServiceLocator locator, Class<T> contract) {
        return Providers.getAllProviders(locator, contract, (Comparator)null);
    }

    public static <T> Iterable<RankedProvider<T>> getAllRankedProviders(ServiceLocator locator, Class<T> contract) {
        List<ServiceHandle<T>> providers = Providers.getAllServiceHandles(locator, contract, new CustomAnnotationImpl());
        providers.addAll(Providers.getAllServiceHandles(locator, contract, new Annotation[0]));
        LinkedHashMap providerMap = Maps.newLinkedHashMap();
        for (ServiceHandle<T> provider : providers) {
            ActiveDescriptor key = provider.getActiveDescriptor();
            if (providerMap.containsKey(key)) continue;
            providerMap.put(key, new RankedProvider<Object>(provider.getService(), key.getRanking()));
        }
        return providerMap.values();
    }

    public static <T> Iterable<T> sortRankedProviders(RankedComparator<T> comparator, Iterable<RankedProvider<T>> ... providerIterables) {
        ArrayList rankedProviders = Lists.newArrayList();
        for (Iterable<RankedProvider<T>> providers : providerIterables) {
            rankedProviders.addAll(Lists.newLinkedList(providers));
        }
        Collections.sort(rankedProviders, comparator);
        return Collections2.transform((Collection)rankedProviders, (Function)new Function<RankedProvider<T>, T>(){

            public T apply(RankedProvider<T> input) {
                return input.getProvider();
            }
        });
    }

    public static <T> Iterable<T> getAllProviders(ServiceLocator locator, Class<T> contract, RankedComparator<T> comparator) {
        return Providers.sortRankedProviders(comparator, Providers.getAllRankedProviders(locator, contract));
    }

    private static <T> List<ServiceHandle<T>> getAllServiceHandles(ServiceLocator locator, Class<T> contract, Annotation ... qualifiers) {
        List allServiceHandles = qualifiers == null ? locator.getAllServiceHandles(contract, new Annotation[0]) : locator.getAllServiceHandles(contract, qualifiers);
        ArrayList<ServiceHandle<T>> serviceHandles = new ArrayList<ServiceHandle<T>>();
        for (ServiceHandle handle : allServiceHandles) {
            serviceHandles.add(handle);
        }
        return serviceHandles;
    }

    public static <T> Iterable<T> getAllProviders(ServiceLocator locator, Class<T> contract, Comparator<T> comparator) {
        List<ServiceHandle<T>> providers = Providers.getAllServiceHandles(locator, contract, new CustomAnnotationImpl());
        providers.addAll(Providers.getAllServiceHandles(locator, contract, new Annotation[0]));
        LinkedHashMap providerMap = Maps.newLinkedHashMap();
        for (ServiceHandle<T> provider : providers) {
            ActiveDescriptor key = provider.getActiveDescriptor();
            if (providerMap.containsKey(key)) continue;
            providerMap.put(key, provider);
        }
        ArrayList<T> providerList = new ArrayList<T>(Providers.getClasses(providerMap.values()));
        if (comparator != null) {
            Collections.sort(providerList, comparator);
        }
        return providerList;
    }

    private static <T> Set<T> getClasses(Collection<ServiceHandle<T>> hk2Providers) {
        if (hk2Providers.isEmpty()) {
            return Sets.newLinkedHashSet();
        }
        return Sets.newLinkedHashSet((Iterable)Collections2.transform(hk2Providers, new ProviderToService()));
    }

    public static <T> SortedSet<T> getProviders(ServiceLocator locator, Class<T> contract, Comparator<T> comparator) {
        List<ServiceHandle<T>> hk2Providers = Providers.getAllServiceHandles(locator, contract, new Annotation[0]);
        if (hk2Providers.isEmpty()) {
            return Sets.newTreeSet(comparator);
        }
        TreeSet set = Sets.newTreeSet(comparator);
        set.addAll(Collections2.transform(hk2Providers, new ProviderToService()));
        return set;
    }

    public static Set<Class<?>> getProviderContracts(Class<?> clazz) {
        Set contracts = Sets.newIdentityHashSet();
        Providers.computeProviderContracts(clazz, contracts);
        return contracts;
    }

    private static void computeProviderContracts(Class<?> clazz, Set<Class<?>> contracts) {
        for (Class<?> contract : Providers.getImplementedContracts(clazz)) {
            if (Providers.isSupportedContract(contract)) {
                contracts.add(contract);
            }
            Providers.computeProviderContracts(contract, contracts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkProviderRuntime(Class<?> component, ContractProvider model, RuntimeType runtimeConstraint, boolean scanned, boolean isResource) {
        RuntimeType componentConstraint;
        Set<Class<?>> contracts = model.getContracts();
        ConstrainedTo constrainedTo = component.getAnnotation(ConstrainedTo.class);
        RuntimeType runtimeType = componentConstraint = constrainedTo == null ? null : constrainedTo.value();
        if (Feature.class.isAssignableFrom(component)) {
            return true;
        }
        StringBuilder warnings = new StringBuilder();
        try {
            boolean isProviderRuntimeCompatible;
            boolean foundComponentCompatible = componentConstraint == null;
            boolean foundRuntimeCompatibleContract = isResource && runtimeConstraint == RuntimeType.SERVER;
            for (Class<?> contract : contracts) {
                RuntimeType contractConstraint = Providers.getContractConstraint(contract, componentConstraint);
                foundRuntimeCompatibleContract |= contractConstraint == null || contractConstraint == runtimeConstraint;
                if (componentConstraint == null) continue;
                if (contractConstraint != componentConstraint) {
                    warnings.append(LocalizationMessages.WARNING_PROVIDER_CONSTRAINED_TO_WRONG_PACKAGE(component.getName(), componentConstraint.name(), contract.getName(), contractConstraint.name())).append(" ");
                    continue;
                }
                foundComponentCompatible = true;
            }
            if (!foundComponentCompatible) {
                warnings.append(LocalizationMessages.ERROR_PROVIDER_CONSTRAINED_TO_WRONG_PACKAGE(component.getName(), componentConstraint.name())).append(" ");
                Providers.logProviderSkipped(warnings, component, isResource);
                boolean i$ = false;
                return i$;
            }
            boolean bl = isProviderRuntimeCompatible = componentConstraint == null || componentConstraint == runtimeConstraint;
            if (!isProviderRuntimeCompatible && !scanned) {
                warnings.append(LocalizationMessages.ERROR_PROVIDER_CONSTRAINED_TO_WRONG_RUNTIME(component.getName(), componentConstraint.name(), runtimeConstraint.name())).append(" ");
                Providers.logProviderSkipped(warnings, component, isResource);
            }
            if (!foundRuntimeCompatibleContract && !scanned) {
                warnings.append(LocalizationMessages.ERROR_PROVIDER_REGISTERED_WRONG_RUNTIME(component.getName(), runtimeConstraint.name())).append(" ");
                Providers.logProviderSkipped(warnings, component, isResource);
                boolean bl2 = false;
                return bl2;
            }
            boolean bl3 = isProviderRuntimeCompatible && foundRuntimeCompatibleContract;
            return bl3;
        }
        finally {
            if (warnings.length() > 0) {
                LOGGER.log(Level.WARNING, warnings.toString());
            }
        }
    }

    private static void logProviderSkipped(StringBuilder sb, Class<?> provider, boolean alsoResourceClass) {
        sb.append(alsoResourceClass ? LocalizationMessages.ERROR_PROVIDER_AND_RESOURCE_CONSTRAINED_TO_IGNORED(provider.getName()) : LocalizationMessages.ERROR_PROVIDER_CONSTRAINED_TO_IGNORED(provider.getName())).append(" ");
    }

    public static boolean isSupportedContract(Class<?> type) {
        return EXTERNAL_PROVIDER_INTERFACE_WHITELIST.get(type) != null || type.isAnnotationPresent(Contract.class);
    }

    private static RuntimeType getContractConstraint(Class<?> clazz, RuntimeType defaultConstraint) {
        ConstrainedTo constrainedToAnnotation;
        ProviderRuntime jaxRsProvider = EXTERNAL_PROVIDER_INTERFACE_WHITELIST.get(clazz);
        RuntimeType result = null;
        if (jaxRsProvider != null) {
            result = jaxRsProvider.getRuntime();
        } else if (clazz.getAnnotation(Contract.class) != null && (constrainedToAnnotation = clazz.getAnnotation(ConstrainedTo.class)) != null) {
            result = constrainedToAnnotation.value();
        }
        return result == null ? defaultConstraint : result;
    }

    private static List<Class<?>> getImplementedContracts(Class<?> clazz) {
        LinkedList list = new LinkedList();
        Collections.addAll(list, clazz.getInterfaces());
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            list.add(superclass);
        }
        return list;
    }

    public static boolean isProvider(Class<?> clazz) {
        return Providers.findFirstProviderContract(clazz);
    }

    private static boolean findFirstProviderContract(Class<?> clazz) {
        for (Class<?> contract : Providers.getImplementedContracts(clazz)) {
            if (Providers.isSupportedContract(contract)) {
                return true;
            }
            if (!Providers.findFirstProviderContract(contract)) continue;
            return true;
        }
        return false;
    }

    private static final class ProviderRuntime {
        private final RuntimeType runtime;

        private ProviderRuntime(RuntimeType runtime) {
            this.runtime = runtime;
        }

        public RuntimeType getRuntime() {
            return this.runtime;
        }
    }
}

