/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.hk2;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericType;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.InjecteeImpl;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.internal.inject.ContextInjectionResolver;
import org.glassfish.jersey.internal.inject.ForeignRequestScopeBridge;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.Cache;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.process.internal.RequestScoped;

@Singleton
public class ContextInjectionResolverImpl
implements InjectionResolver<Context>,
ContextInjectionResolver {
    @Inject
    private ServiceLocator serviceLocator;
    private final Cache<Injectee, ActiveDescriptor<?>> descriptorCache = new Cache(new Function<Injectee, ActiveDescriptor<?>>(){

        @Override
        public ActiveDescriptor<?> apply(Injectee key) {
            return ContextInjectionResolverImpl.this.serviceLocator.getInjecteeDescriptor(key);
        }
    });
    private final Cache<Injectee, Injectee> foreignRequestScopedInjecteeCache = new Cache<Injectee, Injectee>(new Function<Injectee, Injectee>(){

        @Override
        public Injectee apply(Injectee injectee) {
            if (injectee.getParent() != null && Field.class.isAssignableFrom(injectee.getParent().getClass())) {
                Field f = (Field)injectee.getParent();
                if (((Set)ContextInjectionResolverImpl.this.foreignRequestScopedComponents.get()).contains(f.getDeclaringClass())) {
                    Class<?> clazz = f.getType();
                    if (ContextInjectionResolverImpl.this.serviceLocator.getServiceHandle(clazz, new Annotation[0]).getActiveDescriptor().getScopeAnnotation() == RequestScoped.class) {
                        AbstractActiveDescriptor descriptor = BuilderHelper.activeLink(clazz).to(clazz).in(RequestScoped.class).build();
                        return new DescriptorOverridingInjectee(injectee, (ActiveDescriptor)descriptor);
                    }
                }
            }
            return injectee;
        }
    });
    private LazyValue<Set<Class<?>>> foreignRequestScopedComponents = Values.lazy(this::getForeignRequestScopedComponents);

    public Object resolve(Injectee injectee, ServiceHandle<?> root) {
        Type requiredType = injectee.getRequiredType();
        boolean isHk2Factory = ReflectionHelper.isSubClassOf(requiredType, Factory.class);
        Injectee newInjectee = isHk2Factory ? this.getFactoryInjectee(injectee, ReflectionHelper.getTypeArgument(requiredType, 0)) : this.foreignRequestScopedInjecteeCache.apply(injectee);
        ActiveDescriptor<?> ad = this.descriptorCache.apply(newInjectee);
        if (ad != null) {
            ServiceHandle handle = this.serviceLocator.getServiceHandle(ad, newInjectee);
            if (isHk2Factory) {
                return this.asFactory(handle);
            }
            return handle.getService();
        }
        return null;
    }

    @Override
    public Object resolve(final org.glassfish.jersey.internal.inject.Injectee injectee) {
        InjecteeImpl hk2injectee = new InjecteeImpl(){

            public Class<?> getInjecteeClass() {
                return injectee.getInjecteeClass();
            }
        };
        hk2injectee.setRequiredType(injectee.getRequiredType());
        hk2injectee.setRequiredQualifiers(injectee.getRequiredQualifiers());
        if (injectee.getInjecteeDescriptor() != null) {
            hk2injectee.setInjecteeDescriptor((ActiveDescriptor)injectee.getInjecteeDescriptor().get());
        }
        return this.resolve((Injectee)hk2injectee, null);
    }

    private Factory asFactory(final ServiceHandle handle) {
        return new Factory(){

            public Object provide() {
                return handle.getService();
            }

            public void dispose(Object instance) {
            }
        };
    }

    private Injectee getFactoryInjectee(Injectee injectee, Type requiredType) {
        return new RequiredTypeOverridingInjectee(injectee, requiredType);
    }

    @Override
    public boolean isConstructorParameterIndicator() {
        return true;
    }

    @Override
    public boolean isMethodParameterIndicator() {
        return false;
    }

    @Override
    public Class<Context> getAnnotation() {
        return Context.class;
    }

    private Set<Class<?>> getForeignRequestScopedComponents() {
        List scopeBridges = this.serviceLocator.getAllServices(ForeignRequestScopeBridge.class, new Annotation[0]);
        HashSet result = new HashSet();
        for (ForeignRequestScopeBridge bridge : scopeBridges) {
            Set<Class<?>> requestScopedComponents = bridge.getRequestScopedComponents();
            if (requestScopedComponents == null) continue;
            result.addAll(requestScopedComponents);
        }
        return result;
    }

    private static class DescriptorOverridingInjectee
    extends InjecteeImpl {
        private DescriptorOverridingInjectee(Injectee injectee, ActiveDescriptor descriptor) {
            super(injectee);
            this.setInjecteeDescriptor(descriptor);
        }
    }

    private static class RequiredTypeOverridingInjectee
    extends InjecteeImpl {
        private RequiredTypeOverridingInjectee(Injectee injectee, Type requiredType) {
            super(injectee);
            this.setRequiredType(requiredType);
        }
    }

    public static final class Binder
    extends AbstractBinder {
        @Override
        protected void configure() {
            ((ClassBinding)((ClassBinding)((ClassBinding)this.bind(ContextInjectionResolverImpl.class).to(new GenericType<InjectionResolver<Context>>(){})).to(new GenericType<org.glassfish.jersey.internal.inject.InjectionResolver<Context>>(){})).to(ContextInjectionResolver.class)).in(Singleton.class);
        }
    }
}

