/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.hk2;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.jersey.hk2.Hk2BootstrapBinder;
import org.glassfish.jersey.hk2.Hk2Helper;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.internal.inject.CompositeBinder;
import org.glassfish.jersey.internal.inject.ForeignDescriptor;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.internal.inject.ServiceHolder;
import org.glassfish.jersey.internal.inject.ServiceHolderImpl;
import org.jvnet.hk2.external.runtime.ServiceLocatorRuntimeBean;

public class HK2InjectionManager
implements InjectionManager {
    private static final Logger LOGGER = Logger.getLogger(HK2InjectionManager.class.getName());
    private static final ServiceLocatorFactory factory = ServiceLocatorFactory.getInstance();
    private ServiceLocator locator;

    public HK2InjectionManager() {
    }

    private HK2InjectionManager(ServiceLocator locator) {
        this.locator = locator;
    }

    private static ServiceLocator createLocator(String name, ServiceLocator parentLocator) {
        ServiceLocator result = factory.create(name, parentLocator, null, ServiceLocatorFactory.CreatePolicy.DESTROY);
        result.setNeutralContextClassLoader(false);
        ServiceLocatorUtilities.enablePerThreadScope((ServiceLocator)result);
        return result;
    }

    public static InjectionManager createInjectionManager(ServiceLocator locator) {
        return new HK2InjectionManager(locator);
    }

    public ServiceLocator getServiceLocator() {
        return this.locator;
    }

    @Override
    public void initialize(String name, Object parent, Binder ... binders) {
        ServiceLocator parentLocator = HK2InjectionManager.resolveServiceLocatorParent(parent);
        this.locator = HK2InjectionManager.createLocator(name, parentLocator);
        Hk2Helper.bind(this.locator, new Hk2BootstrapBinder(this, CompositeBinder.wrap(binders)));
        this.locator.setDefaultClassAnalyzerName("JerseyClassAnalyzer");
        ServiceLocatorRuntimeBean serviceLocatorRuntimeBean = (ServiceLocatorRuntimeBean)this.locator.getService(ServiceLocatorRuntimeBean.class, new Annotation[0]);
        if (serviceLocatorRuntimeBean != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(LocalizationMessages.CLEARING_HK_2_CACHE(serviceLocatorRuntimeBean.getServiceCacheSize(), serviceLocatorRuntimeBean.getReflectionCacheSize()));
            }
            serviceLocatorRuntimeBean.clearReflectionCache();
            serviceLocatorRuntimeBean.clearServiceCache();
        }
    }

    private static void assertParentLocatorType(Object parent) {
        if (parent != null && !(parent instanceof ServiceLocator) && !(parent instanceof HK2InjectionManager)) {
            throw new RuntimeException(LocalizationMessages.HK_2_UNKNOWN_PARENT_INSTANCE_MANAGER(parent.getClass().getSimpleName()));
        }
    }

    @Override
    public void shutdown() {
        if (factory.find(this.locator.getName()) != null) {
            factory.destroy(this.locator.getName());
        } else {
            this.locator.shutdown();
        }
    }

    @Override
    public void register(Binding binding) {
        Hk2Helper.bind(this.locator, binding);
    }

    @Override
    public void register(Iterable<Binding> descriptors) {
        Hk2Helper.bind(this.locator, descriptors);
    }

    @Override
    public void register(Binder binder) {
        Hk2Helper.bind(this.locator, binder);
    }

    @Override
    public void register(org.glassfish.hk2.utilities.Binder ... binder) {
        ServiceLocatorUtilities.bind((ServiceLocator)this.locator, (org.glassfish.hk2.utilities.Binder[])binder);
    }

    public <U> U createAndInitialize(Class<U> clazz) {
        return (U)this.locator.createAndInitialize(clazz);
    }

    @Override
    public <T> List<ServiceHolder<T>> getAllServiceHolders(Class<T> contract, Annotation ... qualifiers) {
        return this.locator.getAllServiceHandles(contract, qualifiers).stream().map(sh -> new ServiceHolderImpl<Object>(sh.getService(), sh.getActiveDescriptor().getImplementationClass(), sh.getActiveDescriptor().getContractTypes(), sh.getActiveDescriptor().getRanking())).collect(Collectors.toList());
    }

    @Override
    public <T> T getInstance(Class<T> clazz, Annotation ... annotations) {
        return (T)this.locator.getService(clazz, annotations);
    }

    @Override
    public <T> T getInstance(Type clazz) {
        return (T)this.locator.getService(clazz, new Annotation[0]);
    }

    @Override
    public Object getInstance(ForeignDescriptor foreignDescriptor) {
        return this.locator.getServiceHandle((ActiveDescriptor)foreignDescriptor.get()).getService();
    }

    @Override
    public ForeignDescriptor createForeignDescriptor(Binding binding) {
        ForeignDescriptor foreignDescriptor = this.createAndTranslateForeignDescriptor(binding);
        ActiveDescriptor activeDescriptor = ServiceLocatorUtilities.addOneDescriptor((ServiceLocator)this.locator, (Descriptor)((Descriptor)foreignDescriptor.get()), (boolean)false);
        return ForeignDescriptor.wrap(activeDescriptor, arg_0 -> ((ActiveDescriptor)activeDescriptor).dispose(arg_0));
    }

    private ForeignDescriptor createAndTranslateForeignDescriptor(Binding binding) {
        ActiveDescriptor<?> activeDescriptor;
        if (ClassBinding.class.isAssignableFrom(binding.getClass())) {
            activeDescriptor = Hk2Helper.translateToActiveDescriptor((ClassBinding)binding);
        } else if (InstanceBinding.class.isAssignableFrom(binding.getClass())) {
            activeDescriptor = Hk2Helper.translateToActiveDescriptor((InstanceBinding)binding, new Type[0]);
        } else {
            throw new RuntimeException(LocalizationMessages.UNKNOWN_DESCRIPTOR_TYPE(binding.getClass().getSimpleName()));
        }
        return ForeignDescriptor.wrap(activeDescriptor, arg_0 -> activeDescriptor.dispose(arg_0));
    }

    private static ServiceLocator resolveServiceLocatorParent(Object parent) {
        HK2InjectionManager.assertParentLocatorType(parent);
        ServiceLocator parentLocator = null;
        if (parent != null) {
            if (parent instanceof ServiceLocator) {
                parentLocator = (ServiceLocator)parent;
            } else if (parent instanceof HK2InjectionManager) {
                parentLocator = ((HK2InjectionManager)parent).getServiceLocator();
            }
        }
        return parentLocator;
    }

    @Override
    public <T> T getInstance(Class<T> clazz) {
        return (T)this.locator.getService(clazz, new Annotation[0]);
    }

    @Override
    public <T> T getInstance(Class<T> clazz, String classAnalyzer) {
        return (T)this.locator.getService(clazz, classAnalyzer, new Annotation[0]);
    }

    @Override
    public <T> List<T> getAllInstances(Type clazz) {
        return this.locator.getAllServices(clazz, new Annotation[0]);
    }

    @Override
    public void inject(Object injectMe) {
        this.locator.inject(injectMe);
    }

    @Override
    public void inject(Object injectMe, String classAnalyzer) {
        this.locator.inject(injectMe, classAnalyzer);
    }

    @Override
    public void preDestroy(Object preDestroyMe) {
        this.locator.preDestroy(preDestroyMe);
    }
}

