/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.ws.rs.core.GenericType;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.Bindings;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.internal.inject.InjectionResolver;
import org.glassfish.jersey.internal.inject.InjectionResolverBinding;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;
import org.glassfish.jersey.internal.inject.SupplierInstanceBinding;

public abstract class AbstractBinder
implements Binder {
    private List<Binding> bindings = new ArrayList<Binding>();
    private List<AbstractBinder> installed = new ArrayList<AbstractBinder>();

    protected abstract void configure();

    public <T> ClassBinding<T> bind(Class<T> serviceType) {
        ClassBinding<T> descriptor = Bindings.service(serviceType);
        this.bindings.add(descriptor);
        return descriptor;
    }

    public <T> ClassBinding<T> bindAsContract(Class<T> serviceType) {
        ClassBinding<T> descriptor = Bindings.serviceAsContract(serviceType);
        this.bindings.add(descriptor);
        return descriptor;
    }

    public <T> ClassBinding<T> bindAsContract(GenericType<T> serviceType) {
        ClassBinding<T> descriptor = Bindings.service(serviceType);
        this.bindings.add(descriptor);
        return descriptor;
    }

    public ClassBinding<Object> bindAsContract(Type serviceType) {
        ClassBinding<Object> descriptor = Bindings.serviceAsContract(serviceType);
        this.bindings.add(descriptor);
        return descriptor;
    }

    public <T> InstanceBinding<T> bind(T service) {
        InstanceBinding<T> descriptor = Bindings.service(service);
        this.bindings.add(descriptor);
        return descriptor;
    }

    public <T> SupplierClassBinding<T> bindFactory(Class<? extends Supplier<T>> supplierType, Class<? extends Annotation> supplierScope) {
        SupplierClassBinding binding = Bindings.supplier(supplierType, supplierScope);
        this.bindings.add(binding);
        return binding;
    }

    public <T> SupplierClassBinding<T> bindFactory(Class<? extends Supplier<T>> supplierType) {
        SupplierClassBinding binding = Bindings.supplier(supplierType);
        this.bindings.add(binding);
        return binding;
    }

    public <T> SupplierInstanceBinding<T> bindFactory(Supplier<T> factory) {
        SupplierInstanceBinding<T> binding = Bindings.supplier(factory);
        this.bindings.add(binding);
        return binding;
    }

    public <T extends InjectionResolver> InjectionResolverBinding<T> bind(T resolver) {
        InjectionResolverBinding<T> descriptor = Bindings.injectionResolver(resolver);
        this.bindings.add(descriptor);
        return descriptor;
    }

    public final void install(AbstractBinder ... binders) {
        Arrays.stream(binders).filter(Objects::nonNull).forEach(this.installed::add);
    }

    @Override
    public Collection<Binding> getBindings() {
        return AbstractBinder.flatten(this).stream().flatMap(binder -> binder.bindings.stream()).collect(Collectors.toList());
    }

    private static List<AbstractBinder> flatten(AbstractBinder binder) {
        ArrayList<AbstractBinder> binders = new ArrayList<AbstractBinder>();
        AbstractBinder.flatten(binder, binders);
        return binders;
    }

    private static void flatten(AbstractBinder binder, List<AbstractBinder> binders) {
        binder.configure();
        if (binder.installed.size() > 0) {
            binder.installed.forEach(b -> AbstractBinder.flatten(b, binders));
        }
        binders.add(binder);
    }
}

