/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import org.glassfish.jersey.internal.inject.ForeignDescriptor;
import org.glassfish.jersey.internal.inject.Injectee;

public class InjecteeImpl
implements Injectee {
    private Type requiredType;
    private Set<Annotation> qualifiers;
    private int position = -1;
    private Class<?> injecteeClass;
    private AnnotatedElement parent;
    private boolean isOptional = false;
    private boolean isFactory = false;
    private ForeignDescriptor injecteeDescriptor;

    @Override
    public Type getRequiredType() {
        return this.requiredType;
    }

    public void setRequiredType(Type requiredType) {
        this.requiredType = requiredType;
    }

    @Override
    public Set<Annotation> getRequiredQualifiers() {
        if (this.qualifiers == null) {
            return Collections.emptySet();
        }
        return this.qualifiers;
    }

    public void setRequiredQualifiers(Set<Annotation> requiredQualifiers) {
        this.qualifiers = Collections.unmodifiableSet(requiredQualifiers);
    }

    @Override
    public boolean isFactory() {
        return this.isFactory;
    }

    public void setFactory(boolean factory) {
        this.isFactory = factory;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    @Override
    public Class<?> getInjecteeClass() {
        return this.injecteeClass;
    }

    public void setInjecteeClass(Class<?> injecteeClass) {
        this.injecteeClass = injecteeClass;
    }

    @Override
    public AnnotatedElement getParent() {
        return this.parent;
    }

    public void setParent(AnnotatedElement parent) {
        this.parent = parent;
        if (parent instanceof Field) {
            this.injecteeClass = ((Field)parent).getDeclaringClass();
        } else if (parent instanceof Constructor) {
            this.injecteeClass = ((Constructor)parent).getDeclaringClass();
        } else if (parent instanceof Method) {
            this.injecteeClass = ((Method)parent).getDeclaringClass();
        }
    }

    @Override
    public boolean isOptional() {
        return this.isOptional;
    }

    public void setOptional(boolean optional) {
        this.isOptional = optional;
    }

    @Override
    public ForeignDescriptor getInjecteeDescriptor() {
        return this.injecteeDescriptor;
    }

    public void setInjecteeDescriptor(ForeignDescriptor injecteeDescriptor) {
        this.injecteeDescriptor = injecteeDescriptor;
    }
}

