/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import java.util.Iterator;
import java.util.ServiceLoader;
import javax.inject.Provider;
import javax.ws.rs.WebApplicationException;
import org.glassfish.jersey.hk2.HK2InjectionManager;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.InjectionManager;

public class Injections {
    public static InjectionManager createInjectionManager(String name, Object parent, Binder ... binders) {
        return Injections._injectionManager(name, parent, binders);
    }

    public static InjectionManager createInjectionManager(Binder ... binders) {
        return Injections._injectionManager(null, null, binders);
    }

    public static InjectionManager createInjectionManager(String name, Binder ... binders) {
        return Injections._injectionManager(name, null, binders);
    }

    public static InjectionManager createInjectionManager(Object parent, Binder ... binders) {
        return Injections._injectionManager(null, parent, binders);
    }

    private static InjectionManager _injectionManager(String name, Object parent, Binder ... binders) {
        Iterator<InjectionManager> iterator = ServiceLoader.load(InjectionManager.class).iterator();
        InjectionManager injectionManager = iterator.hasNext() ? iterator.next() : new HK2InjectionManager();
        injectionManager.initialize(name, parent, binders);
        return injectionManager;
    }

    public static <T> T getOrCreate(InjectionManager injectionManager, Class<T> clazz) {
        try {
            T component = injectionManager.getInstance(clazz);
            return component == null ? injectionManager.createAndInitialize(clazz) : component;
        }
        catch (RuntimeException e) {
            Throwable throwable = e.getCause();
            if (throwable != null && WebApplicationException.class.isAssignableFrom(throwable.getClass())) {
                throw (WebApplicationException)throwable;
            }
            throw e;
        }
    }

    public static <T> Provider<T> getProvider(InjectionManager injectionManager, Class<T> clazz) {
        return () -> injectionManager.getInstance(clazz);
    }
}

