/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import javax.ws.rs.Flow;
import org.glassfish.jersey.internal.jsr166.Flow;
import org.glassfish.jersey.internal.jsr166.SubmissionPublisher;

public class JerseyPublisher<T>
implements Flow.Publisher<T> {
    private static final int DEFAULT_BUFFER_CAPACITY = 256;
    private SubmissionPublisher<T> submissionPublisher = new SubmissionPublisher();

    public JerseyPublisher() {
        this(ForkJoinPool.commonPool(), 256);
    }

    public JerseyPublisher(int maxBufferCapacity) {
        this(ForkJoinPool.commonPool(), maxBufferCapacity);
    }

    public JerseyPublisher(ExecutorService executorService, int maxBufferCapacity) {
        this.submissionPublisher = new SubmissionPublisher(executorService::execute, maxBufferCapacity);
    }

    public void subscribe(final Flow.Subscriber<? super T> subscriber) {
        this.submissionPublisher.subscribe(new Flow.Subscriber<T>(){

            @Override
            public void onSubscribe(final Flow.Subscription subscription) {
                subscriber.onSubscribe(new Flow.Subscription(){

                    public void request(long n) {
                        subscription.request(n);
                    }

                    public void cancel() {
                        subscription.cancel();
                    }
                });
            }

            @Override
            public void onNext(T item) {
                subscriber.onNext(item);
            }

            @Override
            public void onError(Throwable throwable) {
                subscriber.onError(throwable);
            }

            @Override
            public void onComplete() {
                subscriber.onComplete();
            }
        });
    }

    public int submit(T data) {
        return this.submissionPublisher.submit(data);
    }

    public CompletableFuture<Void> consume(Consumer<? super T> consumer) {
        return this.submissionPublisher.consume(consumer);
    }

    public void close() {
        this.submissionPublisher.close();
    }

    public void closeExceptionally(Throwable error) {
        this.submissionPublisher.closeExceptionally(error);
    }

    public int estimateMaximumLag() {
        return this.submissionPublisher.estimateMaximumLag();
    }

    public long estimateMinimumDemand() {
        return this.submissionPublisher.estimateMinimumDemand();
    }

    public Throwable getClosedException() {
        return this.submissionPublisher.getClosedException();
    }

    public int getMaxBufferCapacity() {
        return this.submissionPublisher.getMaxBufferCapacity();
    }
}

