/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.glassfish.jersey.internal.BootstrapBag;
import org.glassfish.jersey.internal.BootstrapConfigurator;
import org.glassfish.jersey.internal.Errors;
import org.glassfish.jersey.internal.guava.Preconditions;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.Bindings;
import org.glassfish.jersey.internal.inject.ForeignDescriptor;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.util.ExtendedLogger;
import org.glassfish.jersey.internal.util.LazyUid;
import org.glassfish.jersey.internal.util.Producer;

@Singleton
public class RequestScope {
    private static final ExtendedLogger logger = new ExtendedLogger(Logger.getLogger(RequestScope.class.getName()), Level.FINEST);
    private final ThreadLocal<Instance> currentScopeInstance = new ThreadLocal();
    private volatile boolean isActive = true;

    public boolean isActive() {
        return this.isActive;
    }

    public void shutdown() {
        this.isActive = false;
    }

    public Instance referenceCurrent() throws IllegalStateException {
        return this.current().getReference();
    }

    public Instance current() {
        Preconditions.checkState(this.isActive, "Request scope has been already shut down.");
        Instance scopeInstance = this.currentScopeInstance.get();
        Preconditions.checkState(scopeInstance != null, "Not inside a request scope.");
        return scopeInstance;
    }

    private Instance retrieveCurrent() {
        Preconditions.checkState(this.isActive, "Request scope has been already shut down.");
        return this.currentScopeInstance.get();
    }

    private void setCurrent(Instance instance) {
        Preconditions.checkState(this.isActive, "Request scope has been already shut down.");
        this.currentScopeInstance.set(instance);
    }

    private void resumeCurrent(Instance instance) {
        this.currentScopeInstance.set(instance);
    }

    public Instance suspendCurrent() {
        Instance instance;
        Instance scopeInstance = this.retrieveCurrent();
        if (scopeInstance == null) {
            return null;
        }
        try {
            instance = scopeInstance.getReference();
        }
        catch (Throwable throwable) {
            logger.debugLog("Returned a new reference of the request scope instance {0}", scopeInstance);
            throw throwable;
        }
        logger.debugLog("Returned a new reference of the request scope instance {0}", scopeInstance);
        return instance;
    }

    public Instance createInstance() {
        return new Instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInScope(Instance scopeInstance, Runnable task) {
        Instance oldInstance = this.retrieveCurrent();
        try {
            this.setCurrent(scopeInstance.getReference());
            Errors.process(task);
        }
        finally {
            scopeInstance.release();
            this.resumeCurrent(oldInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInScope(Runnable task) {
        Instance oldInstance = this.retrieveCurrent();
        Instance instance = this.createInstance();
        try {
            this.setCurrent(instance);
            Errors.process(task);
        }
        finally {
            instance.release();
            this.resumeCurrent(oldInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runInScope(Instance scopeInstance, Callable<T> task) throws Exception {
        Instance oldInstance = this.retrieveCurrent();
        try {
            this.setCurrent(scopeInstance.getReference());
            T t = Errors.process(task);
            return t;
        }
        finally {
            scopeInstance.release();
            this.resumeCurrent(oldInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runInScope(Callable<T> task) throws Exception {
        Instance oldInstance = this.retrieveCurrent();
        Instance instance = this.createInstance();
        try {
            this.setCurrent(instance);
            T t = Errors.process(task);
            return t;
        }
        finally {
            instance.release();
            this.resumeCurrent(oldInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runInScope(Instance scopeInstance, Producer<T> task) {
        Instance oldInstance = this.retrieveCurrent();
        try {
            this.setCurrent(scopeInstance.getReference());
            T t = Errors.process(task);
            return t;
        }
        finally {
            scopeInstance.release();
            this.resumeCurrent(oldInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runInScope(Producer<T> task) {
        Instance oldInstance = this.retrieveCurrent();
        Instance instance = this.createInstance();
        try {
            this.setCurrent(instance);
            T t = Errors.process(task);
            return t;
        }
        finally {
            instance.release();
            this.resumeCurrent(oldInstance);
        }
    }

    public static final class Instance {
        private final LazyUid id = new LazyUid();
        private final Map<ForeignDescriptor, Object> store = new HashMap<ForeignDescriptor, Object>();
        private final AtomicInteger referenceCounter = new AtomicInteger(1);

        private Instance() {
        }

        private Instance getReference() {
            this.referenceCounter.incrementAndGet();
            return this;
        }

        public <T> T get(ForeignDescriptor descriptor) {
            return (T)this.store.get(descriptor);
        }

        public <T> T put(ForeignDescriptor descriptor, T value) {
            Preconditions.checkState(!this.store.containsKey(descriptor), "An instance for the descriptor %s was already seeded in this scope. Old instance: %s New instance: %s", descriptor, this.store.get(descriptor), value);
            return (T)this.store.put(descriptor, value);
        }

        public <T> void remove(ForeignDescriptor descriptor) {
            Object removed = this.store.remove(descriptor);
            if (removed != null) {
                descriptor.dispose(removed);
            }
        }

        public boolean contains(ForeignDescriptor provider) {
            return this.store.containsKey(provider);
        }

        public void release() {
            if (this.referenceCounter.decrementAndGet() < 1) {
                try {
                    new HashSet<ForeignDescriptor>(this.store.keySet()).forEach(this::remove);
                }
                catch (Throwable throwable) {
                    logger.debugLog("Released scope instance {0}", this);
                    throw throwable;
                }
                logger.debugLog("Released scope instance {0}", this);
            }
        }

        public String toString() {
            return "Instance{id=" + this.id + ", referenceCounter=" + this.referenceCounter + ", store size=" + this.store.size() + '}';
        }
    }

    public static class RequestScopeConfigurator
    implements BootstrapConfigurator {
        @Override
        public void init(InjectionManager injectionManagerFactory, BootstrapBag bootstrapBag) {
            bootstrapBag.setRequestScope(new RequestScope());
            injectionManagerFactory.register((Binding)Bindings.service(bootstrapBag.getRequestScope()).to(RequestScope.class));
        }
    }
}

