/*
 * Copyright (c) 2024 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package org.glassfish.jersey.innate.inject;

/**
 * Very Innate information of Injection Bindings, do not use outside of Jersey, the IDs are a subject of a change.
 */
public enum InjectionIds {
    COMMON_CONFIGURATION(1000),
    COMMON_PROPERTIES_DELEGATE(1001),
    COMMON_CONTEXT_RESOLVERS(1014),
    COMMON_EXCEPTION_MAPPERS(1015),
    COMMON_EXECUTOR_SERVICE_CLIENT(1011),
    COMMON_EXECUTOR_SERVICE_SERVER(1111),
    COMMON_SCHEDULED_EXECUTOR_SERVICE_CLIENT(1013),
    COMMON_SCHEDULED_EXECUTOR_SERVICE_SERVER(1113),
    COMMON_PROVIDERS_CLIENT(1016),
    COMMON_PROVIDERS_SERVER(1116),

    CLIENT_AGGREGATED_PROVIDER(2010),
    CLIENT_MESSAGE_BODY_WORKERS(2020),
    CLIENT_CLIENT_CONFIG(2101),
    CLIENT_CLIENT_REQUEST(2102),
    CLIENT_CLIENT_REQUEST_REF_FACTORY(2103),
    CLIENT_HTTP_HEADERS(2104), // !
    CLIENT_CHUNKED_INPUT_READER(2105), // MBR
    CLIENT_PARAMETER_UPDATER_PROVIDER(2011),
    CLIENT_EXECUTOR_SERVICE_PROVIDER(2020),
    CLIENT_SCHEDULED_EXECUTOR_SERVICE_PROVIDER(2021),
    CLIENT_BYTE_ARRAY_PROVIDER(2030), // MBW & MBR
    CLIENT_FILE_PROVIDER(2031), // MBW & MBR
    CLIENT_PATH_PROVIDER(2040), // MBW & MBR
    CLIENT_MULTIVALUED_MAP_PROVIDER(2032), // MBW & MBR
    CLIENT_FORM_PROVIDER(2033), // MBW & MBR
    CLIENT_INPUT_STREAM_PROVIDER(2034), // MBW & MBR
    CLIENT_BASIC_TYPES_PROVIDER(2035), // MBW & MBR
    CLIENT_READER_PROVIDER(2036), // MBW & MBR
    CLIENT_STRING_MESSAGE_PROVIDER(2037), // MBW & MBR
    CLIENT_ENUM_MESSAGE_PROVIDER(2038), // MBW & MBR
    CLIENT_STREAMING_OUTPUT_PROVIDER(2039), // MBW
    CLIENT_CACHE_CONTROL_PROVIDER(2050), // HeaderDelegateProvider
    CLIENT_COOKIE_PROVIDER(2051), // HeaderDelegateProvider
    CLIENT_DATE_PROVIDER(2052), // HeaderDelegateProvider
    CLIENT_ENTITY_TAG_PROVIDER(2053), // HeaderDelegateProvider
    CLIENT_LINK_PROVIDER(2054), // HeaderDelegateProvider
    CLIENT_LOCALE_PROVIDER(2055), // HeaderDelegateProvider
    CLIENT_MEDIA_TYPE_PROVIDER(2056), // HeaderDelegateProvider
    CLIENT_NEW_COOKIE_PROVIDER(2057), // HeaderDelegateProvider
    CLIENT_STRING_HEADER_PROVIDER(2058), // HeaderDelegateProvider
    CLIENT_URI_PROVIDER(2059), // HeaderDelegateProvider
    CLIENT_DATA_SOURCE_PROVIDER(2070), // MBW & MBR
    CLIENT_DOM_SOURCE_READER(2071), // MBR
    CLIENT_RENDERED_IMAGE_PROVIDER(2072), // MBW & MBR
    CLIENT_SAX_SOURCE_READER(2073), // MBR
    CLIENT_SOURCE_WRITER(2074), // MBW
    CLIENT_STREAM_SOURCE_READER(2075), // MBR

    SERVER_AGGREGATED_PROVIDER(3010),
    SERVER_MESSAGE_BODY_WORKERS(3020),
    SERVER_BYTE_ARRAY_PROVIDER(3030), // MBW & MBR
    SERVER_FILE_PROVIDER(3031), // MBW & MBR
    SERVER_PATH_PROVIDER(3040), // MBW & MBR
    SERVER_MULTIVALUED_MAP_PROVIDER(3032), // MBW & MBR
    SERVER_FORM_PROVIDER(3033), // MBW & MBR
    SERVER_INPUT_STREAM_PROVIDER(3034), // MBW & MBR
    SERVER_BASIC_TYPES_PROVIDER(3035), // MBW & MBR
    SERVER_READER_PROVIDER(3036), // MBW & MBR
    SERVER_STRING_MESSAGE_PROVIDER(3037), // MBW & MBR
    SERVER_ENUM_MESSAGE_PROVIDER(3038), // MBW & MBR
    SERVER_STREAMING_OUTPUT_PROVIDER(3039), // MBW
    SERVER_CACHE_CONTROL_PROVIDER(3050), // HeaderDelegateProvider
    SERVER_COOKIE_PROVIDER(3051), // HeaderDelegateProvider
    SERVER_DATE_PROVIDER(3052), // HeaderDelegateProvider
    SERVER_ENTITY_TAG_PROVIDER(3053), // HeaderDelegateProvider
    SERVER_LINK_PROVIDER(3054), // HeaderDelegateProvider
    SERVER_LOCALE_PROVIDER(3055), // HeaderDelegateProvider
    SERVER_MEDIA_TYPE_PROVIDER(3056), // HeaderDelegateProvider
    SERVER_NEW_COOKIE_PROVIDER(3057), // HeaderDelegateProvider
    SERVER_STRING_HEADER_PROVIDER(3058), // HeaderDelegateProvider
    SERVER_URI_PROVIDER(3059), // HeaderDelegateProvider

    SERVER_DATA_SOURCE_PROVIDER(3070), // MBW & MBR
    SERVER_DOM_SOURCE_READER(3071), // MBR
    SERVER_RENDERED_IMAGE_PROVIDER(3072), // MBW & MBR
    SERVER_SAX_SOURCE_READER(3073), // MBR
    SERVER_SOURCE_WRITER(3074), // MBW
    SERVER_STREAM_SOURCE_READER(3075), // MBR
    SERVER_MULTIVALUED_PARAMETER_EXTRACTOR_PROVIDER(3111),
    SERVER_RESOURCE_CONTEXT(3112),
    SERVER_ASYNC_RESPONSE_VALUE_PARAM_PROVIDER(3120),
    SERVER_COOKIE_VALUE_PARAM_PROVIDER(3121),
    SERVER_FORM_VALUE_PARAM_PROVIDER(3122),
    SERVER_HEADER_VALUE_PARAM_PROVIDER(3123),
    SERVER_MATRIX_VALUE_PARAM_PROVIDER(3124),
    SERVER_PATH_VALUE_PARAM_PROVIDER(3125),
    SERVER_QUERY_VALUE_PARAM_PROVIDER(3126),
    SERVER_WEB_TARGET_VALUE_PARAM_PROVIDER(3127),
    SERVER_BEAN_VALUE_PARAM_PROVIDER(3128),
    SERVER_ENTITY_VALUE_PARAM_PROVIDER(3129),
    SERVER_CONTEXT_VALUE_PARAM_PROVIDER(3130),
    SERVER_ASYNC_RESOLVER(3140),
    SERVER_COOKIE_RESOLVER(3141),
    SERVER_FORM_RESOLVER(3142),
    SERVER_HEADER_RESOLVER(3143),
    SERVER_MATRIX_RESOLVER(3144),
    SERVER_PATH_RESOLVER(3145),
    SERVER_QUERY_RESOLVER(3146),
    SERVER_WEB_TARGET_RESOLVER(3147),
    SERVER_BEAN_RESOLVER(3148),
    SERVER_APPLICATION_HANDLER(3180),
    SERVER_APPLICATION(3190),
    SERVER_OPTIONS_METHOD_PROCESSOR(3201),

    SERVLET_PERSISTANCE_UNIT_INJECTION_RESOLVER(4001),
    SERVLET_FILTER_CONFIG(4002),
    SERVLET_SERVLET_CONFIG(4003),
    SERVLET_WEB_CONFIG(4004),
    SERVLET_HTTP_SERVLET_REQUEST(4010),
    SERVLET_HTTP_SERVLET_REQUEST_REF(4011),
    SERVLET_HTTP_SERVLET_RESPONSE(4012),
    SERVLET_HTTP_SERVLET_RESPONSE_REF(4013),
    SERVLET_SERVLET_CONTEXT(4020),

    GRIZZLY_REQUEST_REFERENCING_FACTORY(5001),
    GRIZZLY_REQUEST(5002),
    GRIZZLY_RESPONSE_REFERENCING_FACTORY(5003),
    GRIZZLY_RESPONSE(5004);

    private int id;

    InjectionIds(int id) {
        this.id = id;
    }

    public int id() {
        return id;
    }

}
