/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2010-2012 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.glassfish.jersey.server.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/**
 * Abstraction for a sub-resource locator
 *
 * @author Marc Hadley (marc.hadley at sun.com)
 * @author Jakub Podlesak (jakub.podlesak at oracle.com)
 */
public class SubResourceLocator
        implements PathAnnotated, Parameterized, ResourceModelComponent {

    private ResourceClass resource;
    private Method method;

    private Annotation[] annotations;
    private PathValue uriPath;
    private List<Parameter> parameters;

    /**
     * Creates a new instance of SubResourceLocator
     */
    public SubResourceLocator(ResourceClass resource, Method method, PathValue uriPath, Annotation[] annotations) {
        this.resource = resource;
        this.method = method;
        this.annotations = annotations;
        this.uriPath =  uriPath;
        this.parameters = new ArrayList<Parameter>();
    }

    public Annotation[] getAnnotations() {
        return annotations.clone();
    }

    public Method getMethod() {
        return method;
    }

    public ResourceClass getResource() {
        return resource;
    }

    @Override
    public PathValue getPath() {
        return uriPath;
    }

    @Override
    public List<Parameter> getParameters() {
        return parameters;
    }

    @Override
    public boolean hasEntity() {
        for (Parameter p : getParameters()) {
            if (Parameter.Source.ENTITY == p.getSource()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void accept(ResourceModelVisitor visitor) {
        visitor.visitSubResourceLocator(this);
    }

    @Override
    public List<ResourceModelComponent> getComponents() {
        return null;
    }

    @Override
    public String toString() {
        return "AbstractSubResourceLocator("
                + getMethod().getDeclaringClass().getSimpleName() + "#" + getMethod().getName() + ")";
    }
}