/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import org.glassfish.jersey.server.Application;
import org.glassfish.jersey.server.ContainerProvider;

public final class ContainerFactory {
    private ContainerFactory() {
    }

    public static <A> A createContainer(Class<A> type, Application application) {
        A c;
        for (ContainerProvider cp : application.getServiceProviders().getCustom(ContainerProvider.class)) {
            c = cp.createContainer(type, application);
            if (c == null) continue;
            return c;
        }
        for (ContainerProvider cp : application.getServiceProviders().getDefault(ContainerProvider.class)) {
            c = cp.createContainer(type, application);
            if (c == null) continue;
            return c;
        }
        throw new IllegalArgumentException("No container provider supports the type " + type);
    }
}

