/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.internal.ExtractorException;
import org.glassfish.jersey.server.ParamException;
import org.glassfish.jersey.server.internal.inject.AbstractHttpContextValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.HttpContext;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.jvnet.hk2.annotations.Inject;

final class PathParamValueFactoryProvider
extends AbstractValueFactoryProvider<PathParam> {
    public PathParamValueFactoryProvider(@Inject MultivaluedParameterExtractorProvider mpep, @Inject Injector injector) {
        super(mpep, injector, Parameter.Source.PATH);
    }

    @Override
    public AbstractHttpContextValueFactory<?> createValueFactory(Parameter parameter) {
        ParameterizedType pt;
        Type[] targs;
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        if (parameter.getParameterClass() == PathSegment.class) {
            return new PathParamPathSegmentValueFactory(parameterName, !parameter.isEncoded());
        }
        if (parameter.getParameterClass() == List.class && parameter.getParameterType() instanceof ParameterizedType && (targs = (pt = (ParameterizedType)parameter.getParameterType()).getActualTypeArguments()).length == 1 && targs[0] == PathSegment.class) {
            return new PathParamListPathSegmentValueFactory(parameterName, !parameter.isEncoded());
        }
        MultivaluedParameterExtractor<?> e = this.getWithoutDefaultValue(parameter);
        if (e == null) {
            return null;
        }
        return new PathParamValueFactory(e, !parameter.isEncoded());
    }

    private static final class PathParamListPathSegmentValueFactory
    extends AbstractHttpContextValueFactory<List<PathSegment>> {
        private final String name;
        private final boolean decode;

        PathParamListPathSegmentValueFactory(String name, boolean decode) {
            this.name = name;
            this.decode = decode;
        }

        @Override
        protected List<PathSegment> get(HttpContext context) {
            return context.getUriInfo().getPathSegments(this.name, this.decode);
        }
    }

    private static final class PathParamPathSegmentValueFactory
    extends AbstractHttpContextValueFactory<PathSegment> {
        private final String name;
        private final boolean decode;

        PathParamPathSegmentValueFactory(String name, boolean decode) {
            this.name = name;
            this.decode = decode;
        }

        @Override
        protected PathSegment get(HttpContext context) {
            List ps = context.getUriInfo().getPathSegments(this.name, this.decode);
            if (ps.isEmpty()) {
                return null;
            }
            return (PathSegment)ps.get(ps.size() - 1);
        }
    }

    private static final class PathParamValueFactory
    extends AbstractHttpContextValueFactory<Object> {
        private final MultivaluedParameterExtractor<?> extractor;
        private final boolean decode;

        PathParamValueFactory(MultivaluedParameterExtractor<?> extractor, boolean decode) {
            this.extractor = extractor;
            this.decode = decode;
        }

        @Override
        protected Object get(HttpContext context) {
            try {
                return this.extractor.extract((MultivaluedMap<String, String>)context.getUriInfo().getPathParameters(this.decode));
            }
            catch (ExtractorException e) {
                throw new ParamException.PathParamException(e.getCause(), this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }
    }

    static final class InjectionResolver
    extends ParamInjectionResolver<PathParam> {
        public InjectionResolver() {
            super(PathParam.class, PathParamValueFactoryProvider.class);
        }
    }
}

