/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import com.google.common.collect.Lists;
import java.util.List;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Provider;
import org.glassfish.hk2.Services;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Tuples;
import org.glassfish.jersey.process.internal.TreeAcceptor;
import org.glassfish.jersey.server.internal.routing.RouterModule;

abstract class AbstractRouteToPathBuilder<T>
implements RouterModule.RouteToPathBuilder<T> {
    private final Services services;
    private final List<Pair<T, List<Factory<TreeAcceptor>>>> acceptedRoutes = Lists.newLinkedList();
    private List<Factory<TreeAcceptor>> currentAcceptors;

    protected AbstractRouteToPathBuilder(Services services, T pattern) {
        this.services = services;
        this._route(pattern);
    }

    protected final RouterModule.RouteToBuilder<T> _route(T pattern) {
        this.currentAcceptors = Lists.newLinkedList();
        this.acceptedRoutes.add(Tuples.of(pattern, this.currentAcceptors));
        return this;
    }

    protected final RouterModule.RouteToPathBuilder<T> _to(Factory<? extends TreeAcceptor> pa) {
        this.currentAcceptors.add(pa);
        return this;
    }

    protected List<Pair<T, List<Factory<TreeAcceptor>>>> acceptedRoutes() {
        return this.acceptedRoutes;
    }

    @Override
    public final RouterModule.RouteToPathBuilder<T> to(TreeAcceptor.Builder ab) {
        return this.to(ab.build());
    }

    @Override
    public final RouterModule.RouteToPathBuilder<T> to(TreeAcceptor a) {
        return this.to((Factory<TreeAcceptor>)Providers.factoryOf((Object)a));
    }

    @Override
    public final RouterModule.RouteToPathBuilder<T> to(Class<? extends TreeAcceptor> ca) {
        return this.to((Factory<TreeAcceptor>)Providers.asFactory((Provider)this.services.forContract(ca).getProvider()));
    }

    @Override
    public final RouterModule.RouteToPathBuilder<T> to(Factory<? extends TreeAcceptor> pa) {
        return this._to(pa);
    }

    @Override
    public abstract RouterModule.RouteToBuilder<T> route(String var1);

    @Override
    public RouterModule.RouteToBuilder<T> route(T pattern) {
        return this._route(pattern);
    }

    public TreeAcceptor.Builder child(TreeAcceptor child) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public abstract TreeAcceptor build();
}

