/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Request;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Tuples;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.process.internal.TreeAcceptor;
import org.glassfish.jersey.server.internal.routing.RouterModule;

public class PatternRouteAcceptor
implements TreeAcceptor {
    private final Factory<RouterModule.RoutingContext> contextProvider;
    private final List<Pair<Pattern, List<Factory<TreeAcceptor>>>> acceptedRoutes;

    private PatternRouteAcceptor(Factory<RouterModule.RoutingContext> contextProvider, List<Pair<Pattern, List<Factory<TreeAcceptor>>>> routes) {
        this.contextProvider = contextProvider;
        this.acceptedRoutes = routes;
    }

    public Pair<Request, Iterator<TreeAcceptor>> apply(Request request) {
        RouterModule.RoutingContext rc = (RouterModule.RoutingContext)this.contextProvider.get();
        String path = rc.getFinalMatchingGroup();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        for (Pair<Pattern, List<Factory<TreeAcceptor>>> acceptedRoute : this.acceptedRoutes) {
            Matcher m = ((Pattern)acceptedRoute.left()).matcher(path);
            if (!m.matches()) continue;
            rc.pushMatchResult(m.toMatchResult());
            List acceptorProviders = (List)acceptedRoute.right();
            Object acceptors = acceptorProviders.isEmpty() ? Iterators.emptyIterator() : (acceptorProviders.size() == 1 ? Iterators.transform((Iterator)Iterators.singletonIterator(acceptorProviders.iterator().next()), RouterModule.FACTORY_TO_ACCEPTOR_TRANSFORMATION) : Iterators.transform(acceptorProviders.iterator(), RouterModule.FACTORY_TO_ACCEPTOR_TRANSFORMATION));
            return Tuples.of((Object)request, (Object)acceptors);
        }
        return Stages.terminalTreeContinuation((Request)request);
    }

    public class Builder {
        private final Factory<RouterModule.RoutingContext> contextProvider;

        public Builder(Factory<RouterModule.RoutingContext> contextProvider) {
            this.contextProvider = contextProvider;
        }

        public PatternRouteAcceptor build(List<Pair<Pattern, List<Factory<TreeAcceptor>>>> routes) {
            return new PatternRouteAcceptor(this.contextProvider, routes);
        }
    }
}

