/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.server.model.ConsumesProducesEnabledComponent;
import org.glassfish.jersey.server.model.ResourceClass;
import org.glassfish.jersey.server.model.ResourceModelComponent;

public abstract class AbstractResourceMethod
implements ResourceModelComponent,
ConsumesProducesEnabledComponent {
    private ResourceClass resource;
    private String httpMethod;
    private List<MediaType> consumeMimeList;
    private List<MediaType> produceMimeList;
    private boolean isConsumesDeclared;
    private boolean isProducesDeclared;

    public AbstractResourceMethod(ResourceClass resource, String httpMethod) {
        this.resource = resource;
        this.httpMethod = httpMethod.toUpperCase();
        this.consumeMimeList = new ArrayList<MediaType>();
        this.produceMimeList = new ArrayList<MediaType>();
    }

    public ResourceClass getDeclaringResource() {
        return this.resource;
    }

    @Override
    public List<MediaType> getSupportedInputTypes() {
        return this.consumeMimeList;
    }

    @Override
    public void setAreInputTypesDeclared(boolean declared) {
        this.isConsumesDeclared = declared;
    }

    @Override
    public boolean areInputTypesDeclared() {
        return this.isConsumesDeclared;
    }

    @Override
    public List<MediaType> getSupportedOutputTypes() {
        return this.produceMimeList;
    }

    @Override
    public void setAreOutputTypesDeclared(boolean declared) {
        this.isProducesDeclared = declared;
    }

    @Override
    public boolean areOutputTypesDeclared() {
        return this.isProducesDeclared;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public List<ResourceModelComponent> getComponents() {
        return null;
    }

    public String toString() {
        return "GenericResourceMethod(" + this.resource.toString() + "#" + this.httpMethod + ")";
    }
}

