/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import com.google.common.collect.Iterators;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Tuples;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.message.internal.Responses;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.process.internal.TreeAcceptor;
import org.glassfish.jersey.server.internal.routing.RouterModule;
import org.glassfish.jersey.server.model.AbstractResourceMethod;
import org.glassfish.jersey.server.model.InvocableResourceMethod;
import org.glassfish.jersey.server.model.Parameter;

final class MultipleMethodAcceptor
implements TreeAcceptor {
    final Map<String, List<ConsumesProducesInflector>> method2InflectorMap;
    final MessageBodyWorkers workers;
    final Injector injector;
    final Factory<RouterModule.RoutingContext> routingCtxFactory;

    MultipleMethodAcceptor(Injector injector, MessageBodyWorkers msgWorkers, Factory<RouterModule.RoutingContext> routingCtxFactory, List<Pair<AbstractResourceMethod, Inflector<Request, Response>>> method2InflectorList) {
        this.injector = injector;
        this.workers = msgWorkers;
        this.routingCtxFactory = routingCtxFactory;
        this.method2InflectorMap = new HashMap<String, List<ConsumesProducesInflector>>();
        for (Pair<AbstractResourceMethod, Inflector<Request, Response>> methodInflector : method2InflectorList) {
            String httpMethod = ((AbstractResourceMethod)methodInflector.left()).getHttpMethod();
            if (!this.method2InflectorMap.containsKey(httpMethod)) {
                this.method2InflectorMap.put(httpMethod, new LinkedList());
            }
            this.addAllCombinations(this.method2InflectorMap.get(httpMethod), methodInflector);
        }
    }

    void addAllCombinations(List<ConsumesProducesInflector> list, Pair<AbstractResourceMethod, Inflector<Request, Response>> methodInflector) {
        InvocableResourceMethod invocableMethod;
        LinkedList<MediaType> effectiveInputTypes = new LinkedList<MediaType>();
        LinkedList<MediaType> effectiveOutputTypes = new LinkedList<MediaType>();
        AbstractResourceMethod resourceMethod = (AbstractResourceMethod)methodInflector.left();
        effectiveInputTypes.addAll(resourceMethod.getSupportedInputTypes());
        if (effectiveInputTypes.isEmpty() && this.workers != null && resourceMethod instanceof InvocableResourceMethod) {
            invocableMethod = (InvocableResourceMethod)((Object)resourceMethod);
            for (Parameter p : invocableMethod.getParameters()) {
                if (p.getSource() != Parameter.Source.ENTITY) continue;
                Type paramType = p.getParameterType();
                Class<?> paramClass = p.getParameterClass();
                effectiveInputTypes.addAll(this.workers.getMessageBodyReaderMediaTypes(paramClass, paramType, p.getDeclaredAnnotations()));
            }
        }
        if (effectiveInputTypes.isEmpty()) {
            effectiveInputTypes.add(MediaType.valueOf((String)"*/*"));
        }
        effectiveOutputTypes.addAll(resourceMethod.getSupportedOutputTypes());
        if (effectiveOutputTypes.isEmpty() && this.workers != null && resourceMethod instanceof InvocableResourceMethod) {
            invocableMethod = (InvocableResourceMethod)((Object)resourceMethod);
            Type returnType = invocableMethod.getGenericReturnType();
            Class returnClass = invocableMethod.getReturnType();
            effectiveOutputTypes.addAll(this.workers.getMessageBodyWriterMediaTypes(returnClass, returnType, invocableMethod.getMethod().getDeclaredAnnotations()));
        }
        if (effectiveOutputTypes.isEmpty()) {
            effectiveOutputTypes.add(MediaType.valueOf((String)"*/*"));
        }
        for (MediaType consumes : effectiveInputTypes) {
            for (MediaType produces : effectiveOutputTypes) {
                list.add(new ConsumesProducesInflector(consumes, produces, (Inflector<Request, Response>)((Inflector)methodInflector.right())));
            }
        }
        Collections.sort(list, new Comparator<ConsumesProducesInflector>(){

            @Override
            public int compare(ConsumesProducesInflector i1, ConsumesProducesInflector i2) {
                int consumesComparsion = MediaTypes.MEDIA_TYPE_COMPARATOR.compare(i1.consumes, i2.consumes);
                return consumesComparsion != 0 ? consumesComparsion : MediaTypes.MEDIA_TYPE_COMPARATOR.compare(i1.produces, i2.produces);
            }
        });
    }

    public Pair<Request, Iterator<TreeAcceptor>> apply(Request request) {
        List acceptableMediaTypes;
        List<ConsumesProducesInflector> inflectors = this.method2InflectorMap.get(request.getMethod());
        if (inflectors == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build());
        }
        LinkedList<ConsumesProducesInflector> satisfyingInflectors = new LinkedList<ConsumesProducesInflector>();
        for (ConsumesProducesInflector cpi : inflectors) {
            if (!cpi.isConsumable(request)) continue;
            satisfyingInflectors.add(cpi);
        }
        if (satisfyingInflectors.isEmpty()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).build());
        }
        try {
            acceptableMediaTypes = request.getHeaders().getAcceptableMediaTypes();
        }
        catch (RuntimeException re) {
            throw new WebApplicationException(Response.status((int)400).entity((Object)re.getMessage()).build());
        }
        for (MediaType acceptableMediaType : acceptableMediaTypes) {
            for (ConsumesProducesInflector satisfiable : satisfyingInflectors) {
                if (!satisfiable.produces.isCompatible(acceptableMediaType)) continue;
                final MediaType effectiveResponseType = this.typeNotSpecific(satisfiable.produces) ? MediaTypes.mostSpecific((MediaType)acceptableMediaType, (MediaType)satisfiable.produces) : satisfiable.produces;
                ((RouterModule.RoutingContext)this.routingCtxFactory.get()).setEffectiveAcceptableType(effectiveResponseType);
                final Inflector<Request, Response> inflector = satisfiable.inflector;
                return Tuples.of((Object)request, (Object)Iterators.singletonIterator((Object)Stages.asTreeAcceptor((Inflector)new Inflector<Request, Response>(){

                    public Response apply(Request request) {
                        MultipleMethodAcceptor.this.injector.inject((Object)inflector);
                        return MultipleMethodAcceptor.this.typeNotSpecific(effectiveResponseType) ? (Response)inflector.apply((Object)request) : MultipleMethodAcceptor.this.responseWithContentTypeHeader(effectiveResponseType, (Response)inflector.apply((Object)request));
                    }
                })));
            }
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build());
    }

    private Response responseWithContentTypeHeader(MediaType mt, Response response) {
        return Responses.toBuilder((Response)response).header("Content-Type", (Object)mt).build();
    }

    private boolean typeNotSpecific(MediaType effectiveResponseType) {
        return effectiveResponseType.isWildcardType() || effectiveResponseType.isWildcardSubtype();
    }

    class ConsumesProducesInflector {
        MediaType consumes;
        MediaType produces;
        Inflector<Request, Response> inflector;

        ConsumesProducesInflector(MediaType consumes, MediaType produces, Inflector<Request, Response> inflector) {
            this.inflector = inflector;
            this.consumes = consumes;
            this.produces = produces;
        }

        boolean isConsumable(Request request) {
            MediaType contentType = request.getHeaders().getMediaType();
            return contentType == null || this.consumes.isCompatible(contentType);
        }

        public String toString() {
            return "ConsumesProducesInflector{consumes=" + this.consumes + ", produces=" + this.produces + '}';
        }
    }
}

