/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.jersey.server.model.AbstractResourceMethod;
import org.glassfish.jersey.server.model.InvocableResourceMethod;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.Parameterized;
import org.glassfish.jersey.server.model.ResourceClass;
import org.glassfish.jersey.server.model.ResourceModelVisitor;

public class ResourceMethod
extends AbstractResourceMethod
implements Parameterized,
InvocableResourceMethod {
    private Method method;
    private List<Parameter> parameters;
    private Class returnType;
    private Type genericReturnType;

    public ResourceMethod(ResourceClass resource, Method method, Class returnType, Type genericReturnType, String httpMethod, Annotation[] markers) {
        super(resource, httpMethod);
        this.method = method;
        this.returnType = returnType;
        this.genericReturnType = genericReturnType;
        this.parameters = new ArrayList<Parameter>();
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Class getReturnType() {
        return this.returnType;
    }

    @Override
    public Type getGenericReturnType() {
        return this.genericReturnType;
    }

    @Override
    public boolean hasEntity() {
        for (Parameter p : this.getParameters()) {
            if (Parameter.Source.ENTITY != p.getSource()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public void accept(ResourceModelVisitor visitor) {
        visitor.visitResourceMethod(this);
    }

    @Override
    public String toString() {
        return "AbstractResourceMethod(" + this.method.getDeclaringClass().getSimpleName() + "#" + this.method.getName() + ")";
    }
}

