/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.internal.routing.RouterModule;
import org.glassfish.jersey.server.model.InvocableResourceMethod;
import org.glassfish.jersey.server.model.ResourceMethodDispatcherFactory;
import org.glassfish.jersey.server.model.ResourceMethodInvocationHandlerFactory;
import org.glassfish.jersey.server.spi.internal.ResourceMethodDispatcher;
import org.glassfish.jersey.server.spi.internal.ResourceMethodInvocationHandlerProvider;
import org.jvnet.hk2.annotations.Inject;

class ResourceMethodInvoker
implements Inflector<Request, Response> {
    private final Injector injector;
    private Factory<RouterModule.RoutingContext> routingContextFactory;
    private final InvocableResourceMethod method;
    private final ResourceMethodDispatcher dispatcher;

    private ResourceMethodInvoker(Injector injector, Factory<RouterModule.RoutingContext> routingContextFactory, ResourceMethodDispatcher.Provider dispatcherProvider, ResourceMethodInvocationHandlerProvider invocationHandlerProvider, InvocableResourceMethod method) {
        this.injector = injector;
        this.routingContextFactory = routingContextFactory;
        this.method = method;
        this.dispatcher = dispatcherProvider.create(method, invocationHandlerProvider.create(method));
    }

    public Response apply(Request request) {
        Object resource = ((RouterModule.RoutingContext)this.routingContextFactory.get()).peekMatchedResource();
        Response response = this.dispatcher.dispatch(resource, request);
        ((RouterModule.RoutingContext)this.routingContextFactory.get()).setResponseMethodType(this.method.getGenericReturnType());
        ((RouterModule.RoutingContext)this.routingContextFactory.get()).setResponseMethodAnnotations(this.method.getMethod().getDeclaredAnnotations());
        return response;
    }

    static class Builder {
        @Inject
        private Injector injector;
        @Inject
        private Factory<RouterModule.RoutingContext> routingContextFactory;
        @Inject
        private ResourceMethodDispatcherFactory dispatcherProviderFactory;
        @Inject
        private ResourceMethodInvocationHandlerFactory invocationHandlerProviderFactory;

        Builder() {
        }

        public ResourceMethodInvoker build(InvocableResourceMethod method) {
            return new ResourceMethodInvoker(this.injector, this.routingContextFactory, this.dispatcherProviderFactory, this.invocationHandlerProviderFactory, method);
        }
    }
}

