/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.glassfish.jersey.server.model.ResourceModelComponent;
import org.glassfish.jersey.server.model.ResourceModelIssue;
import org.glassfish.jersey.server.model.ResourceModelVisitor;

public abstract class ResourceModelValidator
implements ResourceModelVisitor {
    final List<ResourceModelIssue> issueList = new LinkedList<ResourceModelIssue>();

    public List<ResourceModelIssue> getIssueList() {
        return this.issueList;
    }

    public boolean fatalIssuesFound() {
        for (ResourceModelIssue issue : this.getIssueList()) {
            if (!issue.isFatal()) continue;
            return true;
        }
        return false;
    }

    public void cleanIssueList() {
        this.issueList.clear();
    }

    public void validate(ResourceModelComponent component) {
        component.accept(this);
        List<ResourceModelComponent> componentList = component.getComponents();
        if (null != componentList) {
            for (ResourceModelComponent subcomponent : componentList) {
                this.validate(subcomponent);
            }
        }
    }

    public static class ModelException
    extends RuntimeException {
        public final List<ResourceModelIssue> issues;

        public ModelException(List<ResourceModelIssue> issues) {
            this.issues = new ArrayList<ResourceModelIssue>(issues);
        }
    }
}

