/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Tuples;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.TreeAcceptor;
import org.glassfish.jersey.server.internal.routing.RouterModule;
import org.glassfish.jersey.server.model.AbstractResourceMethod;
import org.glassfish.jersey.server.model.InflectorBasedResourceMethod;
import org.glassfish.jersey.server.model.InvocableResourceMethod;
import org.glassfish.jersey.server.model.MultipleMethodAcceptor;
import org.glassfish.jersey.server.model.ResourceClass;
import org.glassfish.jersey.server.model.ResourceConstructor;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceMethodInvoker;
import org.glassfish.jersey.server.model.RuntimeModelProvider;
import org.glassfish.jersey.server.model.SubResourceLocator;
import org.glassfish.jersey.server.model.SubResourceLocatorAcceptor;
import org.glassfish.jersey.server.model.SubResourceMethod;
import org.glassfish.jersey.uri.PathPattern;
import org.jvnet.hk2.annotations.Inject;

public class RuntimeModelFromSubResource
extends RuntimeModelProvider {
    @Inject
    private RouterModule.RootRouteBuilder<PathPattern> rootBuilder;
    @Inject
    private ResourceMethodInvoker.Builder resourceMethodInvokerBuilder;
    @Inject
    Injector injector;
    @Inject
    Services services;
    private MessageBodyWorkers workers;
    @Inject
    Factory<RouterModule.RoutingContext> ctxFactory;
    private RouterModule.RouteToPathBuilder<PathPattern> lastRoutedBuilder;
    private Map<PathPattern, List<Pair<AbstractResourceMethod, Inflector<Request, Response>>>> method2Inflector = new HashMap<PathPattern, List<Pair<AbstractResourceMethod, Inflector<Request, Response>>>>();
    private Map<PathPattern, Pair<SubResourceLocator, TreeAcceptor>> locator2Acceptor = new HashMap<PathPattern, Pair<SubResourceLocator, TreeAcceptor>>();

    RuntimeModelFromSubResource(Factory<RouterModule.RoutingContext> ctxFactory, MessageBodyWorkers msgBodyWorkers) {
        this.ctxFactory = ctxFactory;
        this.workers = msgBodyWorkers;
    }

    @Override
    public TreeAcceptor getRuntimeModel() {
        TreeSet<PathPattern> pathPatterns;
        if (!this.method2Inflector.isEmpty()) {
            pathPatterns = new TreeSet<PathPattern>(PathPattern.COMPARATOR);
            pathPatterns.addAll(this.method2Inflector.keySet());
            for (PathPattern path : pathPatterns) {
                List<Pair<AbstractResourceMethod, Inflector<Request, Response>>> methodInflectors = this.method2Inflector.get(path);
                this.lastRoutedBuilder = (this.lastRoutedBuilder == null ? this.rootBuilder : this.lastRoutedBuilder).route(path).to(new MultipleMethodAcceptor(this.injector, this.workers, this.ctxFactory, methodInflectors));
            }
            this.method2Inflector.clear();
        }
        if (!this.locator2Acceptor.isEmpty()) {
            pathPatterns = new TreeSet(PathPattern.COMPARATOR);
            pathPatterns.addAll(this.locator2Acceptor.keySet());
            for (PathPattern path : pathPatterns) {
                this.lastRoutedBuilder = this.routedBuilder().route(path).to((TreeAcceptor)this.locator2Acceptor.get(path).right());
            }
            this.locator2Acceptor.clear();
        }
        return this.lastRoutedBuilder.build();
    }

    private RouterModule.RouteBuilder<PathPattern> routedBuilder() {
        return this.lastRoutedBuilder == null ? this.rootBuilder : this.lastRoutedBuilder;
    }

    @Override
    public void visitResourceClass(ResourceClass resource) {
    }

    public void setWorkers(MessageBodyWorkers workers) {
        this.workers = workers;
    }

    @Override
    public void visitResourceMethod(ResourceMethod method) {
        this.addMethodInflector(PathPattern.EMPTY_PATH, method, this.createInflector(method));
    }

    private Inflector<Request, Response> createInflector(InvocableResourceMethod method) {
        return this.resourceMethodInvokerBuilder.build(method);
    }

    @Override
    public void visitSubResourceMethod(SubResourceMethod method) {
        PathPattern subResMethodPathPattern = new PathPattern(method.getPath().getValue(), PathPattern.RightHandPath.capturingZeroSegments);
        this.addMethodInflector(subResMethodPathPattern, method, this.createInflector(method));
    }

    private void addMethodInflector(PathPattern pathPattern, AbstractResourceMethod method, Inflector<Request, Response> inflector) {
        if (!this.method2Inflector.containsKey(pathPattern)) {
            this.method2Inflector.put(pathPattern, new LinkedList());
        }
        this.method2Inflector.get(pathPattern).add((Pair<AbstractResourceMethod, Inflector<Request, Response>>)Tuples.of((Object)method, inflector));
    }

    @Override
    public void visitSubResourceLocator(SubResourceLocator locator) {
        this.locator2Acceptor.put(new PathPattern(locator.getPath().getValue()), (Pair<SubResourceLocator, TreeAcceptor>)Tuples.of((Object)locator, (Object)new SubResourceLocatorAcceptor(this.injector, this.services, this.ctxFactory, this.workers, locator)));
    }

    @Override
    public void visitResourceConstructor(ResourceConstructor constructor) {
    }

    @Override
    public void visitInflectorResourceMethod(InflectorBasedResourceMethod method) {
    }
}

