/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Tuples;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.TreeAcceptor;
import org.glassfish.jersey.server.internal.routing.RouterModule;
import org.glassfish.jersey.server.model.AbstractResourceMethod;
import org.glassfish.jersey.server.model.InflectorBasedResourceMethod;
import org.glassfish.jersey.server.model.InvocableResourceMethod;
import org.glassfish.jersey.server.model.MultipleMethodAcceptor;
import org.glassfish.jersey.server.model.PushResourceAndDelegateTreeAcceptor;
import org.glassfish.jersey.server.model.ResourceClass;
import org.glassfish.jersey.server.model.ResourceConstructor;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceMethodInvoker;
import org.glassfish.jersey.server.model.RuntimeModelProvider;
import org.glassfish.jersey.server.model.SubResourceLocator;
import org.glassfish.jersey.server.model.SubResourceLocatorAcceptor;
import org.glassfish.jersey.server.model.SubResourceMethod;
import org.glassfish.jersey.uri.PathPattern;
import org.jvnet.hk2.annotations.Inject;

public class RuntimeModelProviderFromAbstractModel
extends RuntimeModelProvider {
    @Inject
    private RouterModule.RootRouteBuilder<PathPattern> rootBuilder;
    @Inject
    private ResourceMethodInvoker.Builder resourceMethodInvokerBuilder;
    @Inject
    Injector injector;
    @Inject
    Services services;
    private MessageBodyWorkers workers;
    @Inject
    Factory<RouterModule.RoutingContext> ctxFactory;
    private String currentResourcePath = null;
    private RouterModule.RouteToPathBuilder<PathPattern> lastRoutedBuilder;
    private Map<PathPattern, List<Pair<AbstractResourceMethod, Inflector<Request, Response>>>> method2Inflector = new HashMap<PathPattern, List<Pair<AbstractResourceMethod, Inflector<Request, Response>>>>();
    private Map<PathPattern, Pair<SubResourceLocator, TreeAcceptor>> locator2Acceptor = new HashMap<PathPattern, Pair<SubResourceLocator, TreeAcceptor>>();

    public RuntimeModelProviderFromAbstractModel() {
    }

    private RuntimeModelProviderFromAbstractModel(Factory<RouterModule.RoutingContext> ctxFactory, MessageBodyWorkers msgBodyWorkers) {
        this.ctxFactory = ctxFactory;
        this.workers = msgBodyWorkers;
    }

    @Override
    public TreeAcceptor getRuntimeModel() {
        TreeSet<PathPattern> pathPatterns;
        if (!this.method2Inflector.isEmpty()) {
            pathPatterns = new TreeSet<PathPattern>(PathPattern.COMPARATOR);
            pathPatterns.addAll(this.method2Inflector.keySet());
            for (PathPattern path : pathPatterns) {
                List<Pair<AbstractResourceMethod, Inflector<Request, Response>>> methodInflectors = this.method2Inflector.get(path);
                this.lastRoutedBuilder = (this.lastRoutedBuilder == null ? this.rootBuilder : this.lastRoutedBuilder).route(path).to(new PushResourceAndDelegateTreeAcceptor(this.injector, this.ctxFactory, this.getDeclaringResource(methodInflectors), new MultipleMethodAcceptor(this.injector, this.workers, this.ctxFactory, methodInflectors)));
            }
            this.method2Inflector.clear();
        }
        if (!this.locator2Acceptor.isEmpty()) {
            pathPatterns = new TreeSet(PathPattern.COMPARATOR);
            pathPatterns.addAll(this.locator2Acceptor.keySet());
            for (PathPattern path : pathPatterns) {
                this.lastRoutedBuilder = this.routedBuilder().route(path).to(new PushResourceAndDelegateTreeAcceptor(this.injector, this.ctxFactory, ((SubResourceLocator)this.locator2Acceptor.get(path).left()).getResource(), (TreeAcceptor)this.locator2Acceptor.get(path).right()));
            }
            this.locator2Acceptor.clear();
        }
        return this.rootBuilder.root(this.lastRoutedBuilder.build());
    }

    private RouterModule.RouteBuilder<PathPattern> routedBuilder() {
        return this.lastRoutedBuilder == null ? this.rootBuilder : this.lastRoutedBuilder;
    }

    @Override
    public void visitResourceClass(ResourceClass resource) {
        if (resource.isRootResource()) {
            this.currentResourcePath = resource.getPath().getValue();
        }
    }

    public void setWorkers(MessageBodyWorkers workers) {
        this.workers = workers;
    }

    @Override
    public void visitResourceMethod(ResourceMethod method) {
        if (method.getDeclaringResource().isRootResource()) {
            this.addMethodInflector(this.joinUriPaths(this.currentResourcePath), method, this.createInflector(method));
        } else {
            this.addMethodInflector("/", method, this.createInflector(method));
        }
    }

    private Inflector<Request, Response> createInflector(InvocableResourceMethod method) {
        return this.resourceMethodInvokerBuilder.build(method);
    }

    @Override
    public void visitSubResourceMethod(SubResourceMethod method) {
        if (method.getDeclaringResource().isRootResource()) {
            String subResMethodPath = this.joinUriPaths(this.currentResourcePath, method.getPath().getValue());
            this.addMethodInflector(subResMethodPath, method, this.createInflector(method));
        } else {
            String subResMethodPath = this.joinUriPaths(method.getPath().getValue());
            this.addMethodInflector(subResMethodPath, method, this.createInflector(method));
        }
    }

    private void addMethodInflector(String path, AbstractResourceMethod method, Inflector<Request, Response> inflector) {
        PathPattern pathPattern = new PathPattern(path, PathPattern.RightHandPath.capturingZeroSegments);
        if (!this.method2Inflector.containsKey(pathPattern)) {
            this.method2Inflector.put(pathPattern, new LinkedList());
        }
        this.method2Inflector.get(pathPattern).add((Pair<AbstractResourceMethod, Inflector<Request, Response>>)Tuples.of((Object)method, inflector));
    }

    @Override
    public void visitSubResourceLocator(SubResourceLocator locator) {
        this.locator2Acceptor.put(new PathPattern(this.joinUriPaths(this.currentResourcePath, locator.getPath().getValue())), (Pair<SubResourceLocator, TreeAcceptor>)Tuples.of((Object)locator, (Object)new SubResourceLocatorAcceptor(this.injector, this.services, this.ctxFactory, this.workers, locator)));
    }

    @Override
    public void visitResourceConstructor(ResourceConstructor constructor) {
    }

    @Override
    public void visitInflectorResourceMethod(InflectorBasedResourceMethod method) {
        this.addMethodInflector(this.currentResourcePath, method, method.inflector);
    }

    private ResourceClass getDeclaringResource(List<Pair<AbstractResourceMethod, Inflector<Request, Response>>> method2InflectorList) {
        for (Pair<AbstractResourceMethod, Inflector<Request, Response>> methodInflector : method2InflectorList) {
            if (!(methodInflector.left() instanceof InvocableResourceMethod)) continue;
            return ((AbstractResourceMethod)methodInflector.left()).getDeclaringResource();
        }
        return null;
    }

    private String joinUriPaths(String ... path) {
        StringBuilder result = new StringBuilder("");
        for (String p : path) {
            this.trimTrailingSlashes(result);
            result.append('/');
            result.append(this.trimStartingSlashes(p));
        }
        return result.toString();
    }

    private void trimTrailingSlashes(StringBuilder result) {
        while (result.length() > 0 && result.charAt(result.length() - 1) == '/') {
            result.deleteCharAt(result.length() - 1);
        }
    }

    private String trimStartingSlashes(String s) {
        if (s.isEmpty()) {
            return s;
        }
        if (s.equals("/")) {
            return "";
        }
        int i = 0;
        while (s.charAt(i) == '/') {
            ++i;
        }
        return s.substring(i);
    }
}

