/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.Request;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.internal.MappableException;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.process.internal.TreeAcceptor;
import org.glassfish.jersey.server.internal.routing.RouterModule;
import org.glassfish.jersey.server.model.IntrospectionModeller;
import org.glassfish.jersey.server.model.ResourceClass;
import org.glassfish.jersey.server.model.RuntimeModelFromSubResource;
import org.glassfish.jersey.server.model.SubResourceLocator;
import org.glassfish.jersey.server.spi.internal.MethodParameterHelper;

public class SubResourceLocatorAcceptor
implements TreeAcceptor {
    Services services;
    SubResourceLocator locator;
    final List<Factory<?>> valueProviders;
    Injector injector;
    Factory<RouterModule.RoutingContext> routingContextFactory;
    MessageBodyWorkers workers;

    public SubResourceLocatorAcceptor(Injector injector, Services services, Factory<RouterModule.RoutingContext> routingContextFactory, MessageBodyWorkers workers, SubResourceLocator locator) {
        this.injector = injector;
        this.locator = locator;
        this.routingContextFactory = routingContextFactory;
        this.workers = workers;
        this.services = services;
        this.valueProviders = MethodParameterHelper.createValueProviders(services, locator);
    }

    public Pair<Request, Iterator<TreeAcceptor>> apply(Request data) {
        Object subResource = this.getResource();
        RuntimeModelFromSubResource rmBuilder = new RuntimeModelFromSubResource(this.routingContextFactory, this.workers);
        this.injector.inject((Object)rmBuilder);
        ((RouterModule.RoutingContext)this.routingContextFactory.get()).pushMatchedResource(subResource);
        ((RouterModule.RoutingContext)this.routingContextFactory.get()).pushLeftHandPath();
        ResourceClass resourceClass = IntrospectionModeller.createResource(subResource.getClass());
        rmBuilder.process(resourceClass);
        return rmBuilder.getRuntimeModel().apply(data);
    }

    private Object getResource() {
        Object resource = ((RouterModule.RoutingContext)this.routingContextFactory.get()).peekMatchedResource();
        try {
            return this.locator.getMethod().invoke(resource, MethodParameterHelper.getParameterValues(this.valueProviders));
        }
        catch (IllegalAccessException ex) {
            throw new ProcessingException("Resource Java method invocation error.", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ProcessingException) {
                throw (ProcessingException)cause;
            }
            throw new MappableException(cause);
        }
        catch (UndeclaredThrowableException ex) {
            throw new ProcessingException("Resource Java method invocation error.", (Throwable)ex);
        }
        catch (ProcessingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MappableException((Throwable)ex);
        }
        catch (Throwable t) {
            throw new ProcessingException(t);
        }
    }
}

