/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.jersey.server.model.AbstractSubResourceMethod;
import org.glassfish.jersey.server.model.InvocableResourceMethod;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.Parameterized;
import org.glassfish.jersey.server.model.PathAnnotated;
import org.glassfish.jersey.server.model.PathValue;
import org.glassfish.jersey.server.model.ResourceClass;
import org.glassfish.jersey.server.model.ResourceModelVisitor;

public class SubResourceMethod
extends AbstractSubResourceMethod
implements PathAnnotated,
Parameterized,
InvocableResourceMethod {
    private Method method;
    private Class returnType;
    private Type genericReturnType;
    private Annotation[] annotations;
    private List<Parameter> parameters;

    public SubResourceMethod(ResourceClass resource, Method method, Class returnType, Type genericReturnType, PathValue uriPath, String httpMethod, Annotation[] markers) {
        super(resource, uriPath, httpMethod);
        this.method = method;
        this.returnType = returnType;
        this.genericReturnType = genericReturnType;
        this.annotations = markers;
        this.parameters = new ArrayList<Parameter>();
    }

    @Override
    public void accept(ResourceModelVisitor visitor) {
        visitor.visitSubResourceMethod(this);
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Class getReturnType() {
        return this.returnType;
    }

    @Override
    public Type getGenericReturnType() {
        return this.genericReturnType;
    }

    @Override
    public String toString() {
        return "AbstractSubResourceMethod(" + this.method.getDeclaringClass().getSimpleName() + "#" + this.method.getName() + ")";
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean hasEntity() {
        for (Parameter p : this.getParameters()) {
            if (Parameter.Source.ENTITY != p.getSource()) continue;
            return true;
        }
        return false;
    }
}

