/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.spi.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Services;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.Parameterized;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;

public class MethodParameterHelper {
    public static Object[] getParameterValues(List<Factory<?>> valueProviders) {
        Object[] params = new Object[valueProviders.size()];
        try {
            int index = 0;
            for (Factory<?> valueProvider : valueProviders) {
                params[index++] = valueProvider.get();
            }
            return params;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new ProcessingException("Exception obtaining parameters", (Throwable)e);
        }
    }

    public static List<Factory<?>> createValueProviders(Services services, Parameterized resourceMethod) {
        if (null == resourceMethod.getParameters() || 0 == resourceMethod.getParameters().size()) {
            return Collections.emptyList();
        }
        Set valueFactoryProviders = Providers.getProviders((Services)services, ValueFactoryProvider.class);
        boolean entityParamFound = false;
        ArrayList providers = new ArrayList(resourceMethod.getParameters().size());
        for (Parameter parameter : resourceMethod.getParameters()) {
            entityParamFound = entityParamFound || Parameter.Source.ENTITY == parameter.getSource();
            providers.add(MethodParameterHelper.getValueFactory(valueFactoryProviders, parameter));
        }
        if (!entityParamFound && Collections.frequency(providers, null) == 1) {
            Parameter parameter;
            int entityParamIndex = providers.lastIndexOf(null);
            parameter = resourceMethod.getParameters().get(entityParamIndex);
            if (Parameter.Source.UNKNOWN == parameter.getSource() && !parameter.isQualified()) {
                providers.set(entityParamIndex, MethodParameterHelper.getValueFactory(valueFactoryProviders, new SourceOverrideParameter(parameter, Parameter.Source.ENTITY)));
            }
        }
        return providers;
    }

    private static Factory<?> getValueFactory(Set<ValueFactoryProvider> valueFactoryProviders, Parameter parameter) {
        Factory<?> valueFactory = null;
        Iterator<ValueFactoryProvider> vfpIterator = valueFactoryProviders.iterator();
        while (valueFactory == null && vfpIterator.hasNext()) {
            valueFactory = vfpIterator.next().getValueFactory(parameter);
        }
        return valueFactory;
    }

    private static class SourceOverrideParameter
    extends Parameter {
        public SourceOverrideParameter(Parameter p, Parameter.Source overrideSource) {
            super(p.getAnnotations(), p.getAnnotation(), overrideSource, p.getSourceName(), p.getParameterType(), p.getParameterClass(), p.isEncoded(), p.getDefaultValue());
        }
    }
}

