/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.util.concurrent.Monitor;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import org.glassfish.hk2.BinderFactory;
import org.glassfish.hk2.DynamicBinderFactory;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Module;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.internal.ContextResolverFactory;
import org.glassfish.jersey.internal.ExceptionMapperFactory;
import org.glassfish.jersey.internal.MappableException;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.ServiceProviders;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.HeaderValueException;
import org.glassfish.jersey.message.internal.MessageBodyFactory;
import org.glassfish.jersey.message.internal.Requests;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.InflectorNotFoundException;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.InvocationContext;
import org.glassfish.jersey.process.internal.PreMatchRequestFilterAcceptor;
import org.glassfish.jersey.process.internal.RequestInvoker;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.TreeAcceptor;
import org.glassfish.jersey.server.ApplicationBuilder;
import org.glassfish.jersey.server.ContainerResponseWriterCallback;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.TimingOutInvocationCallback;
import org.glassfish.jersey.server.internal.routing.RouterModule;
import org.glassfish.jersey.server.model.RuntimeModelProvider;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.spi.ContextResolvers;
import org.glassfish.jersey.spi.ExceptionMappers;
import org.jvnet.hk2.annotations.Inject;

public final class Application
implements Inflector<Request, Future<Response>> {
    @Inject
    private PreMatchRequestFilterAcceptor preMatchFilterAcceptor;
    @Inject
    private Services services;
    @Inject
    private RequestScope requestScope;
    @Inject
    private RequestInvoker invoker;
    @Inject
    private Factory<RouterModule.RoutingContext> routingContextFactory;
    @Inject
    private References references;
    private volatile TreeAcceptor rootAcceptor;
    private final ApplicationModule applicationModule = new ApplicationModule();
    private boolean dirtyProviders = true;
    private final Monitor providersMonitor = new Monitor();
    private final Monitor.Guard providersConfigChanged = new Monitor.Guard(this.providersMonitor){

        public boolean isSatisfied() {
            return Application.this.dirtyProviders;
        }
    };

    public static Builder builder() {
        return new ApplicationBuilder(null);
    }

    public static Builder builder(@Nullable ResourceConfig resourceConfig) {
        return new ApplicationBuilder(resourceConfig);
    }

    Module module() {
        return this.applicationModule;
    }

    void setModelProvider(RuntimeModelProvider modelProvider) {
        this.rootAcceptor = modelProvider.getRuntimeModel();
    }

    void setRootAcceptor(TreeAcceptor root) {
        this.rootAcceptor = root;
    }

    public Future<Response> apply(Request request) {
        TimingOutInvocationCallback callback = new TimingOutInvocationCallback(){

            @Override
            protected Response handleFailure(Throwable exception) {
                return Application.handleFailure(exception);
            }

            @Override
            protected Response handleTimeout(InvocationContext context) {
                return Application.prepareTimeoutResponse(context);
            }
        };
        this.apply(request, callback);
        return callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply(Request request, InvocationCallback callback) {
        try {
            this.requestScope.enter();
            this.configureProviders();
            Pair pair = this.preMatchFilterAcceptor.apply(request);
            this.invoker.apply((Request)pair.left(), callback);
        }
        finally {
            this.requestScope.exit();
        }
    }

    public void apply(Request request, final ContainerResponseWriter responseWriter) {
        ContainerResponseWriterCallback callback = new ContainerResponseWriterCallback(request, responseWriter){

            @Override
            protected void writeResponse(Response response) {
                Application.this.writeResponse(responseWriter, this.request, response);
            }

            @Override
            protected void writeResponse(Throwable exception) {
                Application.this.writeResponse(responseWriter, this.request, Application.handleFailure(exception));
            }

            @Override
            protected void writeTimeoutResponse(InvocationContext context) {
                Application.this.writeResponse(responseWriter, this.request, Application.prepareTimeoutResponse(context));
            }
        };
        this.apply(request, callback);
        callback.suspendWriterIfRunning();
    }

    private static Response prepareTimeoutResponse(InvocationContext context) {
        Response response = context.getResponse();
        if (response == null) {
            response = Response.serverError().entity((Object)"Request processing has timed out.").type("text/plain").build();
        }
        return response;
    }

    private static Response handleFailure(Throwable failure) {
        Response.Status statusCode = Response.Status.INTERNAL_SERVER_ERROR;
        String message = failure.getMessage();
        if (failure instanceof ProcessingException) {
            if (failure instanceof HeaderValueException) {
                statusCode = Response.Status.BAD_REQUEST;
            } else if (failure instanceof InflectorNotFoundException) {
                statusCode = Response.Status.NOT_FOUND;
                message = "Requested resource not found.";
            }
        }
        if (statusCode == Response.Status.INTERNAL_SERVER_ERROR) {
            Logger.getLogger(Application.class.getName()).log(Level.SEVERE, message, failure);
        } else {
            Logger.getLogger(Application.class.getName()).log(Level.FINE, message, failure);
        }
        return Response.status((Response.StatusType)statusCode).entity((Object)message).type("text/plain").build();
    }

    private void writeResponse(ContainerResponseWriter writer, Request request, Response response) {
        try {
            boolean entityExists = response.hasEntity();
            if (response.getStatus() == 200 && !entityExists) {
                response = Response.fromResponse((Response)response).status(204).build();
            }
            MessageBodyWorkers workers = Requests.getMessageWorkers((Request)request);
            if (entityExists) {
                Object entity = response.getEntity();
                RouterModule.RoutingContext routingContext = (RouterModule.RoutingContext)this.routingContextFactory.get();
                MediaType outputType = routingContext.getEffectiveAcceptableType();
                Annotation[] outputAnnotations = routingContext.getResponseMethodAnnotations();
                Class<?> entityType = routingContext.getResponseMethodType();
                if (entityType == null) {
                    Class<?> genericSuperclass = entity.getClass().getGenericSuperclass();
                    entityType = genericSuperclass instanceof ParameterizedType ? genericSuperclass : entity.getClass();
                }
                OutputStream os = writer.writeResponseStatusAndHeaders(-1L, response);
                MessageBodyWriter bWriter = workers.getMessageBodyWriter(entity.getClass(), entityType, outputAnnotations, outputType);
                bWriter.writeTo(entity, entity.getClass(), entityType, outputAnnotations, outputType, response.getMetadata(), os);
            } else {
                writer.writeResponseStatusAndHeaders(0L, response);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Application.class.getName()).log(Level.SEVERE, null, ex);
            throw new MappableException((Throwable)ex);
        }
        finally {
            writer.commit();
        }
    }

    public Services getServices() {
        return this.services;
    }

    public ServiceProviders getServiceProviders() {
        this.configureProviders();
        return (ServiceProviders)this.references.serviceProviders.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureProviders() {
        if (this.providersMonitor.enterIf(this.providersConfigChanged)) {
            try {
                ResourceConfig rc = (ResourceConfig)((Object)this.references.configuration.get());
                ServiceProviders providers = this.references.serviceProvidersBuilder.setProviderClasses(rc.getClasses()).setProviderInstances(rc.getSingletons()).build();
                MessageBodyFactory workers = new MessageBodyFactory(providers);
                ExceptionMapperFactory mappers = new ExceptionMapperFactory(providers);
                ContextResolverFactory resolvers = new ContextResolverFactory(providers);
                this.references.serviceProviders.set((Object)providers);
                this.references.messageBodyWorkers.set((Object)workers);
                this.references.exceptionMappers.set((Object)mappers);
                this.references.contextRespolvers.set((Object)resolvers);
                this.dirtyProviders = false;
            }
            finally {
                this.providersMonitor.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUpdateInProvidersMonitor(Runnable task) {
        this.providersMonitor.enter();
        try {
            task.run();
            this.dirtyProviders = true;
        }
        finally {
            this.providersMonitor.leave();
        }
    }

    void setResourceConfig(final ResourceConfig newValue) {
        this.runUpdateInProvidersMonitor(new Runnable(){

            @Override
            public void run() {
                Application.this.references.configuration.set((Object)newValue);
            }
        });
    }

    public void addModules(final Module ... modules) {
        this.runUpdateInProvidersMonitor(new Runnable(){

            @Override
            public void run() {
                Injector injector = (Injector)Application.this.services.forContract(Injector.class).get();
                for (Module module : modules) {
                    injector.inject((Object)module);
                    DynamicBinderFactory dynamicBinderFactory = Application.this.services.bindDynamically();
                    module.configure((BinderFactory)dynamicBinderFactory);
                    dynamicBinderFactory.commit();
                }
            }
        });
    }

    private static final class References {
        @Inject
        private ServiceProviders.Builder serviceProvidersBuilder;
        @Inject
        private Ref<ResourceConfig> configuration;
        @Inject
        private Ref<ServiceProviders> serviceProviders;
        @Inject
        private Ref<ExceptionMappers> exceptionMappers;
        @Inject
        private Ref<MessageBodyWorkers> messageBodyWorkers;
        @Inject
        private Ref<ContextResolvers> contextRespolvers;

        private References() {
        }
    }

    private class ApplicationModule
    extends AbstractModule
    implements Factory<TreeAcceptor> {
        private ApplicationModule() {
        }

        public TreeAcceptor get() {
            return Application.this.rootAcceptor;
        }

        public void configure() {
            this.bind(Application.class, new Class[0]).toInstance((Object)Application.this);
            this.bind(TreeAcceptor.class, new Class[0]).annotatedWith(Stage.Root.class).toFactory((Factory)this);
            this.bind().to(PreMatchRequestFilterAcceptor.class);
        }
    }

    public static interface Builder {
        public BoundBuilder bind(String var1);

        public Application build();

        public static interface BoundBuilder {
            public ResourceMethodBuilder method(String ... var1);

            public BoundBuilder produces(MediaType ... var1);

            public BoundBuilder consumes(MediaType ... var1);

            public BoundBuilder subPath(String var1);
        }

        public static interface ResourceMethodBuilder {
            public BoundBuilder to(Inflector<Request, Response> var1);

            public BoundBuilder to(Class<? extends Inflector<Request, Response>> var1);

            public ResourceMethodBuilder produces(MediaType ... var1);

            public ResourceMethodBuilder consumes(MediaType ... var1);
        }
    }
}

