/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.HK2;
import org.glassfish.hk2.Module;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.internal.ServiceProviders;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.MessageBodyFactory;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.Application;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ServerModule;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.routing.RuntimeModelProviderFromRootResource;
import org.glassfish.jersey.server.model.BasicValidator;
import org.glassfish.jersey.server.model.InflectorBasedResourceMethod;
import org.glassfish.jersey.server.model.IntrospectionModeller;
import org.glassfish.jersey.server.model.PathValue;
import org.glassfish.jersey.server.model.ResourceClass;
import org.glassfish.jersey.server.model.ResourceModelIssue;
import org.glassfish.jersey.server.model.ResourceModelValidator;

class ApplicationBuilder
implements Application.Builder {
    private Application application;
    private ResourceConfig resourceConfig;
    private RuntimeModelProviderFromRootResource runtimeModelCreator;
    private Services services;
    private Set<ResourceClass> resources = new HashSet<ResourceClass>();

    ApplicationBuilder(@Nullable ResourceConfig resourceConfig) {
        this.resourceConfig = resourceConfig != null ? resourceConfig : ResourceConfig.empty();
        this.application = new Application();
        Module[] jerseyModules = new Module[]{new ServerModule(), this.application.module()};
        Module[] modules = new Module[jerseyModules.length + this.resourceConfig.getCustomModules().size()];
        System.arraycopy(jerseyModules, 0, modules, 0, jerseyModules.length);
        System.arraycopy(this.resourceConfig.getCustomModules().toArray(), 0, modules, jerseyModules.length, this.resourceConfig.getCustomModules().size());
        this.services = HK2.get().create(null, modules);
        this.runtimeModelCreator = (RuntimeModelProviderFromRootResource)this.services.byType(RuntimeModelProviderFromRootResource.class).get();
        Class<? extends javax.ws.rs.core.Application> applicationClass = this.resourceConfig.getApplicationClass();
        if (applicationClass != null) {
            this.resourceConfig = new ResourceConfig(this.resourceConfig, (javax.ws.rs.core.Application)this.services.forContract(applicationClass).get());
        }
        for (Class<?> c : this.resourceConfig.getClasses()) {
            if (!IntrospectionModeller.isRootResource(c)) continue;
            this.resources.add(IntrospectionModeller.createResource(c));
        }
    }

    @Override
    public Application.Builder.BoundBuilder bind(String path) {
        return new AppBoundBuilder(path);
    }

    private ResourceClass lookupResourceClass(String path) {
        for (ResourceClass r : this.resources) {
            if (!r.isRootResource() || !r.getPath().getValue().equals(path)) continue;
            return r;
        }
        return null;
    }

    @Override
    public Application build() {
        ServiceProviders sp = ((ServiceProviders.Builder)this.services.forContract(ServiceProviders.Builder.class).get()).setProviderClasses(this.resourceConfig.getClasses()).setProviderInstances(this.resourceConfig.getSingletons()).build();
        MessageBodyFactory messageBodyWorkers = new MessageBodyFactory(sp);
        this.runtimeModelCreator.setWorkers((MessageBodyWorkers)messageBodyWorkers);
        this.validateResources((MessageBodyWorkers)messageBodyWorkers);
        for (ResourceClass r : this.resources) {
            this.runtimeModelCreator.process(r);
        }
        this.application.setRootAcceptor(this.runtimeModelCreator.getRuntimeModel());
        ((Injector)this.services.forContract(Injector.class).get()).inject((Object)this.application);
        this.application.setResourceConfig(this.resourceConfig);
        return this.application;
    }

    private void validateResources(MessageBodyWorkers workers) {
        BasicValidator validator = new BasicValidator(workers);
        for (ResourceClass r : this.resources) {
            validator.validate(r);
        }
        this.processIssues(validator);
    }

    private void processIssues(ResourceModelValidator validator) {
        List<ResourceModelIssue> issueList = validator.getIssueList();
        if (!issueList.isEmpty()) {
            Logger logger = Logger.getLogger(ApplicationBuilder.class.getName());
            String allIssueMessages = this.allIssueLogMessages(validator.getIssueList());
            if (validator.fatalIssuesFound()) {
                logger.severe(LocalizationMessages.ERRORS_AND_WARNINGS_DETECTED_WITH_RESOURCE_CLASSES(allIssueMessages));
            } else {
                logger.warning(LocalizationMessages.WARNINGS_DETECTED_WITH_RESOURCE_CLASSES(allIssueMessages));
            }
        }
        if (validator.fatalIssuesFound()) {
            throw new ResourceModelValidator.ModelException(issueList);
        }
    }

    private String allIssueLogMessages(List<ResourceModelIssue> issueList) {
        StringBuilder errors = new StringBuilder("\n");
        StringBuilder warnings = new StringBuilder();
        for (ResourceModelIssue issue : issueList) {
            if (issue.isFatal()) {
                errors.append(LocalizationMessages.ERROR_MSG(issue.getMessage())).append('\n');
                continue;
            }
            warnings.append(LocalizationMessages.WARNING_MSG(issue.getMessage())).append('\n');
        }
        return errors.append((CharSequence)warnings).toString();
    }

    private class AppBoundBuilder
    implements Application.Builder.BoundBuilder {
        final ResourceClass resource;
        final Set<String> methods = new HashSet<String>();
        private final List<MediaType> resourceConsumes = new ArrayList<MediaType>();
        private final List<MediaType> resourceProduces = new ArrayList<MediaType>();
        private final Application.Builder.ResourceMethodBuilder resourceMethodBuilder = new Application.Builder.ResourceMethodBuilder(){
            private final AppBoundBuilder applicationBuilder;
            private final List<MediaType> methodConsumes;
            private final List<MediaType> methodProduces;
            {
                this.applicationBuilder = AppBoundBuilder.this;
                this.methodConsumes = new ArrayList<MediaType>();
                this.methodProduces = new ArrayList<MediaType>();
            }

            @Override
            public Application.Builder.BoundBuilder to(Inflector<Request, Response> transformation) {
                for (String method : AppBoundBuilder.this.methods) {
                    List effectiveInputTypes = this.methodConsumes.isEmpty() ? AppBoundBuilder.this.resourceConsumes : this.methodConsumes;
                    List effectiveOutputTypes = this.methodProduces.isEmpty() ? AppBoundBuilder.this.resourceProduces : this.methodProduces;
                    AppBoundBuilder.this.resource.getResourceMethods().add(new InflectorBasedResourceMethod(AppBoundBuilder.this.resource, method, effectiveInputTypes, effectiveOutputTypes, transformation));
                }
                AppBoundBuilder.this.methods.clear();
                return this.applicationBuilder;
            }

            @Override
            public Application.Builder.BoundBuilder to(final Class<? extends Inflector<Request, Response>> transformationClass) {
                return this.to(new Inflector<Request, Response>(){

                    public Response apply(Request data) {
                        Inflector transformation = (Inflector)((Injector)ApplicationBuilder.this.services.forContract(Injector.class).get()).inject(transformationClass);
                        return (Response)transformation.apply((Object)data);
                    }
                });
            }

            @Override
            public Application.Builder.ResourceMethodBuilder produces(MediaType ... mediaTypes) {
                this.methodProduces.addAll(Arrays.asList(mediaTypes));
                return AppBoundBuilder.this.resourceMethodBuilder;
            }

            @Override
            public Application.Builder.ResourceMethodBuilder consumes(MediaType ... mediaTypes) {
                this.methodConsumes.addAll(Arrays.asList(mediaTypes));
                return AppBoundBuilder.this.resourceMethodBuilder;
            }
        };

        public AppBoundBuilder(String path) {
            this.resource = this.takeExistingOrCreateVirtualResourceClass(path);
        }

        public AppBoundBuilder(String path, String method, Inflector<Request, Response> transformation) {
            Preconditions.checkNotNull((Object)path, (Object)"Path must not be null.");
            Preconditions.checkNotNull((Object)method, (Object)"HTTP method must not be null.");
            Preconditions.checkArgument((!method.isEmpty() ? 1 : 0) != 0, (Object)"HTTP method must not be empty string.");
            Preconditions.checkNotNull(transformation, (Object)"Transformation must not be null.");
            this.resource = this.takeExistingOrCreateVirtualResourceClass(path);
            this.resource.getResourceMethods().add(new InflectorBasedResourceMethod(this.resource, method, null, null, transformation));
        }

        private ResourceClass takeExistingOrCreateVirtualResourceClass(String path) {
            ResourceClass existingResourceClass = ApplicationBuilder.this.lookupResourceClass(path);
            if (existingResourceClass != null) {
                return existingResourceClass;
            }
            ResourceClass virtualResourceClass = new ResourceClass(null, new PathValue(path));
            ApplicationBuilder.this.resources.add(virtualResourceClass);
            return virtualResourceClass;
        }

        @Override
        public Application.Builder.ResourceMethodBuilder method(String ... methods) {
            for (String method : methods) {
                Preconditions.checkNotNull((Object)method, (Object)"HTTP method must not be null.");
                Preconditions.checkArgument((!method.isEmpty() ? 1 : 0) != 0, (Object)"HTTP method must not be empty string.");
                this.methods.add(method);
            }
            return this.resourceMethodBuilder;
        }

        @Override
        public Application.Builder.BoundBuilder produces(MediaType ... mediaTypes) {
            this.resourceProduces.addAll(Arrays.asList(mediaTypes));
            return this;
        }

        @Override
        public Application.Builder.BoundBuilder consumes(MediaType ... mediaTypes) {
            this.resourceConsumes.addAll(Arrays.asList(mediaTypes));
            return this;
        }

        @Override
        public Application.Builder.BoundBuilder subPath(String subPath) {
            throw new UnsupportedOperationException();
        }
    }
}

