/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import org.glassfish.jersey.server.Application;
import org.glassfish.jersey.server.spi.ContainerProvider;

public final class ContainerFactory {
    private ContainerFactory() {
    }

    public static <T> T createContainer(Class<T> type, Application application) {
        T c;
        for (ContainerProvider cp : application.getServiceProviders().getCustom(ContainerProvider.class)) {
            c = cp.createContainer(type, application);
            if (c == null) continue;
            return c;
        }
        for (ContainerProvider cp : application.getServiceProviders().getDefault(ContainerProvider.class)) {
            c = cp.createContainer(type, application);
            if (c == null) continue;
            return c;
        }
        throw new IllegalArgumentException("No container provider supports the type " + type);
    }
}

