/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.ws.rs.core.Application;
import org.glassfish.hk2.ComponentException;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.TypeLiteral;
import org.glassfish.hk2.scopes.Singleton;
import org.glassfish.jersey.FeaturesAndProperties;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.server.ResourceFinder;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.scanning.AnnotationAcceptingListener;
import org.glassfish.jersey.server.internal.scanning.FilesScanner;
import org.glassfish.jersey.server.internal.scanning.PackageNamesScanner;
import org.glassfish.jersey.server.spi.PropertiesProvider;
import org.jvnet.hk2.annotations.Inject;

public final class ResourceConfig
extends Application
implements FeaturesAndProperties {
    private Services services;
    private final Set<Class<?>> providerClasses;
    private final Set<Object> providerInstances;
    private final Map<String, Object> properties;
    private final Set<ResourceFinder> resourceFinders;
    private final Set<org.glassfish.hk2.Module> customModules;
    private transient Set<Class<?>> cachedClasses = null;
    private transient Set<Object> cachedSingletons = null;
    private final Application application;
    private final Class<? extends Application> applicationClass;
    private final ClassLoader classLoader;

    ResourceConfig(Application application, Class<? extends Application> applicationClass, ClassLoader classLoader, Set<Class<?>> providerClasses, Set<Object> providerInstances, Map<String, Object> properties, Set<ResourceFinder> resourceFinders, Set<org.glassfish.hk2.Module> customModules) {
        this.application = application;
        this.applicationClass = applicationClass;
        this.classLoader = classLoader;
        this.providerClasses = Collections.unmodifiableSet(providerClasses);
        this.providerInstances = Collections.unmodifiableSet(providerInstances);
        this.properties = Collections.unmodifiableMap(ResourceConfig.mergeProperties(properties, application));
        this.resourceFinders = Collections.unmodifiableSet(resourceFinders);
        this.customModules = Collections.unmodifiableSet(customModules);
    }

    ResourceConfig(Application application) {
        this.application = application;
        this.applicationClass = null;
        this.classLoader = null;
        this.providerClasses = Collections.emptySet();
        this.providerInstances = Collections.emptySet();
        this.properties = ResourceConfig.mergeProperties(Maps.newHashMap(), application);
        this.resourceFinders = Collections.emptySet();
        this.customModules = Collections.emptySet();
    }

    public static ResourceConfig from(Application application) {
        return new ResourceConfig(application);
    }

    public static ResourceConfig empty() {
        return new ResourceConfigBuilder().build();
    }

    public static Builder builder() {
        return new ResourceConfigBuilder();
    }

    public static Builder builder(ResourceConfig resourceConfig) {
        return new ResourceConfigBuilder(resourceConfig);
    }

    public static Builder builder(Application application) {
        return new ResourceConfigBuilder(application);
    }

    public static Builder builder(Class<? extends Application> applicationClass) {
        return new ResourceConfigBuilder(applicationClass);
    }

    ResourceConfig(ResourceConfig that, Application application) {
        this.properties = ResourceConfig.mergeProperties(that.properties, application);
        this.services = that.services;
        this.providerClasses = that.providerClasses;
        this.providerInstances = that.providerInstances;
        this.resourceFinders = that.resourceFinders;
        this.customModules = that.customModules;
        this.application = application;
        this.applicationClass = that.applicationClass;
        this.classLoader = that.classLoader;
    }

    Application getApplication() {
        return this.application != null ? this.application : this;
    }

    Class<? extends Application> getApplicationClass() {
        return this.applicationClass;
    }

    Set<org.glassfish.hk2.Module> getCustomModules() {
        return this.customModules;
    }

    public Set<Class<?>> getClasses() {
        if (this.cachedClasses == null) {
            AnnotationAcceptingListener afl = AnnotationAcceptingListener.newJaxrsResourceAndProviderListener(this.classLoader);
            this.cachedClasses = new HashSet();
            for (ResourceFinder resourceFinder : this.resourceFinders) {
                while (resourceFinder.hasNext()) {
                    String next = (String)resourceFinder.next();
                    if (!afl.accept(next)) continue;
                    try {
                        afl.process(next, resourceFinder.open());
                    }
                    catch (IOException e) {}
                }
            }
            if (this.application != null) {
                this.cachedClasses.addAll(this.application.getClasses());
            }
            this.cachedClasses.addAll(afl.getAnnotatedClasses());
            this.cachedClasses.addAll(this.providerClasses);
        }
        return this.cachedClasses;
    }

    public Set<Object> getSingletons() {
        if (this.cachedSingletons == null) {
            this.cachedSingletons = new HashSet<Object>();
            if (this.application != null) {
                this.cachedSingletons.addAll(this.application.getSingletons());
            }
            this.cachedSingletons.addAll(this.providerInstances);
        }
        return this.cachedSingletons;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public boolean isProperty(String name) {
        if (this.properties.containsKey(name)) {
            Object value = this.properties.get(name);
            if (value instanceof Boolean) {
                return (Boolean)Boolean.class.cast(value);
            }
            return Boolean.parseBoolean(value.toString());
        }
        return false;
    }

    public static String[] getElements(String[] elements) {
        return ResourceConfig.getElements(elements, " ,;\n");
    }

    public static String[] getElements(String[] elements, String delimiters) {
        LinkedList<String> es = new LinkedList<String>();
        for (String element : elements) {
            if (element == null || (element = element.trim()).length() == 0) continue;
            for (String subElement : ResourceConfig.getElements(element, delimiters)) {
                if (subElement == null || subElement.length() == 0) continue;
                es.add(subElement);
            }
        }
        return es.toArray(new String[es.size()]);
    }

    public static String[] getElements(String elements, String delimiters) {
        String regex = "[";
        for (char c : delimiters.toCharArray()) {
            regex = regex + Pattern.quote(String.valueOf(c));
        }
        regex = regex + "]";
        String[] es = elements.split(regex);
        for (int i = 0; i < es.length; ++i) {
            es[i] = es[i].trim();
        }
        return es;
    }

    private static Map<String, Object> mergeProperties(Map<String, Object> properties, Application application) {
        HashMap mergedProperties;
        if (application != null && PropertiesProvider.class.isAssignableFrom(application.getClass())) {
            mergedProperties = Maps.newHashMap();
            mergedProperties.putAll(((PropertiesProvider)application).getProperties());
            mergedProperties.putAll(properties);
        } else {
            mergedProperties = properties;
        }
        return mergedProperties;
    }

    private static class ResourceConfigBuilder
    implements Builder {
        private final Application application;
        private final Class<? extends Application> applicationClass;
        private final Set<Class<?>> classes;
        private final Set<Object> singletons;
        private final Map<String, Object> properties;
        private final Set<ResourceFinder> resourceFinders;
        private final Set<org.glassfish.hk2.Module> customModules;
        private ClassLoader classLoader = null;

        public ResourceConfigBuilder() {
            this.application = null;
            this.applicationClass = null;
            this.classes = Sets.newHashSet();
            this.singletons = Sets.newHashSet();
            this.properties = Maps.newHashMap();
            this.resourceFinders = Sets.newHashSet();
            this.customModules = Sets.newHashSet();
        }

        public ResourceConfigBuilder(Application application) {
            this.application = application;
            this.applicationClass = null;
            this.classes = Sets.newHashSet();
            this.singletons = Sets.newHashSet();
            this.properties = Maps.newHashMap();
            this.resourceFinders = Sets.newHashSet();
            this.customModules = Sets.newHashSet();
        }

        public ResourceConfigBuilder(ResourceConfig that) {
            this.application = that.application;
            this.applicationClass = that.applicationClass;
            this.classes = Sets.newHashSet((Iterable)that.providerClasses);
            this.singletons = Sets.newHashSet((Iterable)that.providerInstances);
            this.properties = Maps.newHashMap((Map)that.properties);
            this.resourceFinders = Sets.newHashSet((Iterable)that.resourceFinders);
            this.customModules = Sets.newHashSet((Iterable)that.customModules);
        }

        public ResourceConfigBuilder(Class<? extends Application> applicationClass) {
            this.application = null;
            this.applicationClass = applicationClass;
            this.classes = Sets.newHashSet();
            this.singletons = Sets.newHashSet();
            this.properties = Maps.newHashMap();
            this.resourceFinders = Sets.newHashSet();
            this.customModules = Sets.newHashSet();
        }

        @Override
        public Builder addClasses(Set<Class<?>> classes) {
            this.classes.addAll(classes);
            return this;
        }

        @Override
        public Builder addClasses(Class<?> ... classes) {
            this.addClasses(Sets.newHashSet((Object[])classes));
            return this;
        }

        @Override
        public Builder addSingletons(Set<Object> singletons) {
            this.singletons.addAll(singletons);
            return this;
        }

        @Override
        public Builder addSingletons(Object ... singletons) {
            this.addSingletons(Sets.newHashSet((Object[])singletons));
            return this;
        }

        @Override
        public Builder setProperty(String name, Object value) {
            this.properties.put(name, value);
            return this;
        }

        @Override
        public Builder addProperties(Map<String, Object> properties) {
            this.properties.putAll(properties);
            return this;
        }

        @Override
        public Builder addFinder(ResourceFinder resourceFinder) {
            this.resourceFinders.add(resourceFinder);
            return this;
        }

        @Override
        public Builder addModules(Set<org.glassfish.hk2.Module> modules) {
            this.customModules.addAll(modules);
            return this;
        }

        @Override
        public Builder addModules(org.glassfish.hk2.Module ... modules) {
            this.addModules(Sets.newHashSet((Object[])modules));
            return this;
        }

        @Override
        public Builder setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        @Override
        public Builder packages(String ... packages) {
            this.addFinder(new PackageNamesScanner(packages));
            return this;
        }

        @Override
        public Builder files(String ... files) {
            this.addFinder(new FilesScanner(files));
            return this;
        }

        @Override
        public ResourceConfig build() {
            Object o;
            if (this.classLoader == null) {
                this.classLoader = ReflectionHelper.getContextClassLoader();
            }
            if ((o = this.properties.get("jersey.config.server.provider.classnames")) != null) {
                String[] classNames = null;
                if (o instanceof String) {
                    classNames = ResourceConfig.getElements((String)o, " ,;\n");
                } else if (o instanceof String[]) {
                    classNames = ResourceConfig.getElements((String[])o, " ,;\n");
                }
                if (classNames != null) {
                    for (String className : classNames) {
                        try {
                            this.classes.add(this.classLoader.loadClass(className));
                        }
                        catch (ClassNotFoundException e) {
                            Logger.getLogger(ResourceConfig.class.getName()).log(Level.CONFIG, LocalizationMessages.UNABLE_TO_LOAD_CLASS(className));
                        }
                    }
                }
            }
            return new ResourceConfig(this.application, this.applicationClass, this.classLoader, this.classes, this.singletons, this.properties, this.resourceFinders, this.customModules);
        }
    }

    public static interface Builder {
        public Builder addClasses(Class<?> ... var1);

        public Builder addClasses(Set<Class<?>> var1);

        public Builder addSingletons(Set<Object> var1);

        public Builder addSingletons(Object ... var1);

        public Builder addFinder(ResourceFinder var1);

        public Builder setProperty(String var1, Object var2);

        public Builder addProperties(Map<String, Object> var1);

        public Builder setClassLoader(ClassLoader var1);

        public Builder addModules(Set<org.glassfish.hk2.Module> var1);

        public Builder addModules(org.glassfish.hk2.Module ... var1);

        public Builder packages(String ... var1);

        public Builder files(String ... var1);

        public ResourceConfig build();
    }

    static final class Module
    extends AbstractModule {
        Module() {
        }

        protected void configure() {
            this.bind(ResourceConfig.class, new Class[0]).toFactory(ResourceConfigFactory.class).in(RequestScope.class);
            this.bind(FeaturesAndProperties.class, new Class[0]).toFactory(ResourceConfigFactory.class).in(RequestScope.class);
            this.bind((TypeLiteral)new TypeLiteral<Ref<ResourceConfig>>(){}).toFactory(ReferencingFactory.referenceFactory()).in(Singleton.class);
            this.bind(Application.class, new Class[0]).toFactory(JaxrsApplicationFactory.class).in(RequestScope.class);
        }

        private static class JaxrsApplicationFactory
        implements Factory<Application> {
            @Inject
            private Factory<ResourceConfig> rcFactory;

            private JaxrsApplicationFactory() {
            }

            public Application get() throws ComponentException {
                return ((ResourceConfig)((Object)this.rcFactory.get())).getApplication();
            }
        }

        private static class ResourceConfigFactory
        extends ReferencingFactory<ResourceConfig> {
            public ResourceConfigFactory(@Inject Factory<Ref<ResourceConfig>> referenceFactory) {
                super(referenceFactory);
            }
        }
    }
}

