/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.util.Map;
import javax.ws.rs.CookieParam;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;
import org.glassfish.jersey.server.internal.inject.AbstractHttpContextValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.HttpContext;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.jvnet.hk2.annotations.Inject;

final class CookieParamValueFactoryProvider
extends AbstractValueFactoryProvider<CookieParam> {
    public CookieParamValueFactoryProvider(@Inject MultivaluedParameterExtractorProvider mpep, @Inject Injector injector) {
        super(mpep, injector, Parameter.Source.COOKIE);
    }

    @Override
    public AbstractHttpContextValueFactory<?> createValueFactory(Parameter parameter) {
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        if (parameter.getParameterClass() == Cookie.class) {
            return new CookieTypeParamValueFactory(parameterName);
        }
        MultivaluedParameterExtractor<?> e = this.get(parameter);
        if (e == null) {
            return null;
        }
        return new CookieParamValueFactory(e);
    }

    private static final class CookieTypeParamValueFactory
    extends AbstractHttpContextValueFactory<Cookie> {
        private final String name;

        CookieTypeParamValueFactory(String name) {
            this.name = name;
        }

        @Override
        public Cookie get(HttpContext context) {
            return (Cookie)context.getRequest().getHeaders().getCookies().get(this.name);
        }
    }

    private static final class CookieParamValueFactory
    extends AbstractHttpContextValueFactory<Object> {
        private final MultivaluedParameterExtractor<?> extractor;

        CookieParamValueFactory(MultivaluedParameterExtractor<?> extractor) {
            this.extractor = extractor;
        }

        @Override
        public Object get(HttpContext context) {
            MultivaluedStringMap cookies = new MultivaluedStringMap();
            for (Map.Entry e : context.getRequest().getHeaders().getCookies().entrySet()) {
                cookies.putSingle(e.getKey(), (Object)((Cookie)e.getValue()).getValue());
            }
            return this.extractor.extract((MultivaluedMap<String, String>)cookies);
        }
    }

    static final class InjectionResolver
    extends ParamInjectionResolver<CookieParam> {
        public InjectionResolver() {
            super(CookieParam.class, CookieParamValueFactoryProvider.class);
        }
    }
}

