/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import com.google.common.collect.Iterators;
import java.net.URI;
import java.util.Iterator;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Tuples;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.process.internal.TreeAcceptor;
import org.glassfish.jersey.server.internal.routing.RouterModule;
import org.jvnet.hk2.annotations.Inject;

public class RedirectingAcceptor
implements TreeAcceptor {
    private final Factory<RouterModule.RoutingContext> contextProvider;
    private final Factory<UriInfo> uriInfoProvider;
    private final boolean redirect;
    private final boolean patternEndsInSlash;

    public RedirectingAcceptor(Factory<RouterModule.RoutingContext> contextProvider, Factory<UriInfo> uriInfoProvider, boolean redirect, boolean patternEndsInSlash) {
        this.contextProvider = contextProvider;
        this.uriInfoProvider = uriInfoProvider;
        this.redirect = redirect;
        this.patternEndsInSlash = patternEndsInSlash;
    }

    public Pair<Request, Iterator<TreeAcceptor>> apply(Request request) {
        String rhPath = this.getLastMatch();
        int rhPathLength = rhPath.length();
        if (rhPathLength == 0) {
            if (this.patternEndsInSlash && this.redirect) {
                return this.redirect(request);
            }
        } else if (rhPath.length() == 1 ? !this.patternEndsInSlash && this.redirect : this.patternEndsInSlash) {
            return Stages.terminalTreeContinuation((Request)request);
        }
        return Stages.terminalTreeContinuation((Request)request);
    }

    private String getLastMatch() {
        String match = ((RouterModule.RoutingContext)this.contextProvider.get()).getFinalMatchingGroup();
        return match == null ? "" : match;
    }

    private Pair<Request, Iterator<TreeAcceptor>> redirect(Request request) {
        return Tuples.of((Object)request, (Object)Iterators.singletonIterator((Object)Stages.asTreeAcceptor((Inflector)new Inflector<Request, Response>(){

            public Response apply(Request request) {
                URI redirectPath = ((UriInfo)RedirectingAcceptor.this.uriInfoProvider.get()).getRequestUriBuilder().path("/").build(new Object[0]);
                return Response.temporaryRedirect((URI)redirectPath).build();
            }
        })));
    }

    public class Builder {
        private final Factory<RouterModule.RoutingContext> contextProvider;
        private final Factory<UriInfo> uriInfoProvider;

        public Builder(@Inject Factory<RouterModule.RoutingContext> contextProvider, Factory<UriInfo> uriInfoProvider) {
            this.contextProvider = contextProvider;
            this.uriInfoProvider = uriInfoProvider;
        }

        public RedirectingAcceptor build(boolean redirect, boolean patternEndsInSlash) {
            return new RedirectingAcceptor(this.contextProvider, this.uriInfoProvider, redirect, patternEndsInSlash);
        }
    }
}

