/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Tuples;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.TreeAcceptor;
import org.glassfish.jersey.server.internal.routing.MultipleMethodAcceptor;
import org.glassfish.jersey.server.internal.routing.RouterModule;
import org.glassfish.jersey.server.model.AbstractResourceMethod;
import org.glassfish.jersey.server.model.InvocableResourceMethod;
import org.glassfish.jersey.server.model.ResourceClass;
import org.glassfish.jersey.server.model.ResourceMethodInvoker;
import org.glassfish.jersey.server.model.RuntimeModelProvider;
import org.glassfish.jersey.server.model.SubResourceLocator;
import org.glassfish.jersey.server.model.SubResourceMethod;
import org.glassfish.jersey.uri.PathPattern;
import org.jvnet.hk2.annotations.Inject;

public abstract class RuntimeModelProviderBase
extends RuntimeModelProvider {
    @Inject
    RouterModule.RootRouteBuilder<PathPattern> rootBuilder;
    @Inject
    ResourceMethodInvoker.Builder resourceMethodInvokerBuilder;
    @Inject
    Injector injector;
    @Inject
    Services services;
    MessageBodyWorkers workers;
    private RouterModule.RouteToPathBuilder<PathPattern> lastRoutedBuilder;
    private Map<PathPattern, List<Pair<AbstractResourceMethod, Inflector<Request, Response>>>> method2Inflector = new HashMap<PathPattern, List<Pair<AbstractResourceMethod, Inflector<Request, Response>>>>();
    private Map<PathPattern, Map<PathPattern, List<SubResourceEntry>>> locators = new HashMap<PathPattern, Map<PathPattern, List<SubResourceEntry>>>();

    public RuntimeModelProviderBase() {
    }

    public RuntimeModelProviderBase(MessageBodyWorkers msgBodyWorkers) {
        this.workers = msgBodyWorkers;
    }

    TreeAcceptor adaptSubResourceMethodAcceptor(ResourceClass resource, TreeAcceptor acceptor) {
        return acceptor;
    }

    TreeAcceptor adaptResourceMethodAcceptor(ResourceClass resource, TreeAcceptor acceptor) {
        return acceptor;
    }

    TreeAcceptor adaptSubResourceLocatorAcceptor(ResourceClass resource, TreeAcceptor acceptor) {
        return acceptor;
    }

    TreeAcceptor adaptSubResourceAcceptor(ResourceClass resource, TreeAcceptor acceptor) {
        return acceptor;
    }

    abstract TreeAcceptor createFinalTreeAcceptor(RouterModule.RootRouteBuilder<PathPattern> var1, RouterModule.RouteToPathBuilder<PathPattern> var2);

    @Override
    public TreeAcceptor getRuntimeModel() {
        TreeSet<PathPattern> pathPatterns;
        if (!this.method2Inflector.isEmpty()) {
            pathPatterns = new TreeSet<PathPattern>(PathPattern.COMPARATOR);
            pathPatterns.addAll(this.method2Inflector.keySet());
            for (PathPattern path : pathPatterns) {
                List<Pair<AbstractResourceMethod, Inflector<Request, Response>>> methodInflectors = this.method2Inflector.get(path);
                this.lastRoutedBuilder = this.routedBuilder().route(path).to(this.adaptResourceMethodAcceptor(this.getDeclaringResource(methodInflectors), new MultipleMethodAcceptor(this.injector, this.workers, methodInflectors)));
            }
            this.method2Inflector.clear();
        }
        if (!this.locators.isEmpty()) {
            pathPatterns = new TreeSet(PathPattern.COMPARATOR);
            pathPatterns.addAll(this.locators.keySet());
            for (PathPattern path : pathPatterns) {
                RouterModule.RouteBuilder<PathPattern> srRoutedBuilder = null;
                TreeSet<PathPattern> srPathPatterns = new TreeSet<PathPattern>(PathPattern.COMPARATOR);
                srPathPatterns.addAll(this.locators.get(path).keySet());
                ResourceClass declaringResource = null;
                for (PathPattern srPath : srPathPatterns) {
                    LinkedList<Pair<AbstractResourceMethod, Inflector<Request, Response>>> methodInflectors = new LinkedList<Pair<AbstractResourceMethod, Inflector<Request, Response>>>();
                    SubResourceLocatorEntry srl = null;
                    for (SubResourceEntry entry : this.locators.get(path).get(srPath)) {
                        if (entry instanceof SubResourceMethodEntry) {
                            SubResourceMethodEntry srm = (SubResourceMethodEntry)entry;
                            methodInflectors.add(Tuples.of((Object)srm.srm, srm.inflector));
                            if (declaringResource != null) continue;
                            declaringResource = srm.srm.getDeclaringResource();
                            continue;
                        }
                        srl = (SubResourceLocatorEntry)entry;
                        if (declaringResource != null) continue;
                        declaringResource = srl.srl.getResource();
                    }
                    if (!methodInflectors.isEmpty()) {
                        PathPattern srPathEmptyRHP = new PathPattern(srPath.getTemplate().getTemplate(), PathPattern.RightHandPath.capturingZeroSegments);
                        srRoutedBuilder = (srRoutedBuilder == null ? this.rootBuilder : srRoutedBuilder).route(srPathEmptyRHP).to(this.adaptSubResourceMethodAcceptor(this.getDeclaringResource(methodInflectors), new MultipleMethodAcceptor(this.injector, this.workers, methodInflectors)));
                    }
                    if (srl == null) continue;
                    srRoutedBuilder = (srRoutedBuilder == null ? this.rootBuilder : srRoutedBuilder).route(srPath).to(this.adaptSubResourceLocatorAcceptor(srl.srl.getResource(), srl.aceptor));
                }
                this.lastRoutedBuilder = this.routedBuilder().route(path).to(this.adaptSubResourceAcceptor(declaringResource, srRoutedBuilder.build()));
            }
            this.locators.clear();
        }
        return this.createFinalTreeAcceptor(this.rootBuilder, this.lastRoutedBuilder);
    }

    RouterModule.RouteBuilder<PathPattern> routedBuilder() {
        return this.lastRoutedBuilder == null ? this.rootBuilder : this.lastRoutedBuilder;
    }

    public void setWorkers(MessageBodyWorkers workers) {
        this.workers = workers;
    }

    Inflector<Request, Response> createInflector(InvocableResourceMethod method) {
        return this.resourceMethodInvokerBuilder.build(method);
    }

    void addMethodInflector(PathPattern pathPattern, AbstractResourceMethod method, Inflector<Request, Response> inflector) {
        if (!this.method2Inflector.containsKey(pathPattern)) {
            this.method2Inflector.put(pathPattern, new LinkedList());
        }
        this.method2Inflector.get(pathPattern).add((Pair<AbstractResourceMethod, Inflector<Request, Response>>)Tuples.of((Object)method, inflector));
    }

    void addSubResourceLocatorEntry(String path, SubResourceEntry entry) {
        PathPattern pathPattern = new PathPattern(path);
        if (!this.locators.containsKey(pathPattern)) {
            this.locators.put(pathPattern, new HashMap());
        }
        PathPattern subResourcePathPattern = new PathPattern(entry.getSubResourcePathPattern());
        Map<PathPattern, List<SubResourceEntry>> singleResourceMap = this.locators.get(pathPattern);
        if (!singleResourceMap.containsKey(subResourcePathPattern)) {
            singleResourceMap.put(subResourcePathPattern, new LinkedList());
        }
        singleResourceMap.get(subResourcePathPattern).add(entry);
    }

    ResourceClass getDeclaringResource(List<Pair<AbstractResourceMethod, Inflector<Request, Response>>> method2InflectorList) {
        for (Pair<AbstractResourceMethod, Inflector<Request, Response>> methodInflector : method2InflectorList) {
            if (!(methodInflector.left() instanceof InvocableResourceMethod)) continue;
            return ((AbstractResourceMethod)methodInflector.left()).getDeclaringResource();
        }
        return null;
    }

    class SubResourceLocatorEntry
    extends SubResourceEntry {
        SubResourceLocator srl;
        TreeAcceptor aceptor;

        SubResourceLocatorEntry(SubResourceLocator srl, TreeAcceptor aceptor) {
            this.srl = srl;
            this.aceptor = aceptor;
        }

        @Override
        String getSubResourcePathPattern() {
            return this.srl.getPath().getValue();
        }
    }

    class SubResourceMethodEntry
    extends SubResourceEntry {
        String supportedHttpMethod;
        SubResourceMethod srm;
        Inflector<Request, Response> inflector;

        SubResourceMethodEntry(String supportedHttpMethod, SubResourceMethod srm, Inflector<Request, Response> inflector) {
            this.supportedHttpMethod = supportedHttpMethod;
            this.srm = srm;
            this.inflector = inflector;
        }

        @Override
        String getSubResourcePathPattern() {
            return this.srm.getPath().getValue();
        }
    }

    abstract class SubResourceEntry {
        SubResourceEntry() {
        }

        abstract String getSubResourcePathPattern();
    }
}

