/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.process.internal.TreeAcceptor;
import org.glassfish.jersey.server.internal.routing.PushResourceUriAndDelegateTreeAcceptor;
import org.glassfish.jersey.server.internal.routing.PushUriAndDelegateTreeAcceptor;
import org.glassfish.jersey.server.internal.routing.RouterModule;
import org.glassfish.jersey.server.internal.routing.RuntimeModelProviderBase;
import org.glassfish.jersey.server.internal.routing.SubResourceLocatorAcceptor;
import org.glassfish.jersey.server.model.InflectorBasedResourceMethod;
import org.glassfish.jersey.server.model.ResourceClass;
import org.glassfish.jersey.server.model.ResourceConstructor;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.SubResourceLocator;
import org.glassfish.jersey.server.model.SubResourceMethod;
import org.glassfish.jersey.uri.PathPattern;

public class RuntimeModelProviderFromRootResource
extends RuntimeModelProviderBase {
    private String currentResourcePath = null;

    public RuntimeModelProviderFromRootResource() {
    }

    public RuntimeModelProviderFromRootResource(MessageBodyWorkers msgBodyWorkers) {
        super(msgBodyWorkers);
    }

    @Override
    TreeAcceptor adaptResourceMethodAcceptor(ResourceClass resource, TreeAcceptor acceptor) {
        return new PushResourceUriAndDelegateTreeAcceptor(this.injector, resource, acceptor);
    }

    @Override
    TreeAcceptor adaptSubResourceMethodAcceptor(ResourceClass resource, TreeAcceptor acceptor) {
        return new PushResourceUriAndDelegateTreeAcceptor(this.injector, resource, acceptor);
    }

    @Override
    TreeAcceptor adaptSubResourceLocatorAcceptor(ResourceClass resource, TreeAcceptor acceptor) {
        return new PushResourceUriAndDelegateTreeAcceptor(this.injector, resource, acceptor);
    }

    @Override
    TreeAcceptor adaptSubResourceAcceptor(ResourceClass resource, TreeAcceptor acceptor) {
        return new PushUriAndDelegateTreeAcceptor(this.injector, acceptor);
    }

    @Override
    TreeAcceptor createFinalTreeAcceptor(RouterModule.RootRouteBuilder<PathPattern> rootRouteBuilder, RouterModule.RouteToPathBuilder<PathPattern> lastRoutedBuilder) {
        return this.rootBuilder.root(lastRoutedBuilder.build());
    }

    @Override
    public void visitResourceClass(ResourceClass resource) {
        if (resource.isRootResource()) {
            this.currentResourcePath = resource.getPath().getValue();
        }
    }

    @Override
    public void visitResourceMethod(ResourceMethod method) {
        if (method.getDeclaringResource().isRootResource()) {
            this.addMethodInflector(new PathPattern(this.currentResourcePath, PathPattern.RightHandPath.capturingZeroSegments), method, this.createInflector(method));
        }
    }

    @Override
    public void visitSubResourceMethod(SubResourceMethod method) {
        if (method.getDeclaringResource().isRootResource()) {
            this.addSubResourceLocatorEntry(this.currentResourcePath, new RuntimeModelProviderBase.SubResourceMethodEntry(method.getHttpMethod(), method, this.createInflector(method)));
        }
    }

    @Override
    public void visitSubResourceLocator(SubResourceLocator locator) {
        if (locator.getResource().isRootResource()) {
            this.addSubResourceLocatorEntry(this.currentResourcePath, new RuntimeModelProviderBase.SubResourceLocatorEntry(locator, new SubResourceLocatorAcceptor(this.injector, this.services, this.workers, locator)));
        }
    }

    @Override
    public void visitResourceConstructor(ResourceConstructor constructor) {
    }

    @Override
    public void visitInflectorResourceMethod(InflectorBasedResourceMethod method) {
        if (method.getDeclaringResource().isRootResource()) {
            this.addMethodInflector(new PathPattern(this.currentResourcePath, PathPattern.RightHandPath.capturingZeroSegments), method, method.getInflector());
        }
    }
}

