/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.scanning;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import org.glassfish.jersey.server.ResourceFinder;
import org.glassfish.jersey.server.internal.scanning.ResourceFinderException;
import org.glassfish.jersey.server.internal.scanning.ResourceFinderStack;
import org.glassfish.jersey.server.internal.scanning.UriSchemeResourceFinderFactory;

class FileSchemeResourceFinderFactory
implements UriSchemeResourceFinderFactory {
    @Override
    public Set<String> getSchemes() {
        return Collections.singleton("file");
    }

    FileSchemeResourceFinderFactory() {
    }

    @Override
    public FileSchemeScanner create(URI uri) {
        return new FileSchemeScanner(uri);
    }

    private class FileSchemeScanner
    implements ResourceFinder {
        private ResourceFinderStack resourceFinderStack = new ResourceFinderStack();

        private FileSchemeScanner(URI uri) {
            this.processFile(new File(uri.getPath()));
        }

        @Override
        public boolean hasNext() {
            return this.resourceFinderStack.hasNext();
        }

        @Override
        public String next() {
            return this.resourceFinderStack.next();
        }

        @Override
        public void remove() {
            this.resourceFinderStack.remove();
        }

        @Override
        public InputStream open() {
            return this.resourceFinderStack.open();
        }

        @Override
        public void reset() {
            throw new UnsupportedOperationException();
        }

        private void processFile(final File f) {
            this.resourceFinderStack.push(new ResourceFinder(){
                Stack<File> files = new Stack<File>(){
                    {
                        if (f.isDirectory()) {
                            for (File file : f.listFiles()) {
                                this.push(file);
                            }
                        } else {
                            this.push(f);
                        }
                    }
                };
                private File current;
                private File next;

                @Override
                public boolean hasNext() {
                    while (this.next == null && !this.files.empty()) {
                        this.next = this.files.pop();
                        if (!this.next.isDirectory()) continue;
                        FileSchemeScanner.this.processFile(this.next);
                        this.next = null;
                    }
                    return this.next != null;
                }

                @Override
                public String next() {
                    if (this.next != null || this.hasNext()) {
                        this.current = this.next;
                        this.next = null;
                        return this.current.getName();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public InputStream open() {
                    try {
                        return new FileInputStream(this.current);
                    }
                    catch (FileNotFoundException e) {
                        throw new ResourceFinderException(e);
                    }
                }

                @Override
                public void reset() {
                    throw new UnsupportedOperationException();
                }
            });
        }
    }
}

