/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.internal.MappableException;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.server.model.InvocableResourceMethod;
import org.glassfish.jersey.server.spi.internal.ResourceMethodDispatcher;

public abstract class AbstractJavaResourceMethodDispatcher
implements ResourceMethodDispatcher {
    private final Method method;
    private final InvocationHandler methodHandler;

    protected AbstractJavaResourceMethodDispatcher(InvocableResourceMethod resourceMethod, InvocationHandler methodHandler) {
        this.method = resourceMethod.getMethod();
        this.methodHandler = methodHandler;
    }

    @Override
    public final Response dispatch(Object resource, Request request) throws ProcessingException {
        Response response = this.doDispatch(resource, request);
        return response;
    }

    protected abstract Response doDispatch(Object var1, Request var2) throws ProcessingException;

    protected final Object invoke(Object resource, Object ... args) throws ProcessingException {
        try {
            return this.methodHandler.invoke(resource, this.method, args);
        }
        catch (IllegalAccessException ex) {
            throw new ProcessingException("Resource Java method invocation error.", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ProcessingException) {
                throw (ProcessingException)cause;
            }
            throw new MappableException(cause);
        }
        catch (UndeclaredThrowableException ex) {
            throw new ProcessingException("Resource Java method invocation error.", (Throwable)ex);
        }
        catch (ProcessingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MappableException((Throwable)ex);
        }
        catch (Throwable t) {
            throw new ProcessingException(t);
        }
    }

    public String toString() {
        return this.method.toString();
    }
}

