/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.Suspend;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.internal.util.AnnotatedMethod;
import org.glassfish.jersey.internal.util.MethodList;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.ClassTypePair;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.model.AbstractResourceMethod;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.Parameterized;
import org.glassfish.jersey.server.model.PathValue;
import org.glassfish.jersey.server.model.ResourceClass;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.SubResourceLocator;
import org.glassfish.jersey.server.model.SubResourceMethod;

public class IntrospectionModeller {
    private static final Logger LOGGER = Logger.getLogger(IntrospectionModeller.class.getName());
    private static final Map<Class, ParamAnnotationHelper> ANOT_HELPER_MAP = IntrospectionModeller.createParamAnotHelperMap();

    public static ResourceClass createResource(Class<?> resourceClass) {
        Class<?> annotatedResourceClass = IntrospectionModeller.getAnnotatedResourceClass(resourceClass);
        Path rPathAnnotation = annotatedResourceClass.getAnnotation(Path.class);
        boolean isRootResourceClass = null != rPathAnnotation;
        boolean isEncodedAnotOnClass = null != annotatedResourceClass.getAnnotation(Encoded.class);
        ResourceClass resource = isRootResourceClass ? new ResourceClass(resourceClass, new PathValue(rPathAnnotation.value())) : new ResourceClass(resourceClass);
        MethodList methodList = new MethodList(resourceClass);
        Consumes classScopeConsumesAnnotation = annotatedResourceClass.getAnnotation(Consumes.class);
        Produces classScopeProducesAnnotation = annotatedResourceClass.getAnnotation(Produces.class);
        IntrospectionModeller.workOutResourceMethodsList(resource, methodList, isEncodedAnotOnClass, classScopeConsumesAnnotation, classScopeProducesAnnotation);
        IntrospectionModeller.workOutSubResourceMethodsList(resource, methodList, isEncodedAnotOnClass, classScopeConsumesAnnotation, classScopeProducesAnnotation);
        IntrospectionModeller.workOutSubResourceLocatorsList(resource, methodList, isEncodedAnotOnClass);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(LocalizationMessages.NEW_AR_CREATED_BY_INTROSPECTION_MODELER(resource.toString()));
        }
        return resource;
    }

    public static boolean isRootResource(Class<?> resourceClass) {
        Path rPathAnnotation = IntrospectionModeller.getAnnotatedResourceClass(resourceClass).getAnnotation(Path.class);
        return null != rPathAnnotation;
    }

    private static Class<?> getAnnotatedResourceClass(Class<?> rc) {
        if (rc.isAnnotationPresent(Path.class)) {
            return rc;
        }
        for (Class<?> i : rc.getInterfaces()) {
            if (!i.isAnnotationPresent(Path.class)) continue;
            return i;
        }
        return rc;
    }

    private static void addConsumes(AnnotatedMethod am, AbstractResourceMethod resourceMethod, Consumes consumeMimeAnnotation) {
        if (am.isAnnotationPresent(Consumes.class)) {
            consumeMimeAnnotation = (Consumes)am.getAnnotation(Consumes.class);
        }
        resourceMethod.setAreInputTypesDeclared(consumeMimeAnnotation != null);
        if (consumeMimeAnnotation != null) {
            for (String mt : consumeMimeAnnotation.value()) {
                resourceMethod.getSupportedInputTypes().add(MediaType.valueOf((String)mt));
            }
        }
    }

    private static void declareSuspend(AnnotatedMethod am, AbstractResourceMethod resourceMethod) {
        Suspend suspend = (Suspend)am.getAnnotation(Suspend.class);
        if (suspend != null) {
            resourceMethod.declareSuspend(suspend.timeOut(), suspend.timeUnit());
        }
    }

    private static void addProduces(AnnotatedMethod am, AbstractResourceMethod resourceMethod, Produces produceMimeAnnotation) {
        if (am.isAnnotationPresent(Produces.class)) {
            produceMimeAnnotation = (Produces)am.getAnnotation(Produces.class);
        }
        resourceMethod.setAreOutputTypesDeclared(produceMimeAnnotation != null);
        if (produceMimeAnnotation != null) {
            for (String mt : produceMimeAnnotation.value()) {
                resourceMethod.getSupportedOutputTypes().add(MediaType.valueOf((String)mt));
            }
        }
    }

    private static void workOutResourceMethodsList(ResourceClass resource, MethodList methodList, boolean isEncoded, Consumes classScopeConsumesAnnotation, Produces classScopeProducesAnnotation) {
        for (AnnotatedMethod m : methodList.hasMetaAnnotation(HttpMethod.class).hasNotAnnotation(Path.class)) {
            ClassTypePair ct = IntrospectionModeller.getGenericReturnType(resource.getResourceClass(), m.getMethod());
            ResourceMethod resourceMethod = new ResourceMethod(resource, m.getMethod(), ct.rawClass(), ct.type(), ((HttpMethod)m.getMetaMethodAnnotations(HttpMethod.class).get(0)).value(), m.getAnnotations());
            IntrospectionModeller.addConsumes(m, resourceMethod, classScopeConsumesAnnotation);
            IntrospectionModeller.addProduces(m, resourceMethod, classScopeProducesAnnotation);
            IntrospectionModeller.declareSuspend(m, resourceMethod);
            IntrospectionModeller.processParameters(resourceMethod.getDeclaringResource().getResourceClass(), resourceMethod.getMethod().getDeclaringClass(), (Parameterized)resourceMethod, m, isEncoded);
            resource.getResourceMethods().add(resourceMethod);
        }
    }

    private static ClassTypePair getGenericReturnType(Class concreteClass, Method m) {
        return IntrospectionModeller.getGenericType(concreteClass, m.getDeclaringClass(), m.getReturnType(), m.getGenericReturnType());
    }

    private static void workOutSubResourceMethodsList(ResourceClass resource, MethodList methodList, boolean isEncoded, Consumes classScopeConsumesAnnotation, Produces classScopeProducesAnnotation) {
        for (AnnotatedMethod m : methodList.hasMetaAnnotation(HttpMethod.class).hasAnnotation(Path.class)) {
            ClassTypePair ct;
            boolean emptySegmentCase;
            Path mPathAnnotation = (Path)m.getAnnotation(Path.class);
            PathValue pv = new PathValue(mPathAnnotation.value());
            boolean bl = emptySegmentCase = "/".equals(pv.getValue()) || "".equals(pv.getValue());
            if (!emptySegmentCase) {
                ct = IntrospectionModeller.getGenericReturnType(resource.getResourceClass(), m.getMethod());
                SubResourceMethod abstractSubResourceMethod = new SubResourceMethod(resource, m.getMethod(), ct.rawClass(), ct.type(), pv, ((HttpMethod)m.getMetaMethodAnnotations(HttpMethod.class).get(0)).value(), m.getAnnotations());
                IntrospectionModeller.addConsumes(m, abstractSubResourceMethod, classScopeConsumesAnnotation);
                IntrospectionModeller.addProduces(m, abstractSubResourceMethod, classScopeProducesAnnotation);
                IntrospectionModeller.declareSuspend(m, abstractSubResourceMethod);
                IntrospectionModeller.processParameters(abstractSubResourceMethod.getDeclaringResource().getResourceClass(), abstractSubResourceMethod.getMethod().getDeclaringClass(), (Parameterized)abstractSubResourceMethod, m, isEncoded);
                resource.getSubResourceMethods().add(abstractSubResourceMethod);
                continue;
            }
            ct = IntrospectionModeller.getGenericReturnType(resource.getResourceClass(), m.getMethod());
            ResourceMethod abstractResourceMethod = new ResourceMethod(resource, m.getMethod(), ct.rawClass(), ct.type(), ((HttpMethod)m.getMetaMethodAnnotations(HttpMethod.class).get(0)).value(), m.getAnnotations());
            IntrospectionModeller.addConsumes(m, abstractResourceMethod, classScopeConsumesAnnotation);
            IntrospectionModeller.addProduces(m, abstractResourceMethod, classScopeProducesAnnotation);
            IntrospectionModeller.processParameters(abstractResourceMethod.getDeclaringResource().getResourceClass(), abstractResourceMethod.getMethod().getDeclaringClass(), (Parameterized)abstractResourceMethod, m, isEncoded);
            resource.getResourceMethods().add(abstractResourceMethod);
        }
    }

    private static void workOutSubResourceLocatorsList(ResourceClass resource, MethodList methodList, boolean isEncoded) {
        for (AnnotatedMethod m : methodList.hasNotMetaAnnotation(HttpMethod.class).hasAnnotation(Path.class)) {
            Path mPathAnnotation = (Path)m.getAnnotation(Path.class);
            SubResourceLocator subResourceLocator = new SubResourceLocator(resource, m.getMethod(), new PathValue(mPathAnnotation.value()), m.getAnnotations());
            IntrospectionModeller.processParameters(subResourceLocator.getResource().getResourceClass(), subResourceLocator.getMethod().getDeclaringClass(), (Parameterized)subResourceLocator, m, isEncoded);
            resource.getSubResourceLocators().add(subResourceLocator);
        }
    }

    private static void processParameters(Class concreteClass, Class declaringClass, Parameterized parametrized, Constructor<?> ctor, boolean isEncoded) {
        Type[] genericParameterTypes;
        Class[] parameterTypes = ctor.getParameterTypes();
        if (parameterTypes.length != (genericParameterTypes = ctor.getGenericParameterTypes()).length) {
            Type[] _genericParameterTypes = new Type[parameterTypes.length];
            _genericParameterTypes[0] = parameterTypes[0];
            System.arraycopy(genericParameterTypes, 0, _genericParameterTypes, 1, genericParameterTypes.length);
            genericParameterTypes = _genericParameterTypes;
        }
        IntrospectionModeller.processParameters(concreteClass, declaringClass, parametrized, null != ctor.getAnnotation(Encoded.class) || isEncoded, parameterTypes, genericParameterTypes, ctor.getParameterAnnotations());
    }

    private static void processParameters(Class concreteClass, Class declaringClass, Parameterized parametrized, AnnotatedMethod method, boolean isEncoded) {
        IntrospectionModeller.processParameters(concreteClass, declaringClass, parametrized, null != method.getAnnotation(Encoded.class) || isEncoded, method.getParameterTypes(), method.getGenericParameterTypes(), method.getParameterAnnotations());
    }

    private static void processParameters(Class concreteClass, Class declaringClass, Parameterized parametrized, boolean isEncoded, Class[] parameterTypes, Type[] genericParameterTypes, Annotation[][] parameterAnnotations) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            Parameter parameter = IntrospectionModeller.createParameter(concreteClass, declaringClass, isEncoded, parameterTypes[i], genericParameterTypes[i], parameterAnnotations[i]);
            if (null == parameter) {
                parametrized.getParameters().removeAll(parametrized.getParameters());
                break;
            }
            parametrized.getParameters().add(parameter);
        }
    }

    private static Map<Class, ParamAnnotationHelper> createParamAnotHelperMap() {
        WeakHashMap<Class<FormParam>, ParamAnnotationHelper<Context>> m = new WeakHashMap<Class<FormParam>, ParamAnnotationHelper<Context>>();
        m.put(Context.class, new ParamAnnotationHelper<Context>(){

            @Override
            public String getValueOf(Context a) {
                return null;
            }

            @Override
            public Parameter.Source getSource() {
                return Parameter.Source.CONTEXT;
            }
        });
        m.put(HeaderParam.class, new ParamAnnotationHelper<HeaderParam>(){

            @Override
            public String getValueOf(HeaderParam a) {
                return a.value();
            }

            @Override
            public Parameter.Source getSource() {
                return Parameter.Source.HEADER;
            }
        });
        m.put(CookieParam.class, new ParamAnnotationHelper<CookieParam>(){

            @Override
            public String getValueOf(CookieParam a) {
                return a.value();
            }

            @Override
            public Parameter.Source getSource() {
                return Parameter.Source.COOKIE;
            }
        });
        m.put(MatrixParam.class, new ParamAnnotationHelper<MatrixParam>(){

            @Override
            public String getValueOf(MatrixParam a) {
                return a.value();
            }

            @Override
            public Parameter.Source getSource() {
                return Parameter.Source.MATRIX;
            }
        });
        m.put(QueryParam.class, new ParamAnnotationHelper<QueryParam>(){

            @Override
            public String getValueOf(QueryParam a) {
                return a.value();
            }

            @Override
            public Parameter.Source getSource() {
                return Parameter.Source.QUERY;
            }
        });
        m.put(PathParam.class, new ParamAnnotationHelper<PathParam>(){

            @Override
            public String getValueOf(PathParam a) {
                return a.value();
            }

            @Override
            public Parameter.Source getSource() {
                return Parameter.Source.PATH;
            }
        });
        m.put(FormParam.class, new ParamAnnotationHelper<FormParam>(){

            @Override
            public String getValueOf(FormParam a) {
                return a.value();
            }

            @Override
            public Parameter.Source getSource() {
                return Parameter.Source.FORM;
            }
        });
        return Collections.unmodifiableMap(m);
    }

    public static Parameter createParameter(Class concreteClass, Class declaringClass, boolean isEncoded, Class<?> paramClass, Type paramType, Annotation[] annotations) {
        if (null == annotations) {
            return null;
        }
        Annotation paramAnnotation = null;
        Parameter.Source paramSource = null;
        String paramName = null;
        boolean paramEncoded = isEncoded;
        String paramDefault = null;
        for (Annotation annotation : annotations) {
            if (ANOT_HELPER_MAP.containsKey(annotation.annotationType())) {
                ParamAnnotationHelper helper = ANOT_HELPER_MAP.get(annotation.annotationType());
                paramAnnotation = annotation;
                paramSource = helper.getSource();
                paramName = helper.getValueOf(annotation);
                continue;
            }
            if (Encoded.class == annotation.annotationType()) {
                paramEncoded = true;
                continue;
            }
            if (DefaultValue.class == annotation.annotationType()) {
                paramDefault = ((DefaultValue)annotation).value();
                continue;
            }
            paramAnnotation = annotation;
            paramSource = Parameter.Source.UNKNOWN;
            paramName = IntrospectionModeller.getValue(annotation);
        }
        if (paramAnnotation == null) {
            paramSource = Parameter.Source.ENTITY;
        }
        ClassTypePair ct = IntrospectionModeller.getGenericType(concreteClass, declaringClass, paramClass, paramType);
        paramType = ct.type();
        paramClass = ct.rawClass();
        return new Parameter(annotations, paramAnnotation, paramSource, paramName, paramType, paramClass, paramEncoded, paramDefault);
    }

    private static String getValue(Annotation a) {
        try {
            Method m = a.annotationType().getMethod("value", new Class[0]);
            if (m.getReturnType() != String.class) {
                return null;
            }
            return (String)m.invoke((Object)a, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static ClassTypePair getGenericType(Class concreteClass, Class declaringClass, Class c, Type t) {
        if (t instanceof TypeVariable) {
            ClassTypePair ct = ReflectionHelper.resolveTypeVariable((Class)concreteClass, (Class)declaringClass, (TypeVariable)((TypeVariable)t));
            if (ct != null) {
                return ct;
            }
        } else if (t instanceof ParameterizedType) {
            final ParameterizedType pt = (ParameterizedType)t;
            final Type[] ptts = pt.getActualTypeArguments();
            boolean modified = false;
            for (int i = 0; i < ptts.length; ++i) {
                ClassTypePair ct = IntrospectionModeller.getGenericType(concreteClass, declaringClass, (Class)pt.getRawType(), ptts[i]);
                if (ct.type() == ptts[i]) continue;
                ptts[i] = ct.type();
                modified = true;
            }
            if (modified) {
                ParameterizedType rpt = new ParameterizedType(){

                    @Override
                    public Type[] getActualTypeArguments() {
                        return (Type[])ptts.clone();
                    }

                    @Override
                    public Type getRawType() {
                        return pt.getRawType();
                    }

                    @Override
                    public Type getOwnerType() {
                        return pt.getOwnerType();
                    }
                };
                return ClassTypePair.of((Class)((Class)pt.getRawType()), (Type)rpt);
            }
        } else if (t instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)t;
            ClassTypePair ct = IntrospectionModeller.getGenericType(concreteClass, declaringClass, null, gat.getGenericComponentType());
            if (gat.getGenericComponentType() != ct.type()) {
                try {
                    Class ac = ReflectionHelper.getArrayClass((Class)ct.rawClass());
                    return ClassTypePair.of((Class)ac);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return ClassTypePair.of((Class)c, (Type)t);
    }

    private IntrospectionModeller() {
    }

    private static interface ParamAnnotationHelper<T extends Annotation> {
        public String getValueOf(T var1);

        public Parameter.Source getSource();
    }
}

