/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.glassfish.jersey.server.model.AbstractResourceMethod;
import org.glassfish.jersey.server.model.PathAnnotated;
import org.glassfish.jersey.server.model.PathValue;
import org.glassfish.jersey.server.model.ResourceConstructor;
import org.glassfish.jersey.server.model.ResourceModelComponent;
import org.glassfish.jersey.server.model.ResourceModelVisitor;
import org.glassfish.jersey.server.model.SubResourceLocator;
import org.glassfish.jersey.server.model.SubResourceMethod;

public class ResourceClass
implements PathAnnotated,
ResourceModelComponent {
    private final Class<?> resourceClass;
    private final PathValue uriPath;
    private final List<ResourceConstructor> constructors;
    private final List<AbstractResourceMethod> resourceMethods;
    private final List<SubResourceMethod> subResourceMethods;
    private final List<SubResourceLocator> subResourceLocators;

    public ResourceClass(Class<?> resourceClass) {
        this(resourceClass, null);
    }

    public ResourceClass(Class<?> resourceClass, @Nullable PathValue uriPath) {
        this.resourceClass = resourceClass;
        this.uriPath = uriPath;
        this.constructors = new ArrayList<ResourceConstructor>(4);
        this.resourceMethods = new ArrayList<AbstractResourceMethod>(4);
        this.subResourceLocators = new ArrayList<SubResourceLocator>(4);
        this.subResourceMethods = new ArrayList<SubResourceMethod>(4);
    }

    public ResourceClass(String path, ResourceClass ar) {
        this.uriPath = new PathValue(path);
        this.resourceClass = ar.resourceClass;
        this.constructors = ar.constructors;
        this.resourceMethods = ar.resourceMethods;
        this.subResourceMethods = ar.subResourceMethods;
        this.subResourceLocators = ar.subResourceLocators;
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public boolean isSubResource() {
        return this.uriPath == null;
    }

    public boolean isRootResource() {
        return this.uriPath != null;
    }

    @Override
    public PathValue getPath() {
        return this.uriPath;
    }

    public List<ResourceConstructor> getConstructors() {
        return this.constructors;
    }

    public List<AbstractResourceMethod> getResourceMethods() {
        return this.resourceMethods;
    }

    public List<SubResourceMethod> getSubResourceMethods() {
        return this.subResourceMethods;
    }

    public List<SubResourceLocator> getSubResourceLocators() {
        return this.subResourceLocators;
    }

    @Override
    public void accept(ResourceModelVisitor visitor) {
        visitor.visitResourceClass(this);
    }

    public String toString() {
        return "Resource(" + (null == this.getPath() ? "" : "\"" + this.getPath().getValue() + "\", - ") + (this.getResourceClass() != null ? this.getResourceClass().getSimpleName() : "<virtualResourceClass>") + ": " + this.getConstructors().size() + " constructors, " + this.getResourceMethods().size() + " res methods, " + this.getSubResourceMethods().size() + " subres methods, " + this.getSubResourceLocators().size() + " subres locators " + ")";
    }

    @Override
    public List<ResourceModelComponent> getComponents() {
        LinkedList<ResourceModelComponent> components = new LinkedList<ResourceModelComponent>();
        components.addAll(this.getConstructors());
        components.addAll(this.getResourceMethods());
        components.addAll(this.getSubResourceMethods());
        components.addAll(this.getSubResourceLocators());
        return components;
    }
}

