/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.lang.reflect.InvocationHandler;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.scopes.Singleton;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.model.InvocableResourceMethod;
import org.glassfish.jersey.server.spi.internal.ResourceMethodDispatcher;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;

@Scoped(value=Singleton.class)
final class ResourceMethodDispatcherFactory
implements ResourceMethodDispatcher.Provider {
    private static final Logger LOGGER = Logger.getLogger(ResourceMethodDispatcherFactory.class.getName());
    private final Set<ResourceMethodDispatcher.Provider> providers;

    ResourceMethodDispatcherFactory(@Inject Services services) {
        this.providers = Providers.getProviders((Services)services, ResourceMethodDispatcher.Provider.class);
    }

    @Override
    public ResourceMethodDispatcher create(InvocableResourceMethod resourceMethod, InvocationHandler handler) {
        for (ResourceMethodDispatcher.Provider provider : this.providers) {
            try {
                ResourceMethodDispatcher dispatcher = provider.create(resourceMethod, handler);
                if (dispatcher == null) continue;
                return dispatcher;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_PROCESSING_METHOD(resourceMethod, provider.getClass().getName()), e);
            }
        }
        return null;
    }
}

