/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.InvocationContext;
import org.glassfish.jersey.server.internal.routing.RouterModule;
import org.glassfish.jersey.server.model.InvocableResourceMethod;
import org.glassfish.jersey.server.model.ResourceMethodDispatcherFactory;
import org.glassfish.jersey.server.model.ResourceMethodInvocationHandlerFactory;
import org.glassfish.jersey.server.spi.internal.ResourceMethodDispatcher;
import org.glassfish.jersey.server.spi.internal.ResourceMethodInvocationHandlerProvider;
import org.jvnet.hk2.annotations.Inject;

public class ResourceMethodInvoker
implements Inflector<Request, Response> {
    private Factory<RouterModule.RoutingContext> routingContextFactory;
    private Factory<InvocationContext> invocationContextFactory;
    private final InvocableResourceMethod method;
    private final ResourceMethodDispatcher dispatcher;

    private ResourceMethodInvoker(Factory<RouterModule.RoutingContext> routingContextFactory, Factory<InvocationContext> invocationContextFactory, ResourceMethodDispatcher.Provider dispatcherProvider, ResourceMethodInvocationHandlerProvider invocationHandlerProvider, InvocableResourceMethod method) {
        this.routingContextFactory = routingContextFactory;
        this.invocationContextFactory = invocationContextFactory;
        this.method = method;
        this.dispatcher = dispatcherProvider.create(method, invocationHandlerProvider.create(method));
    }

    public Response apply(Request request) {
        Object resource = ((RouterModule.RoutingContext)this.routingContextFactory.get()).peekMatchedResource();
        InvocationContext invocationCtx = (InvocationContext)this.invocationContextFactory.get();
        if (this.method.isSuspendDeclared()) {
            invocationCtx.setSuspendTimeout(this.method.getSuspendTimeout(), this.method.getSuspendTimeoutUnit());
        }
        Response response = this.dispatcher.dispatch(resource, request);
        RouterModule.RoutingContext routingCtx = (RouterModule.RoutingContext)this.routingContextFactory.get();
        routingCtx.setResponseMethodType(this.method.getGenericReturnType());
        routingCtx.setResponseMethodAnnotations(this.method.getMethod().getDeclaredAnnotations());
        if (this.method.isSuspendDeclared()) {
            invocationCtx.setResponse(resource);
            invocationCtx.trySuspend();
        }
        return response;
    }

    public String toString() {
        return this.method.getMethod().toString();
    }

    public static class Builder {
        @Inject
        private Factory<RouterModule.RoutingContext> routingContextFactory;
        @Inject
        private Factory<InvocationContext> invocationContextFactory;
        @Inject
        private ResourceMethodDispatcherFactory dispatcherProviderFactory;
        @Inject
        private ResourceMethodInvocationHandlerFactory invocationHandlerProviderFactory;

        public ResourceMethodInvoker build(InvocableResourceMethod method) {
            return new ResourceMethodInvoker(this.routingContextFactory, this.invocationContextFactory, this.dispatcherProviderFactory, this.invocationHandlerProviderFactory, method);
        }
    }
}

