/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.Parameterized;
import org.glassfish.jersey.server.model.PathAnnotated;
import org.glassfish.jersey.server.model.PathValue;
import org.glassfish.jersey.server.model.ResourceClass;
import org.glassfish.jersey.server.model.ResourceModelComponent;
import org.glassfish.jersey.server.model.ResourceModelVisitor;

public class SubResourceLocator
implements PathAnnotated,
Parameterized,
ResourceModelComponent {
    private ResourceClass resource;
    private Method method;
    private Annotation[] annotations;
    private PathValue uriPath;
    private List<Parameter> parameters;

    public SubResourceLocator(ResourceClass resource, Method method, PathValue uriPath, Annotation[] annotations) {
        this.resource = resource;
        this.method = method;
        this.annotations = annotations;
        this.uriPath = uriPath;
        this.parameters = new ArrayList<Parameter>();
    }

    public Annotation[] getAnnotations() {
        return (Annotation[])this.annotations.clone();
    }

    public Method getMethod() {
        return this.method;
    }

    public ResourceClass getResource() {
        return this.resource;
    }

    @Override
    public PathValue getPath() {
        return this.uriPath;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean hasEntity() {
        for (Parameter p : this.getParameters()) {
            if (Parameter.Source.ENTITY != p.getSource()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void accept(ResourceModelVisitor visitor) {
        visitor.visitSubResourceLocator(this);
    }

    @Override
    public List<ResourceModelComponent> getComponents() {
        return null;
    }

    public String toString() {
        return "AbstractSubResourceLocator(" + this.getMethod().getDeclaringClass().getSimpleName() + "#" + this.getMethod().getName() + ")";
    }
}

