/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.MessageBodyWriter;
import org.glassfish.hk2.ComponentException;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.HK2;
import org.glassfish.hk2.Module;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.hk2.scopes.Singleton;
import org.glassfish.jersey.FeaturesAndProperties;
import org.glassfish.jersey.internal.ContextResolverFactory;
import org.glassfish.jersey.internal.ExceptionMapperFactory;
import org.glassfish.jersey.internal.MappableException;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.ServiceProviders;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.internal.util.CommittingOutputStream;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.HeaderValueException;
import org.glassfish.jersey.message.internal.MessageBodyFactory;
import org.glassfish.jersey.message.internal.Requests;
import org.glassfish.jersey.message.internal.Responses;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.InflectorNotFoundException;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.InvocationContext;
import org.glassfish.jersey.process.internal.PreMatchRequestFilterAcceptor;
import org.glassfish.jersey.process.internal.RequestInvoker;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.TreeAcceptor;
import org.glassfish.jersey.server.ContainerResponseWriterCallback;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ServerModule;
import org.glassfish.jersey.server.TimingOutInvocationCallback;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.routing.RouterModule;
import org.glassfish.jersey.server.internal.routing.RuntimeModelProviderFromRootResource;
import org.glassfish.jersey.server.model.BasicValidator;
import org.glassfish.jersey.server.model.IntrospectionModeller;
import org.glassfish.jersey.server.model.ResourceClass;
import org.glassfish.jersey.server.model.ResourceModelIssue;
import org.glassfish.jersey.server.model.ResourceModelValidator;
import org.glassfish.jersey.server.spi.ContainerRequestContext;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.server.spi.RequestScopedInitializer;
import org.glassfish.jersey.spi.ContextResolvers;
import org.glassfish.jersey.spi.ExceptionMappers;
import org.jvnet.hk2.annotations.Inject;

public final class ApplicationHandler
implements Inflector<Request, Future<Response>> {
    private static final Logger LOGGER = Logger.getLogger(ApplicationHandler.class.getName());
    private static final SecurityContext DEFAULT_SECURITY_CONTEXT = new SecurityContext(){

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return false;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public String getAuthenticationScheme() {
            return null;
        }
    };
    @Inject
    private PreMatchRequestFilterAcceptor preMatchFilterAcceptor;
    @Inject
    private RequestScope requestScope;
    @Inject
    private RequestInvoker invoker;
    @Inject
    private Factory<RouterModule.RoutingContext> routingContextFactory;
    @Inject
    Factory<Ref<SecurityContext>> securityContextRefFactory;
    private Services services;
    private TreeAcceptor rootAcceptor;
    private final ResourceConfig configuration;
    private ResourceConfig immutableConfigurationView;
    private References refs;

    public ApplicationHandler() {
        this.configuration = new ResourceConfig();
        this.initialize();
    }

    public ApplicationHandler(Class<? extends Application> jaxrsApplicationClass) {
        if (ResourceConfig.class.isAssignableFrom(jaxrsApplicationClass)) {
            // empty if block
        }
        this.configuration = new ResourceConfig(jaxrsApplicationClass);
        this.initialize();
    }

    public ApplicationHandler(Application application) {
        this.configuration = application instanceof ResourceConfig ? (ResourceConfig)application : new ResourceConfig(application);
        this.initialize();
    }

    private void initialize() {
        this.services = HK2.get().create(null, new Module[]{new ServerModule(), new ApplicationModule()});
        Class<? extends Application> applicationClass = this.configuration.getApplicationClass();
        if (applicationClass != null) {
            this.configuration.setApplication((Application)this.services.forContract(applicationClass).get());
        }
        this.immutableConfigurationView = ResourceConfig.unmodifiableCopy(this.configuration);
        HashMap pathToResourceMap = Maps.newHashMap();
        HashSet resources = Sets.newHashSet();
        for (Class<?> c : this.configuration.getClasses()) {
            if (!IntrospectionModeller.isRootResource(c)) continue;
            try {
                ResourceClass resource = IntrospectionModeller.createResource(c);
                resources.add(resource);
                pathToResourceMap.put(resource.getPath().getValue(), resource);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warning(ex.getMessage());
            }
        }
        for (ResourceClass programmaticResource : this.configuration.getResources()) {
            ResourceClass r = (ResourceClass)pathToResourceMap.get(programmaticResource.getPath().getValue());
            if (r != null) {
                r.getResourceMethods().addAll(programmaticResource.getResourceMethods());
                r.getSubResourceMethods().addAll(programmaticResource.getSubResourceMethods());
                r.getSubResourceLocators().addAll(programmaticResource.getSubResourceLocators());
                continue;
            }
            resources.add(programmaticResource);
        }
        Injector injector = (Injector)this.services.forContract(Injector.class).get();
        this.refs = (References)injector.inject(References.class);
        ServiceProviders providers = ((ServiceProviders.Builder)this.services.forContract(ServiceProviders.Builder.class).get()).setProviderClasses(Sets.filter(this.configuration.getClasses(), (Predicate)new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                boolean acceptable = IntrospectionModeller.isAcceptable(input);
                if (!acceptable) {
                    LOGGER.warning(LocalizationMessages.NON_INSTANTIATABLE_CLASS(input));
                }
                return acceptable;
            }
        })).setProviderInstances(this.configuration.getSingletons()).build();
        this.refs.providers.set((Object)providers);
        MessageBodyFactory workers = new MessageBodyFactory(providers);
        this.refs.workers.set((Object)workers);
        this.refs.mappers.set((Object)new ExceptionMapperFactory(providers));
        this.refs.resolvers.set((Object)new ContextResolverFactory(providers));
        this.validateResources((MessageBodyWorkers)workers, resources);
        RuntimeModelProviderFromRootResource runtimeModelCreator = (RuntimeModelProviderFromRootResource)this.services.byType(RuntimeModelProviderFromRootResource.class).get();
        runtimeModelCreator.setWorkers((MessageBodyWorkers)workers);
        for (ResourceClass r : resources) {
            runtimeModelCreator.process(r);
        }
        this.rootAcceptor = runtimeModelCreator.getRuntimeModel();
        injector.inject((Object)this);
    }

    private void validateResources(MessageBodyWorkers workers, Set<ResourceClass> resources) {
        BasicValidator validator = new BasicValidator(workers);
        for (ResourceClass r : resources) {
            validator.validate(r);
        }
        this.processIssues(validator);
    }

    private void processIssues(ResourceModelValidator validator) {
        List<ResourceModelIssue> issueList = validator.getIssueList();
        if (!issueList.isEmpty()) {
            String allIssueMessages = this.allIssueLogMessages(validator.getIssueList());
            if (validator.fatalIssuesFound()) {
                LOGGER.severe(LocalizationMessages.ERRORS_AND_WARNINGS_DETECTED_WITH_RESOURCE_CLASSES(allIssueMessages));
            } else {
                LOGGER.warning(LocalizationMessages.WARNINGS_DETECTED_WITH_RESOURCE_CLASSES(allIssueMessages));
            }
        }
        if (validator.fatalIssuesFound()) {
            throw new ResourceModelValidator.ModelException(issueList);
        }
    }

    private String allIssueLogMessages(List<ResourceModelIssue> issueList) {
        StringBuilder errors = new StringBuilder("\n");
        StringBuilder warnings = new StringBuilder();
        for (ResourceModelIssue issue : issueList) {
            if (issue.isFatal()) {
                errors.append(LocalizationMessages.ERROR_MSG(issue.getMessage())).append('\n');
                continue;
            }
            warnings.append(LocalizationMessages.WARNING_MSG(issue.getMessage())).append('\n');
        }
        return errors.append((CharSequence)warnings).toString();
    }

    public Future<Response> apply(Request request) {
        TimingOutInvocationCallback callback = new TimingOutInvocationCallback(){

            @Override
            protected Response handleFailure(Throwable exception) {
                return ApplicationHandler.handleFailure(exception);
            }

            @Override
            protected Response handleTimeout(InvocationContext context) {
                return ApplicationHandler.prepareTimeoutResponse(context);
            }
        };
        this.apply(request, callback, DEFAULT_SECURITY_CONTEXT, null);
        return callback;
    }

    public void apply(final ContainerRequestContext containerContext) {
        this.checkContainerRequestContext(containerContext);
        ContainerResponseWriterCallback callback = new ContainerResponseWriterCallback(containerContext.getRequest(), containerContext.getResponseWriter()){

            @Override
            protected void writeResponse(Response response) {
                ApplicationHandler.this.writeResponse(containerContext.getResponseWriter(), this.request, response);
            }

            @Override
            protected void writeResponse(Throwable exception) {
                ApplicationHandler.this.writeResponse(containerContext.getResponseWriter(), this.request, ApplicationHandler.handleFailure(exception));
            }

            @Override
            protected void writeTimeoutResponse(InvocationContext context) {
                ApplicationHandler.this.writeResponse(containerContext.getResponseWriter(), this.request, ApplicationHandler.prepareTimeoutResponse(context));
            }
        };
        this.apply(containerContext.getRequest(), callback, containerContext.getSecurityContext(), containerContext.getRequestScopedInitializer());
        callback.suspendWriterIfRunning();
    }

    private void checkContainerRequestContext(ContainerRequestContext containerContext) {
        if (containerContext.getSecurityContext() == null) {
            throw new IllegalArgumentException("SecurityContext from ContainerRequestContext must not be null.");
        }
        if (containerContext.getRequest() == null) {
            throw new IllegalArgumentException("Request from ContainerRequestContext must not be null.");
        }
        if (containerContext.getResponseWriter() == null) {
            throw new IllegalArgumentException("ResponseWriter from ContainerRequestContext must not be null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply(Request request, InvocationCallback callback, SecurityContext securityContext, RequestScopedInitializer requestScopeInitializer) {
        try {
            this.requestScope.enter();
            this.initRequestScopeInjections(securityContext, requestScopeInitializer);
            Pair pair = this.preMatchFilterAcceptor.apply(request);
            this.invoker.apply((Request)pair.left(), callback);
        }
        finally {
            this.requestScope.exit();
        }
    }

    private void initRequestScopeInjections(SecurityContext securityContext, RequestScopedInitializer requestScopeInitializer) {
        Ref secReference = (Ref)this.securityContextRefFactory.get();
        secReference.set((Object)securityContext);
        if (requestScopeInitializer != null) {
            requestScopeInitializer.initialize(this.services);
        }
    }

    private static Response prepareTimeoutResponse(InvocationContext context) {
        Response response = context.getResponse();
        if (response == null) {
            response = Response.serverError().entity((Object)"Request processing has timed out.").type("text/plain").build();
        }
        return response;
    }

    private static Response handleFailure(Throwable failure) {
        Response.Status statusCode = Response.Status.INTERNAL_SERVER_ERROR;
        String message = failure.getMessage();
        if (failure instanceof ProcessingException) {
            if (failure instanceof HeaderValueException) {
                statusCode = Response.Status.BAD_REQUEST;
            } else if (failure instanceof InflectorNotFoundException) {
                statusCode = Response.Status.NOT_FOUND;
                message = "Requested resource not found.";
            }
        }
        if (statusCode == Response.Status.INTERNAL_SERVER_ERROR) {
            LOGGER.log(Level.SEVERE, message, failure);
        } else {
            LOGGER.log(Level.FINE, message, failure);
        }
        return Response.status((Response.StatusType)statusCode).entity((Object)message).type("text/plain").build();
    }

    private void writeResponse(final ContainerResponseWriter writer, Request request, Response response) {
        try {
            boolean entityExists = response.hasEntity();
            MessageBodyWorkers workers = Requests.getMessageWorkers((Request)request);
            if (entityExists) {
                Object entity = response.getEntity();
                RouterModule.RoutingContext routingContext = (RouterModule.RoutingContext)this.routingContextFactory.get();
                MediaType outputType = routingContext.getEffectiveAcceptableType();
                Annotation[] outputAnnotations = routingContext.getResponseMethodAnnotations();
                Class<?> entityType = routingContext.getResponseMethodType();
                if (entityType == null || entityType == Void.class) {
                    Class<?> genericSuperclass = entity.getClass().getGenericSuperclass();
                    Class<?> clazz = entityType = genericSuperclass instanceof ParameterizedType ? genericSuperclass : entity.getClass();
                }
                if (response.getHeaders().getMediaType() == null) {
                    response = Responses.toBuilder((Response)response).type(outputType).build();
                }
                final Response outResponse = response;
                CommittingOutputStream commitingOutput = new CommittingOutputStream(){
                    private OutputStream output;

                    protected void commit() throws IOException {
                        this.output = writer.writeResponseStatusAndHeaders(-1L, outResponse);
                    }

                    protected OutputStream getOutputStream() throws IOException {
                        return this.output;
                    }
                };
                MessageBodyWriter bWriter = workers.getMessageBodyWriter(entity.getClass(), entityType, outputAnnotations, outputType);
                bWriter.writeTo(entity, entity.getClass(), entityType, outputAnnotations, outputType, response.getMetadata(), (OutputStream)commitingOutput);
            } else {
                writer.writeResponseStatusAndHeaders(0L, response);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ApplicationHandler.class.getName()).log(Level.SEVERE, null, ex);
            throw new MappableException((Throwable)ex);
        }
        finally {
            writer.commit();
        }
    }

    public Services getServices() {
        return this.services;
    }

    public ServiceProviders getServiceProviders() {
        return (ServiceProviders)this.refs.providers.get();
    }

    public ResourceConfig getConfiguration() {
        return this.immutableConfigurationView;
    }

    private class ApplicationModule
    extends AbstractModule {
        private ApplicationModule() {
        }

        protected void configure() {
            ResourceConfigProvider rcp = new ResourceConfigProvider();
            this.bind(ResourceConfig.class, new Class[0]).toFactory((Factory)rcp).in(Singleton.class);
            this.bind(FeaturesAndProperties.class, new Class[0]).toFactory((Factory)rcp).in(Singleton.class);
            this.bind(Application.class, new Class[0]).toFactory((Factory)new JaxrsApplicationProvider()).in(Singleton.class);
            this.bind(ApplicationHandler.class, new Class[0]).toInstance((Object)ApplicationHandler.this);
            this.bind(TreeAcceptor.class, new Class[0]).annotatedWith(Stage.Root.class).toFactory((Factory)new RootAcceptorProvider()).in(Singleton.class);
            this.bind().to(PreMatchRequestFilterAcceptor.class).in(Singleton.class);
            for (Module m : ApplicationHandler.this.configuration.getCustomModules()) {
                this.install(new Module[]{m});
            }
        }

        private class ResourceConfigProvider
        implements Factory<ResourceConfig> {
            private ResourceConfigProvider() {
            }

            public ResourceConfig get() throws ComponentException {
                return ApplicationHandler.this.immutableConfigurationView;
            }
        }

        private class JaxrsApplicationProvider
        implements Factory<Application> {
            private JaxrsApplicationProvider() {
            }

            public Application get() throws ComponentException {
                return ApplicationHandler.this.configuration.getApplication();
            }
        }

        private class RootAcceptorProvider
        implements Factory<TreeAcceptor> {
            private RootAcceptorProvider() {
            }

            public TreeAcceptor get() {
                return ApplicationHandler.this.rootAcceptor;
            }
        }
    }

    private static class References {
        @Inject
        private Ref<ServiceProviders> providers;
        @Inject
        private Ref<ExceptionMappers> mappers;
        @Inject
        private Ref<MessageBodyWorkers> workers;
        @Inject
        private Ref<ContextResolvers> resolvers;

        private References() {
        }
    }
}

