/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.InflectorBasedResourceMethod;
import org.glassfish.jersey.server.model.PathValue;
import org.glassfish.jersey.server.model.ResourceBuilder;
import org.glassfish.jersey.server.model.ResourceClass;
import org.jvnet.hk2.annotations.Inject;

class DefaultResourceBuilder
implements ResourceBuilder {
    private static final Logger LOGGER = Logger.getLogger(DefaultResourceBuilder.class.getName());
    ApplicationHandler application;
    ResourceConfig resourceConfig;
    private Set<ResourceClass> resources = Sets.newHashSet();
    private Map<String, ResourceClass> pathToResource = Maps.newHashMap();

    DefaultResourceBuilder() {
    }

    @Override
    public ResourceBuilder.BoundResourceBuilder path(String path) {
        return new BoundBuilder(path);
    }

    @Override
    public Set<ResourceClass> build() {
        return Sets.newHashSet(this.resources);
    }

    private class BoundBuilder
    implements ResourceBuilder.BoundResourceBuilder {
        final ResourceClass resource;
        final Set<String> methods = new HashSet<String>();
        private final List<MediaType> resourceConsumes = new ArrayList<MediaType>();
        private final List<MediaType> resourceProduces = new ArrayList<MediaType>();
        private final ResourceBuilder.ResourceMethodBuilder resourceMethodBuilder = new ResourceBuilder.ResourceMethodBuilder(){
            private final BoundBuilder applicationBuilder;
            private final List<MediaType> methodConsumes;
            private final List<MediaType> methodProduces;
            {
                this.applicationBuilder = BoundBuilder.this;
                this.methodConsumes = new ArrayList<MediaType>();
                this.methodProduces = new ArrayList<MediaType>();
            }

            @Override
            public ResourceBuilder.BoundResourceBuilder to(Inflector<Request, Response> transformation) {
                for (String method : BoundBuilder.this.methods) {
                    List effectiveInputTypes = this.methodConsumes.isEmpty() ? BoundBuilder.this.resourceConsumes : this.methodConsumes;
                    List effectiveOutputTypes = this.methodProduces.isEmpty() ? BoundBuilder.this.resourceProduces : this.methodProduces;
                    BoundBuilder.this.resource.getResourceMethods().add(new InflectorBasedResourceMethod(BoundBuilder.this.resource, method, effectiveInputTypes, effectiveOutputTypes, transformation));
                }
                BoundBuilder.this.methods.clear();
                return this.applicationBuilder;
            }

            @Override
            public ResourceBuilder.BoundResourceBuilder to(final Class<? extends Inflector<Request, Response>> transformationClass) {
                return this.to(new Inflector<Request, Response>(){
                    @Inject
                    private Injector injector;

                    public Response apply(Request data) {
                        Inflector transformation = (Inflector)this.injector.inject(transformationClass);
                        return (Response)transformation.apply((Object)data);
                    }
                });
            }

            @Override
            public ResourceBuilder.ResourceMethodBuilder produces(MediaType ... mediaTypes) {
                this.methodProduces.addAll(Arrays.asList(mediaTypes));
                return BoundBuilder.this.resourceMethodBuilder;
            }

            @Override
            public ResourceBuilder.ResourceMethodBuilder consumes(MediaType ... mediaTypes) {
                this.methodConsumes.addAll(Arrays.asList(mediaTypes));
                return BoundBuilder.this.resourceMethodBuilder;
            }
        };

        public BoundBuilder(String path) {
            this.resource = this.getResourceClass(path);
        }

        public BoundBuilder(String path, String method, Inflector<Request, Response> transformation) {
            Preconditions.checkNotNull((Object)path, (Object)"Path must not be null.");
            Preconditions.checkNotNull((Object)method, (Object)"HTTP method must not be null.");
            Preconditions.checkArgument((!method.isEmpty() ? 1 : 0) != 0, (Object)"HTTP method must not be empty string.");
            Preconditions.checkNotNull(transformation, (Object)"Transformation must not be null.");
            this.resource = this.getResourceClass(path);
            this.resource.getResourceMethods().add(new InflectorBasedResourceMethod(this.resource, method, null, null, transformation));
        }

        private ResourceClass getResourceClass(String path) {
            ResourceClass res = (ResourceClass)DefaultResourceBuilder.this.pathToResource.get(path);
            if (res == null) {
                res = new ResourceClass(null, new PathValue(path));
                DefaultResourceBuilder.this.resources.add(res);
                DefaultResourceBuilder.this.pathToResource.put(path, res);
            }
            return res;
        }

        @Override
        public ResourceBuilder.ResourceMethodBuilder method(String ... methods) {
            for (String method : methods) {
                Preconditions.checkNotNull((Object)method, (Object)"HTTP method must not be null.");
                Preconditions.checkArgument((!method.isEmpty() ? 1 : 0) != 0, (Object)"HTTP method must not be empty string.");
                this.methods.add(method);
            }
            return this.resourceMethodBuilder;
        }

        @Override
        public ResourceBuilder.BoundResourceBuilder produces(MediaType ... mediaTypes) {
            this.resourceProduces.addAll(Arrays.asList(mediaTypes));
            return this;
        }

        @Override
        public ResourceBuilder.BoundResourceBuilder consumes(MediaType ... mediaTypes) {
            this.resourceConsumes.addAll(Arrays.asList(mediaTypes));
            return this;
        }
    }
}

