/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.ws.rs.core.Application;
import org.glassfish.hk2.Module;
import org.glassfish.jersey.FeaturesAndProperties;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.server.DefaultResourceBuilder;
import org.glassfish.jersey.server.ResourceFinder;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.scanning.AnnotationAcceptingListener;
import org.glassfish.jersey.server.internal.scanning.FilesScanner;
import org.glassfish.jersey.server.internal.scanning.PackageNamesScanner;
import org.glassfish.jersey.server.model.ResourceBuilder;
import org.glassfish.jersey.server.model.ResourceClass;
import org.glassfish.jersey.server.spi.PropertiesProvider;

public class ResourceConfig
extends Application
implements FeaturesAndProperties {
    private static final Logger LOGGER = Logger.getLogger(ResourceConfig.class.getName());
    private transient Set<Class<?>> cachedClasses = null;
    private transient Set<Class<?>> cachedClassesView = null;
    private transient Set<Object> cachedSingletons = null;
    private transient Set<Object> cachedSingletonsView = null;
    private ClassLoader classLoader = null;
    private volatile Application application;
    private Class<? extends Application> applicationClass;
    private final Set<Class<?>> classes;
    private final Set<Object> singletons;
    private final Set<ResourceClass> resources;
    private final Set<ResourceClass> resourcesView;
    private final Map<String, Object> properties;
    private final Map<String, Object> propertiesView;
    private final Set<ResourceFinder> resourceFinders;
    private final Set<Module> customModules;

    static ResourceConfig unmodifiableCopy(final ResourceConfig config) {
        return new ResourceConfig(config){
            {
                super(x0);
                ((ResourceConfig)this).application = config.getApplication();
            }

            @Override
            public ResourceConfig addClasses(Set<Class<?>> classes) {
                throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
            }

            @Override
            public ResourceConfig addResources(Set<ResourceClass> resources) {
                throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
            }

            @Override
            public ResourceConfig addFinder(ResourceFinder resourceFinder) {
                throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
            }

            @Override
            public ResourceConfig addModules(Set<Module> modules) {
                throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
            }

            @Override
            public ResourceConfig addProperties(Map<String, Object> properties) {
                throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
            }

            @Override
            public ResourceConfig addSingletons(Set<Object> singletons) {
                throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
            }

            @Override
            ResourceConfig setApplication(Application application) {
                throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
            }

            @Override
            public ResourceConfig setClassLoader(ClassLoader classLoader) {
                throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
            }

            @Override
            public ResourceConfig setProperty(String name, Object value) {
                throw new IllegalStateException(LocalizationMessages.RC_NOT_MODIFIABLE());
            }
        };
    }

    public static ResourceBuilder resourceBuilder() {
        return new DefaultResourceBuilder();
    }

    public ResourceConfig() {
        this.classLoader = ReflectionHelper.getContextClassLoader();
        this.application = null;
        this.applicationClass = null;
        this.classes = Sets.newHashSet();
        this.singletons = Sets.newHashSet();
        this.resources = Sets.newHashSet();
        this.resourcesView = Collections.unmodifiableSet(this.resources);
        this.properties = Maps.newHashMap();
        this.propertiesView = Collections.unmodifiableMap(this.properties);
        this.resourceFinders = Sets.newHashSet();
        this.customModules = Sets.newHashSet();
    }

    public ResourceConfig(Application application) {
        this();
        this.application = application;
        ResourceConfig.mergeProperties(this.properties, application);
    }

    public ResourceConfig(Class<? extends Application> applicationClass) {
        this();
        this.applicationClass = applicationClass;
    }

    public ResourceConfig(Set<Class<?>> classes) {
        this();
        this.classes.addAll(classes);
    }

    public ResourceConfig(Class<?> ... classes) {
        this(Sets.newHashSet((Object[])classes));
    }

    private ResourceConfig(ClassLoader classLoader, Application application, Class<? extends Application> applicationClass, Set<Class<?>> providerClasses, Set<Object> providerInstances, Set<ResourceClass> resources, Map<String, Object> properties, Set<ResourceFinder> resourceFinders, Set<Module> customModules) {
        this.classLoader = classLoader;
        this.application = application;
        this.applicationClass = applicationClass;
        this.classes = providerClasses;
        this.singletons = providerInstances;
        this.resources = resources;
        this.resourcesView = Collections.unmodifiableSet(resources);
        this.properties = properties;
        this.propertiesView = Collections.unmodifiableMap(properties);
        this.resourceFinders = resourceFinders;
        this.customModules = customModules;
    }

    public ResourceConfig(ResourceConfig that) {
        this.classLoader = that.classLoader;
        this.application = that.application;
        this.applicationClass = that.applicationClass;
        this.classes = Sets.newHashSet(that.classes);
        this.singletons = Sets.newHashSet(that.singletons);
        this.resources = Sets.newHashSet(that.resources);
        this.resourcesView = Collections.unmodifiableSet(this.resources);
        this.properties = Maps.newHashMap(that.properties);
        this.propertiesView = Collections.unmodifiableMap(this.properties);
        this.resourceFinders = Sets.newHashSet(that.resourceFinders);
        this.customModules = Sets.newHashSet(that.customModules);
    }

    public ResourceConfig addClasses(Set<Class<?>> classes) {
        this.invalidateProviderCache();
        this.classes.addAll(classes);
        return this;
    }

    public final ResourceConfig addClasses(Class<?> ... classes) {
        return this.addClasses(Sets.newHashSet((Object[])classes));
    }

    public ResourceConfig addSingletons(Set<Object> singletons) {
        this.invalidateProviderCache();
        this.singletons.addAll(singletons);
        return this;
    }

    public final ResourceConfig addSingletons(Object ... singletons) {
        return this.addSingletons(Sets.newHashSet((Object[])singletons));
    }

    public final ResourceConfig addResources(ResourceClass ... resources) {
        return this.addResources(Sets.newHashSet((Object[])resources));
    }

    public ResourceConfig addResources(Set<ResourceClass> resources) {
        this.resources.addAll(resources);
        return this;
    }

    public ResourceConfig setProperty(String name, Object value) {
        if ("jersey.config.server.provider.classnames".equals(name)) {
            this.invalidateProviderCache();
        }
        this.properties.put(name, value);
        return this;
    }

    public ResourceConfig addProperties(Map<String, Object> properties) {
        if (properties.containsKey("jersey.config.server.provider.classnames")) {
            this.invalidateProviderCache();
        }
        this.properties.putAll(properties);
        return this;
    }

    public ResourceConfig addFinder(ResourceFinder resourceFinder) {
        this.invalidateProviderCache();
        this.resourceFinders.add(resourceFinder);
        return this;
    }

    public ResourceConfig addModules(Set<Module> modules) {
        this.customModules.addAll(modules);
        return this;
    }

    public final ResourceConfig addModules(Module ... modules) {
        return this.addModules(Sets.newHashSet((Object[])modules));
    }

    public ResourceConfig setClassLoader(ClassLoader classLoader) {
        this.invalidateProviderCache();
        this.classLoader = classLoader;
        return this;
    }

    public final ResourceConfig packages(String ... packages) {
        return this.addFinder(new PackageNamesScanner(packages));
    }

    public final ResourceConfig files(String ... files) {
        return this.addFinder(new FilesScanner(files));
    }

    ResourceConfig setApplication(Application application) {
        this.invalidateProviderCache();
        this.application = application;
        this.applicationClass = null;
        ResourceConfig.mergeProperties(this.properties, application);
        return this;
    }

    private void invalidateProviderCache() {
        this.cachedClasses = null;
        this.cachedClassesView = null;
        this.cachedSingletons = null;
        this.cachedSingletonsView = null;
    }

    final Application getApplication() {
        return this.application != null ? this.application : this;
    }

    final Class<? extends Application> getApplicationClass() {
        return this.applicationClass;
    }

    final Set<Module> getCustomModules() {
        return this.customModules;
    }

    public final Set<Class<?>> getClasses() {
        if (this.cachedClassesView == null) {
            AnnotationAcceptingListener afl = AnnotationAcceptingListener.newJaxrsResourceAndProviderListener(this.classLoader);
            this.cachedClasses = new HashSet();
            this.cachedClassesView = Collections.unmodifiableSet(this.cachedClasses);
            for (ResourceFinder resourceFinder : this.resourceFinders) {
                while (resourceFinder.hasNext()) {
                    String next = (String)resourceFinder.next();
                    if (!afl.accept(next)) continue;
                    try {
                        afl.process(next, resourceFinder.open());
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Unable to process {0}", next);
                    }
                }
            }
            if (this.application != null) {
                this.cachedClasses.addAll(this.application.getClasses());
            }
            this.cachedClasses.addAll(afl.getAnnotatedClasses());
            this.cachedClasses.addAll(this.classes);
            Object o = this.properties.get("jersey.config.server.provider.classnames");
            if (o != null) {
                String[] classNames = null;
                if (o instanceof String) {
                    classNames = ResourceConfig.getElements((String)o, " ,;\n");
                } else if (o instanceof String[]) {
                    classNames = ResourceConfig.getElements((String[])o, " ,;\n");
                }
                if (classNames != null) {
                    for (String className : classNames) {
                        try {
                            this.cachedClasses.add(this.classLoader.loadClass(className));
                        }
                        catch (ClassNotFoundException e) {
                            LOGGER.log(Level.CONFIG, LocalizationMessages.UNABLE_TO_LOAD_CLASS(className));
                        }
                    }
                }
            }
        }
        return this.cachedClassesView;
    }

    public final Set<Object> getSingletons() {
        if (this.cachedSingletonsView == null) {
            this.cachedSingletons = new HashSet<Object>();
            this.cachedSingletonsView = Collections.unmodifiableSet(this.cachedSingletons);
            if (this.application != null) {
                this.cachedSingletons.addAll(this.application.getSingletons());
            }
            this.cachedSingletons.addAll(this.singletons);
        }
        return this.cachedSingletonsView;
    }

    public final Set<ResourceClass> getResources() {
        return this.resourcesView;
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public final Map<String, Object> getProperties() {
        return this.propertiesView;
    }

    public final Object getProperty(String name) {
        return this.properties.get(name);
    }

    public final boolean isProperty(String name) {
        if (this.properties.containsKey(name)) {
            Object value = this.properties.get(name);
            if (value instanceof Boolean) {
                return (Boolean)Boolean.class.cast(value);
            }
            return Boolean.parseBoolean(value.toString());
        }
        return false;
    }

    public static String[] getElements(String[] elements) {
        return ResourceConfig.getElements(elements, " ,;\n");
    }

    public static String[] getElements(String[] elements, String delimiters) {
        LinkedList<String> es = new LinkedList<String>();
        for (String element : elements) {
            if (element == null || (element = element.trim()).length() == 0) continue;
            for (String subElement : ResourceConfig.getElements(element, delimiters)) {
                if (subElement == null || subElement.length() == 0) continue;
                es.add(subElement);
            }
        }
        return es.toArray(new String[es.size()]);
    }

    public static String[] getElements(String elements, String delimiters) {
        String regex = "[";
        for (char c : delimiters.toCharArray()) {
            regex = regex + Pattern.quote(String.valueOf(c));
        }
        regex = regex + "]";
        String[] es = elements.split(regex);
        for (int i = 0; i < es.length; ++i) {
            es[i] = es[i].trim();
        }
        return es;
    }

    private static void mergeProperties(Map<String, Object> properties, Application application) {
        if (application instanceof PropertiesProvider) {
            properties.putAll(((PropertiesProvider)application).getProperties());
        }
    }
}

