/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import com.google.common.collect.Iterators;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Tuples;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.Requests;
import org.glassfish.jersey.message.internal.Responses;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.process.internal.TreeAcceptor;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.routing.CombinedClientServerMediaType;
import org.glassfish.jersey.server.internal.routing.RouterModule;
import org.glassfish.jersey.server.model.AbstractResourceMethod;
import org.glassfish.jersey.server.model.InvocableResourceMethod;
import org.glassfish.jersey.server.model.Parameter;

final class MultipleMethodAcceptor
implements TreeAcceptor {
    private static final Logger LOGGER = Logger.getLogger(MultipleMethodAcceptor.class.getName());
    final Map<String, List<ConsumesProducesInflector>> method2InflectorMap;
    final MessageBodyWorkers workers;
    final Injector injector;
    final TreeAcceptor acceptor;

    MultipleMethodAcceptor(Injector injector, MessageBodyWorkers msgWorkers, List<Pair<AbstractResourceMethod, Inflector<Request, Response>>> method2InflectorList) {
        this.injector = injector;
        this.workers = msgWorkers;
        this.method2InflectorMap = new HashMap<String, List<ConsumesProducesInflector>>();
        for (Pair<AbstractResourceMethod, Inflector<Request, Response>> methodInflector : method2InflectorList) {
            String httpMethod = ((AbstractResourceMethod)methodInflector.left()).getHttpMethod();
            if (!this.method2InflectorMap.containsKey(httpMethod)) {
                this.method2InflectorMap.put(httpMethod, new LinkedList());
            }
            this.addAllConsumesProducesCombinations(this.method2InflectorMap.get(httpMethod), methodInflector);
        }
        this.acceptor = !this.method2InflectorMap.containsKey("HEAD") ? this.createHeadEnrichedAcceptor() : this.createInternalAcceptor();
        if (!this.method2InflectorMap.containsKey("OPTIONS")) {
            this.addOptionsSupport();
        }
    }

    public Pair<Request, Iterator<TreeAcceptor>> apply(Request request) {
        return this.acceptor.apply(request);
    }

    private void addAllConsumesProducesCombinations(List<ConsumesProducesInflector> list, Pair<AbstractResourceMethod, Inflector<Request, Response>> methodInflector) {
        InvocableResourceMethod invocableMethod;
        LinkedList<MediaType> effectiveInputTypes = new LinkedList<MediaType>();
        LinkedList<MediaType> effectiveOutputTypes = new LinkedList<MediaType>();
        AbstractResourceMethod resourceMethod = (AbstractResourceMethod)methodInflector.left();
        effectiveInputTypes.addAll(resourceMethod.getSupportedInputTypes());
        if (effectiveInputTypes.isEmpty() && this.workers != null && resourceMethod instanceof InvocableResourceMethod) {
            invocableMethod = (InvocableResourceMethod)((Object)resourceMethod);
            for (Parameter p : invocableMethod.getParameters()) {
                if (p.getSource() != Parameter.Source.ENTITY) continue;
                Type paramType = p.getParameterType();
                Class<?> paramClass = p.getParameterClass();
                effectiveInputTypes.addAll(this.workers.getMessageBodyReaderMediaTypes(paramClass, paramType, p.getDeclaredAnnotations()));
            }
        }
        if (effectiveInputTypes.isEmpty()) {
            effectiveInputTypes.add(MediaType.valueOf((String)"*/*"));
        }
        effectiveOutputTypes.addAll(resourceMethod.getSupportedOutputTypes());
        if (effectiveOutputTypes.isEmpty() && this.workers != null && resourceMethod instanceof InvocableResourceMethod) {
            invocableMethod = (InvocableResourceMethod)((Object)resourceMethod);
            Type returnType = invocableMethod.getGenericReturnType();
            Class<?> returnClass = invocableMethod.getReturnType();
            effectiveOutputTypes.addAll(this.workers.getMessageBodyWriterMediaTypes(returnClass, returnType, invocableMethod.getMethod().getDeclaredAnnotations()));
        }
        if (effectiveOutputTypes.isEmpty()) {
            effectiveOutputTypes.add(MediaType.valueOf((String)"*/*"));
        }
        for (MediaType consumes : effectiveInputTypes) {
            for (MediaType produces : effectiveOutputTypes) {
                list.add(new ConsumesProducesInflector(consumes, produces, (Inflector<Request, Response>)((Inflector)methodInflector.right())));
            }
        }
    }

    private void addOptionsSupport() {
        HashSet<String> allowedMethods = new HashSet<String>(this.method2InflectorMap.keySet());
        allowedMethods.add("HEAD");
        allowedMethods.add("OPTIONS");
        LinkedList<ConsumesProducesInflector> optionsInflectors = new LinkedList<ConsumesProducesInflector>();
        optionsInflectors.add(this.createPlainTextOptionsInflector(allowedMethods));
        optionsInflectors.add(this.createGenericOptionsInflector(allowedMethods));
        this.method2InflectorMap.put("OPTIONS", optionsInflectors);
    }

    private Inflector<Request, Response> getInflector(Request request) {
        List acceptableMediaTypes;
        List<ConsumesProducesInflector> inflectors = this.method2InflectorMap.get(request.getMethod());
        if (inflectors == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).allow(this.method2InflectorMap.keySet()).build());
        }
        LinkedList<ConsumesProducesInflector> satisfyingInflectors = new LinkedList<ConsumesProducesInflector>();
        for (ConsumesProducesInflector cpi : inflectors) {
            if (!cpi.isConsumable(request)) continue;
            satisfyingInflectors.add(cpi);
        }
        if (satisfyingInflectors.isEmpty()) {
            throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
        }
        try {
            acceptableMediaTypes = request.getHeaders().getAcceptableMediaTypes();
        }
        catch (RuntimeException re) {
            throw new WebApplicationException(Response.status((int)400).entity((Object)re.getMessage()).build());
        }
        MethodSelector methodSelector = new MethodSelector(null);
        for (MediaType acceptableMediaType : acceptableMediaTypes) {
            for (ConsumesProducesInflector satisfiable : satisfyingInflectors) {
                if (!satisfiable.produces.isCompatible(acceptableMediaType)) continue;
                MediaType requestContentType = request.getHeaders().getMediaType();
                MediaType effectiveContentType = requestContentType == null ? MediaType.WILDCARD_TYPE : requestContentType;
                RequestSpecificConsumesProducesInflector candidate = new RequestSpecificConsumesProducesInflector(CombinedClientServerMediaType.create(effectiveContentType, satisfiable.consumes), CombinedClientServerMediaType.create(acceptableMediaType, satisfiable.produces), satisfiable.inflector);
                methodSelector.consider(candidate);
            }
        }
        if (methodSelector.selected != null) {
            RequestSpecificConsumesProducesInflector selected = methodSelector.selected;
            if (methodSelector.sameFitnessInflectors != null) {
                this.reportMethodSelectionAmbiguity(acceptableMediaTypes, selected, methodSelector.sameFitnessInflectors);
            }
            final MediaType effectiveResponseType = selected.produces.combinedMediaType;
            ((RouterModule.RoutingContext)this.injector.inject(RouterModule.RoutingContext.class)).setEffectiveAcceptableType(effectiveResponseType);
            final Inflector<Request, Response> inflector = selected.inflector;
            return new Inflector<Request, Response>(){

                public Response apply(Request request) {
                    MultipleMethodAcceptor.this.injector.inject((Object)inflector);
                    return MultipleMethodAcceptor.this.typeNotSpecific(effectiveResponseType) ? (Response)inflector.apply((Object)request) : MultipleMethodAcceptor.this.responseWithContentTypeHeader(effectiveResponseType, request, (Response)inflector.apply((Object)request));
                }
            };
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build());
    }

    private void reportMethodSelectionAmbiguity(List<MediaType> acceptableTypes, RequestSpecificConsumesProducesInflector selected, List<RequestSpecificConsumesProducesInflector> sameFitnessInflectors) {
        if (LOGGER.isLoggable(Level.WARNING)) {
            StringBuilder msgBuilder = new StringBuilder(LocalizationMessages.AMBIGUOUS_RESOURCE_METHOD(acceptableTypes)).append('\n');
            msgBuilder.append('\t').append(selected.inflector).append('\n');
            HashSet<Inflector<Request, Response>> reportedInflectors = new HashSet<Inflector<Request, Response>>();
            reportedInflectors.add(selected.inflector);
            for (RequestSpecificConsumesProducesInflector i : sameFitnessInflectors) {
                if (!reportedInflectors.contains(i.inflector)) {
                    msgBuilder.append('\t').append(i.inflector).append('\n');
                }
                reportedInflectors.add(i.inflector);
            }
            LOGGER.log(Level.WARNING, msgBuilder.toString());
        }
    }

    private Response responseWithContentTypeHeader(MediaType mt, Request request, Response response) {
        boolean contentTypeAlreadySet = response.getMetadata().containsKey((Object)"Content-Type");
        return !request.getMethod().equals("HEAD") && (!response.hasEntity() || contentTypeAlreadySet) ? response : Responses.toBuilder((Response)response).header("Content-Type", (Object)mt).build();
    }

    private boolean typeNotSpecific(MediaType effectiveResponseType) {
        return effectiveResponseType.isWildcardType() || effectiveResponseType.isWildcardSubtype();
    }

    private Response stripEntity(Response originalResponse) {
        if (originalResponse.hasEntity()) {
            Response.ResponseBuilder result = Response.status((int)originalResponse.getStatus());
            Responses.fillHeaders((Response.ResponseBuilder)result, (Map)originalResponse.getHeaders().asMap());
            return result.build();
        }
        return originalResponse;
    }

    private TreeAcceptor createInternalAcceptor() {
        return new TreeAcceptor(){

            public Pair<Request, Iterator<TreeAcceptor>> apply(Request request) {
                return MultipleMethodAcceptor.this.wrapWithRequestToAcceptorIterator(request, (Inflector<Request, Response>)MultipleMethodAcceptor.this.getInflector(request));
            }
        };
    }

    private TreeAcceptor createHeadEnrichedAcceptor() {
        return new TreeAcceptor(){

            public Pair<Request, Iterator<TreeAcceptor>> apply(Request request) {
                if ("HEAD".equals(request.getMethod())) {
                    return MultipleMethodAcceptor.this.wrapWithRequestToAcceptorIterator(request, (Inflector<Request, Response>)((Inflector)new Inflector<Request, Response>(){

                        public Response apply(Request data) {
                            Request getRequest = Requests.from((Request)data).method("GET").build();
                            return MultipleMethodAcceptor.this.stripEntity((Response)MultipleMethodAcceptor.this.getInflector(getRequest).apply((Object)getRequest));
                        }
                    }));
                }
                return MultipleMethodAcceptor.this.wrapWithRequestToAcceptorIterator(request, (Inflector<Request, Response>)MultipleMethodAcceptor.this.getInflector(request));
            }
        };
    }

    private ConsumesProducesInflector createPlainTextOptionsInflector(final Set<String> allowedMethods) {
        String allowedList = allowedMethods.toString();
        final String optionsBody = allowedList.substring(1, allowedList.length() - 1);
        return new ConsumesProducesInflector(MediaType.WILDCARD_TYPE, MediaType.TEXT_PLAIN_TYPE, new Inflector<Request, Response>(){

            public Response apply(Request data) {
                return Response.ok((Object)optionsBody, (MediaType)MediaType.TEXT_PLAIN_TYPE).allow(allowedMethods).build();
            }
        });
    }

    private ConsumesProducesInflector createGenericOptionsInflector(final Set<String> allowedMethods) {
        return new ConsumesProducesInflector(MediaType.WILDCARD_TYPE, MediaType.WILDCARD_TYPE, new Inflector<Request, Response>(){

            public Response apply(Request data) {
                return Response.ok().header("Content-Length", (Object)"0").type((MediaType)data.getHeaders().getAcceptableMediaTypes().get(0)).allow(allowedMethods).build();
            }
        });
    }

    private Pair<Request, Iterator<TreeAcceptor>> wrapWithRequestToAcceptorIterator(Request request, Inflector<Request, Response> inflector) {
        return Tuples.of((Object)request, (Object)Iterators.singletonIterator((Object)Stages.asTreeAcceptor(inflector)));
    }

    class MethodSelector {
        RequestSpecificConsumesProducesInflector selected;
        List<RequestSpecificConsumesProducesInflector> sameFitnessInflectors;

        MethodSelector(RequestSpecificConsumesProducesInflector i) {
            this.selected = i;
            this.sameFitnessInflectors = null;
        }

        void consider(RequestSpecificConsumesProducesInflector i) {
            int theGreaterTheBetter = i.compareTo(this.selected);
            if (theGreaterTheBetter > 0) {
                this.selected = i;
                this.sameFitnessInflectors = null;
            } else if (theGreaterTheBetter == 0 && this.selected.inflector != i.inflector) {
                this.getSameFitnessList().add(i);
            }
        }

        List<RequestSpecificConsumesProducesInflector> getSameFitnessList() {
            if (this.sameFitnessInflectors == null) {
                this.sameFitnessInflectors = new LinkedList<RequestSpecificConsumesProducesInflector>();
            }
            return this.sameFitnessInflectors;
        }
    }

    class RequestSpecificConsumesProducesInflector
    implements Comparable {
        CombinedClientServerMediaType consumes;
        CombinedClientServerMediaType produces;
        Inflector<Request, Response> inflector;

        RequestSpecificConsumesProducesInflector(CombinedClientServerMediaType consumes, CombinedClientServerMediaType produces, Inflector<Request, Response> inflector) {
            this.inflector = inflector;
            this.consumes = consumes;
            this.produces = produces;
        }

        public String toString() {
            return String.format("%s->%s:%s", this.consumes, this.produces, this.inflector);
        }

        public int compareTo(Object o) {
            if (o == null) {
                return 1;
            }
            if (!(o instanceof RequestSpecificConsumesProducesInflector)) {
                return 1;
            }
            RequestSpecificConsumesProducesInflector other = (RequestSpecificConsumesProducesInflector)o;
            int consumedComparism = CombinedClientServerMediaType.COMPARATOR.compare(this.consumes, other.consumes);
            return consumedComparism != 0 ? consumedComparism : CombinedClientServerMediaType.COMPARATOR.compare(this.produces, other.produces);
        }
    }

    class ConsumesProducesInflector {
        MediaType consumes;
        MediaType produces;
        Inflector<Request, Response> inflector;

        ConsumesProducesInflector(MediaType consumes, MediaType produces, Inflector<Request, Response> inflector) {
            this.inflector = inflector;
            this.consumes = consumes;
            this.produces = produces;
        }

        boolean isConsumable(Request request) {
            MediaType contentType = request.getHeaders().getMediaType();
            return contentType == null || this.consumes.isCompatible(contentType);
        }

        public String toString() {
            return String.format("%s->%s:%s", this.consumes, this.produces, this.inflector);
        }
    }
}

