/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.internal.MappableException;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.process.internal.TreeAcceptor;
import org.glassfish.jersey.server.internal.routing.RouterModule;
import org.glassfish.jersey.server.internal.routing.RuntimeModelFromSubResource;
import org.glassfish.jersey.server.model.IntrospectionModeller;
import org.glassfish.jersey.server.model.ResourceClass;
import org.glassfish.jersey.server.model.SubResourceLocator;
import org.glassfish.jersey.server.spi.internal.MethodParameterHelper;

public class SubResourceLocatorAcceptor
implements TreeAcceptor {
    Services services;
    SubResourceLocator locator;
    final List<Factory<?>> valueProviders;
    Injector injector;
    MessageBodyWorkers workers;

    public SubResourceLocatorAcceptor(Injector injector, Services services, MessageBodyWorkers workers, SubResourceLocator locator) {
        this.injector = injector;
        this.locator = locator;
        this.workers = workers;
        this.services = services;
        this.valueProviders = MethodParameterHelper.createValueProviders(services, locator);
    }

    public Pair<Request, Iterator<TreeAcceptor>> apply(Request data) {
        RouterModule.RoutingContext routingCtx = (RouterModule.RoutingContext)this.injector.inject(RouterModule.RoutingContext.class);
        Object subResource = this.getResource(routingCtx);
        if (subResource == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (subResource.getClass().isAssignableFrom(Class.class)) {
            subResource = this.services.forContract((Class)subResource).get();
        }
        RuntimeModelFromSubResource rmBuilder = new RuntimeModelFromSubResource(this.workers);
        this.injector.inject((Object)rmBuilder);
        routingCtx.pushMatchedResource(subResource);
        ResourceClass resourceClass = IntrospectionModeller.createResource(subResource);
        rmBuilder.process(resourceClass);
        return rmBuilder.getRuntimeModel().apply(data);
    }

    private Object getResource(RouterModule.RoutingContext routingCtx) {
        Object resource = routingCtx.peekMatchedResource();
        try {
            return this.locator.getMethod().invoke(resource, MethodParameterHelper.getParameterValues(this.valueProviders));
        }
        catch (IllegalAccessException ex) {
            throw new ProcessingException("Resource Java method invocation error.", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ProcessingException) {
                throw (ProcessingException)cause;
            }
            throw new MappableException(cause);
        }
        catch (UndeclaredThrowableException ex) {
            throw new ProcessingException("Resource Java method invocation error.", (Throwable)ex);
        }
        catch (ProcessingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MappableException((Throwable)ex);
        }
        catch (Throwable t) {
            throw new ProcessingException(t);
        }
    }
}

