/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Services;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.server.model.AbstractJavaResourceMethodDispatcher;
import org.glassfish.jersey.server.model.InvocableResourceMethod;
import org.glassfish.jersey.server.spi.internal.MethodParameterHelper;
import org.glassfish.jersey.server.spi.internal.ResourceMethodDispatcher;
import org.jvnet.hk2.annotations.Inject;

abstract class AbstractJavaResourceMethodDispatcherProvider
implements ResourceMethodDispatcher.Provider {
    @Inject
    private Services services;

    AbstractJavaResourceMethodDispatcherProvider() {
    }

    @Override
    public ResourceMethodDispatcher create(InvocableResourceMethod resourceMethod, InvocationHandler invocationHandler) {
        List<Factory<?>> valueProviders = this.createValueProviders(resourceMethod);
        if (valueProviders == null) {
            return null;
        }
        if (valueProviders.contains(null)) {
            return null;
        }
        Class<?> returnType = resourceMethod.getMethod().getReturnType();
        if (Response.class.isAssignableFrom(returnType)) {
            return new ResponseOutInvoker(resourceMethod, invocationHandler, valueProviders);
        }
        if (returnType != Void.TYPE) {
            if (returnType == Object.class || GenericEntity.class.isAssignableFrom(returnType)) {
                return new ObjectOutInvoker(resourceMethod, invocationHandler, valueProviders);
            }
            return new TypeOutInvoker(resourceMethod, invocationHandler, valueProviders);
        }
        return new VoidOutInvoker(resourceMethod, invocationHandler, valueProviders);
    }

    protected final Services getServices() {
        return this.services;
    }

    protected abstract List<Factory<?>> createValueProviders(InvocableResourceMethod var1);

    private static final class TypeOutInvoker
    extends AbstractMethodParamInvoker {
        private final Type t;

        public TypeOutInvoker(InvocableResourceMethod resourceMethod, InvocationHandler handler, List<Factory<?>> valueProviders) {
            super(resourceMethod, handler, valueProviders);
            this.t = resourceMethod.getMethod().getGenericReturnType();
        }

        @Override
        protected Response doDispatch(Object resource, Request request) throws ProcessingException {
            Object o = this.invoke(resource, this.getParamValues());
            if (o != null) {
                Response response = Response.ok().entity(o).build();
                return response;
            }
            return Response.noContent().build();
        }
    }

    private static final class ObjectOutInvoker
    extends AbstractMethodParamInvoker {
        public ObjectOutInvoker(InvocableResourceMethod resourceMethod, InvocationHandler handler, List<Factory<?>> valueProviders) {
            super(resourceMethod, handler, valueProviders);
        }

        @Override
        protected Response doDispatch(Object resource, Request request) throws ProcessingException {
            Object o = this.invoke(resource, this.getParamValues());
            if (o instanceof Response) {
                return (Response)Response.class.cast(o);
            }
            if (o != null) {
                return Response.ok().entity(o).build();
            }
            return Response.noContent().build();
        }
    }

    private static final class ResponseOutInvoker
    extends AbstractMethodParamInvoker {
        public ResponseOutInvoker(InvocableResourceMethod resourceMethod, InvocationHandler handler, List<Factory<?>> valueProviders) {
            super(resourceMethod, handler, valueProviders);
        }

        @Override
        protected Response doDispatch(Object resource, Request request) throws ProcessingException {
            return (Response)Response.class.cast(this.invoke(resource, this.getParamValues()));
        }
    }

    private static final class VoidOutInvoker
    extends AbstractMethodParamInvoker {
        public VoidOutInvoker(InvocableResourceMethod resourceMethod, InvocationHandler handler, List<Factory<?>> valueProviders) {
            super(resourceMethod, handler, valueProviders);
        }

        @Override
        protected Response doDispatch(Object resource, Request request) throws ProcessingException {
            this.invoke(resource, this.getParamValues());
            return Response.noContent().build();
        }
    }

    private static abstract class AbstractMethodParamInvoker
    extends AbstractJavaResourceMethodDispatcher {
        private final List<Factory<?>> valueProviders;

        public AbstractMethodParamInvoker(InvocableResourceMethod resourceMethod, InvocationHandler handler, List<Factory<?>> valueProviders) {
            super(resourceMethod, handler);
            this.valueProviders = valueProviders;
        }

        protected final Object[] getParamValues() {
            return MethodParameterHelper.getParameterValues(this.valueProviders);
        }
    }
}

