/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.CookieParam;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.internal.util.AnnotatedMethod;
import org.glassfish.jersey.internal.util.MethodList;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.model.AbstractResourceMethod;
import org.glassfish.jersey.server.model.AbstractSubResourceMethod;
import org.glassfish.jersey.server.model.InflectorBasedResourceMethod;
import org.glassfish.jersey.server.model.IntrospectionModeller;
import org.glassfish.jersey.server.model.InvocableResourceMethod;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.Parameterized;
import org.glassfish.jersey.server.model.PathAnnotated;
import org.glassfish.jersey.server.model.ResourceClass;
import org.glassfish.jersey.server.model.ResourceConstructor;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModelIssue;
import org.glassfish.jersey.server.model.ResourceModelValidator;
import org.glassfish.jersey.server.model.SubResourceLocator;
import org.glassfish.jersey.server.model.SubResourceMethod;
import org.glassfish.jersey.uri.UriTemplate;

public class BasicValidator
extends ResourceModelValidator {
    private MessageBodyWorkers workers;
    private static final Set<Class> ParamAnnotationSET = BasicValidator.createParamAnnotationSet();
    private static final List<MediaType> StarTypeList = Arrays.asList(new MediaType("*", "*"));

    public BasicValidator() {
    }

    public BasicValidator(MessageBodyWorkers workers) {
        this.workers = workers;
    }

    @Override
    public void visitResourceClass(ResourceClass resource) {
        if (resource.isRootResource() && (null == resource.getPath() || null == resource.getPath().getValue())) {
            this.issueList.add(new ResourceModelIssue(resource, LocalizationMessages.RES_URI_PATH_INVALID(resource.getResourceClass(), resource.getPath()), true));
        }
        this.checkNonPublicMethods(resource);
        Class<?> resourceClass = resource.getResourceClass();
        if (resourceClass != null) {
            this.checkResourceClassSetters(resourceClass);
            this.checkResourceClassFields(resourceClass);
        }
        this.checkConsumesProducesAmbiguities(resource);
        this.checkSRLAmbiguities(resource);
    }

    private void checkResourceClassSetters(Class<?> rc) {
        MethodList methodList = new MethodList(rc);
        for (AnnotatedMethod m : methodList.hasNotMetaAnnotation(HttpMethod.class).hasNotAnnotation(Path.class).hasNumParams(1).hasReturnType(Void.TYPE).nameStartsWith("set")) {
            Parameter p = IntrospectionModeller.createParameter(rc, m.getMethod().getDeclaringClass(), rc.isAnnotationPresent(Encoded.class), m.getParameterTypes()[0], m.getGenericParameterTypes()[0], m.getAnnotations());
            if (null == p) continue;
            this.checkParameter(p, m.getMethod(), m.getMethod().toGenericString(), "1");
        }
    }

    @Override
    public void visitResourceConstructor(ResourceConstructor constructor) {
    }

    private void checkResourceClassFields(Class<?> rc) {
        for (Field f : rc.getDeclaredFields()) {
            Parameter p;
            if (f.getDeclaredAnnotations().length <= 0 || null == (p = IntrospectionModeller.createParameter(rc, f.getDeclaringClass(), rc.isAnnotationPresent(Encoded.class), f.getType(), f.getGenericType(), f.getAnnotations()))) continue;
            this.checkParameter(p, f, f.toGenericString(), f.getName());
        }
    }

    @Override
    public void visitResourceMethod(ResourceMethod method) {
        this.checkMethod(method);
    }

    public void checkMethod(AbstractResourceMethod method) {
        Type t;
        boolean isInvocable = method instanceof InvocableResourceMethod;
        if (!isInvocable) {
            return;
        }
        InvocableResourceMethod invocable = (InvocableResourceMethod)((Object)method);
        this.checkParameters(invocable, invocable.getMethod());
        if ("GET".equals(method.getHttpMethod())) {
            if (Void.TYPE == invocable.getMethod().getReturnType() && !invocable.isSuspendDeclared()) {
                this.issueList.add(new ResourceModelIssue(method, LocalizationMessages.GET_RETURNS_VOID(invocable.getMethod()), false));
            }
            if (invocable.hasEntity()) {
                this.issueList.add(new ResourceModelIssue(method, LocalizationMessages.GET_CONSUMES_ENTITY(invocable.getMethod()), false));
            }
            for (Parameter p : invocable.getParameters()) {
                if (!p.isAnnotationPresent(FormParam.class)) continue;
                this.issueList.add(new ResourceModelIssue(method, LocalizationMessages.GET_CONSUMES_FORM_PARAM(invocable.getMethod()), true));
                break;
            }
        }
        LinkedList<String> httpAnnotList = new LinkedList<String>();
        for (Annotation a : invocable.getMethod().getDeclaredAnnotations()) {
            if (null != a.annotationType().getAnnotation(HttpMethod.class)) {
                httpAnnotList.add(((Object)a).toString());
                continue;
            }
            if (a.annotationType() != Path.class || method instanceof AbstractSubResourceMethod) continue;
            this.issueList.add(new ResourceModelIssue(method, LocalizationMessages.SUB_RES_METHOD_TREATED_AS_RES_METHOD(invocable.getMethod(), ((Path)a).value()), false));
        }
        if (httpAnnotList.size() > 1) {
            this.issueList.add(new ResourceModelIssue(method, LocalizationMessages.MULTIPLE_HTTP_METHOD_DESIGNATORS(invocable.getMethod(), ((Object)httpAnnotList).toString()), true));
        }
        if (!this.isConcreteType(t = invocable.getGenericReturnType())) {
            this.issueList.add(new ResourceModelIssue(invocable.getMethod(), LocalizationMessages.TYPE_OF_METHOD_NOT_RESOLVABLE_TO_CONCRETE_TYPE(t, invocable.getMethod().toGenericString()), false));
        }
    }

    @Override
    public void visitSubResourceMethod(SubResourceMethod method) {
        this.checkMethod(method);
        if (null == method.getPath() || null == method.getPath().getValue() || method.getPath().getValue().length() == 0) {
            this.issueList.add(new ResourceModelIssue(method, LocalizationMessages.SUBRES_METHOD_URI_PATH_INVALID(method.getMethod(), method.getPath()), true));
        }
    }

    @Override
    public void visitSubResourceLocator(SubResourceLocator locator) {
        this.checkParameters(locator, locator.getMethod());
        if (Void.TYPE == locator.getMethod().getReturnType()) {
            this.issueList.add(new ResourceModelIssue(locator, LocalizationMessages.SUBRES_LOC_RETURNS_VOID(locator.getMethod()), true));
        }
        if (null == locator.getPath() || null == locator.getPath().getValue() || locator.getPath().getValue().length() == 0) {
            this.issueList.add(new ResourceModelIssue(locator, LocalizationMessages.SUBRES_LOC_URI_PATH_INVALID(locator.getMethod(), locator.getPath()), true));
        }
        for (Parameter parameter : locator.getParameters()) {
            if (Parameter.Source.ENTITY != parameter.getSource()) continue;
            this.issueList.add(new ResourceModelIssue(locator, LocalizationMessages.SUBRES_LOC_HAS_ENTITY_PARAM(locator.getMethod()), true));
        }
    }

    private static Set<Class> createParamAnnotationSet() {
        HashSet<Class> set = new HashSet<Class>(6);
        set.add(Context.class);
        set.add(HeaderParam.class);
        set.add(CookieParam.class);
        set.add(MatrixParam.class);
        set.add(QueryParam.class);
        set.add(PathParam.class);
        return Collections.unmodifiableSet(set);
    }

    private void checkParameter(Parameter p, Object source, String nameForLogging, String paramNameForLogging) {
        Annotation[] annotations;
        int annotCount = 0;
        Type t = p.getParameterType();
        for (Annotation a : annotations = p.getAnnotations()) {
            if (!ParamAnnotationSET.contains(a.annotationType()) || ++annotCount <= 1) continue;
            this.issueList.add(new ResourceModelIssue(source, LocalizationMessages.AMBIGUOUS_PARAMETER(nameForLogging, paramNameForLogging), false));
            break;
        }
        if (!this.isConcreteType(t)) {
            this.issueList.add(new ResourceModelIssue(source, "Parameter " + paramNameForLogging + " of type " + t + " from " + nameForLogging + " is not resolvable to a concrete type", false));
        }
    }

    private boolean isConcreteType(Type t) {
        if (t instanceof ParameterizedType) {
            return this.isConcreteParameterizedType((ParameterizedType)t);
        }
        return t instanceof Class;
    }

    private boolean isConcreteParameterizedType(ParameterizedType pt) {
        boolean isConcrete = true;
        for (Type t : pt.getActualTypeArguments()) {
            isConcrete &= this.isConcreteType(t);
        }
        return isConcrete;
    }

    private void checkParameters(Parameterized pl, Method m) {
        int paramCount = 0;
        for (Parameter p : pl.getParameters()) {
            this.checkParameter(p, m, m.toGenericString(), Integer.toString(++paramCount));
        }
    }

    private List<Method> getDeclaredMethods(final Class _c) {
        final ArrayList<Method> ml = new ArrayList<Method>();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){
            Class c;
            {
                this.c = _c;
            }

            @Override
            public Object run() {
                while (this.c != Object.class && this.c != null) {
                    ml.addAll(Arrays.asList(this.c.getDeclaredMethods()));
                    this.c = this.c.getSuperclass();
                }
                return null;
            }
        });
        return ml;
    }

    private void checkNonPublicMethods(ResourceClass ar) {
        Class<?> resourceClass = ar.getResourceClass();
        if (resourceClass == null) {
            return;
        }
        MethodList declaredMethods = new MethodList(this.getDeclaredMethods(resourceClass));
        for (AnnotatedMethod m : declaredMethods.hasMetaAnnotation(HttpMethod.class).hasNotAnnotation(Path.class).isNotPublic()) {
            this.issueList.add(new ResourceModelIssue(ar, LocalizationMessages.NON_PUB_RES_METHOD(m.getMethod().toGenericString()), false));
        }
        for (AnnotatedMethod m : declaredMethods.hasMetaAnnotation(HttpMethod.class).hasAnnotation(Path.class).isNotPublic()) {
            this.issueList.add(new ResourceModelIssue(ar, LocalizationMessages.NON_PUB_SUB_RES_METHOD(m.getMethod().toGenericString()), false));
        }
        for (AnnotatedMethod m : declaredMethods.hasNotMetaAnnotation(HttpMethod.class).hasAnnotation(Path.class).isNotPublic()) {
            this.issueList.add(new ResourceModelIssue(ar, LocalizationMessages.NON_PUB_SUB_RES_LOC(m.getMethod().toGenericString()), false));
        }
    }

    @Override
    public void visitInflectorResourceMethod(InflectorBasedResourceMethod method) {
    }

    private void checkConsumesProducesAmbiguities(ResourceClass resource) {
        List<SubResourceMethod> subResourceMethods;
        List<AbstractResourceMethod> resourceMethods = resource.getResourceMethods();
        if (resourceMethods.size() >= 2) {
            for (AbstractResourceMethod m1 : resourceMethods.subList(0, resourceMethods.size() - 1)) {
                for (AbstractResourceMethod m2 : resourceMethods.subList(resourceMethods.indexOf(m1) + 1, resourceMethods.size())) {
                    boolean bothAreRealJavaMethods;
                    boolean bl = bothAreRealJavaMethods = m1 instanceof InvocableResourceMethod && m2 instanceof InvocableResourceMethod;
                    if (!this.sameHttpMethod(m1, m2) || !bothAreRealJavaMethods) continue;
                    this.checkIntersectingMediaTypes(resource, m1.getHttpMethod(), (InvocableResourceMethod)((Object)m1), (InvocableResourceMethod)((Object)m2), this.issueList);
                }
            }
        }
        if ((subResourceMethods = resource.getSubResourceMethods()).size() >= 2) {
            for (SubResourceMethod m1 : subResourceMethods.subList(0, subResourceMethods.size() - 1)) {
                for (SubResourceMethod m2 : subResourceMethods.subList(subResourceMethods.indexOf(m1) + 1, subResourceMethods.size())) {
                    boolean bothAreRealJavaMethods;
                    boolean bl = bothAreRealJavaMethods = m1 instanceof InvocableResourceMethod && m2 instanceof InvocableResourceMethod;
                    if (!this.samePath(m1, m2) || !this.sameHttpMethod(m1, m2) || !bothAreRealJavaMethods) continue;
                    this.checkIntersectingMediaTypes(resource, m1.getHttpMethod(), m1, m2, this.issueList);
                }
            }
        }
    }

    private void checkSRLAmbiguities(ResourceClass resource) {
        List<SubResourceLocator> subResourceLocators = resource.getSubResourceLocators();
        if (subResourceLocators.size() >= 2) {
            for (SubResourceLocator m1 : subResourceLocators.subList(0, subResourceLocators.size() - 1)) {
                for (SubResourceLocator m2 : subResourceLocators.subList(subResourceLocators.indexOf(m1) + 1, subResourceLocators.size())) {
                    if (!this.samePath(m1, m2)) continue;
                    this.issueList.add(new ResourceModelIssue(resource, LocalizationMessages.AMBIGUOUS_SRLS(resource.getResourceClass().getName(), m1.getPath(), m2.getPath()), true));
                }
            }
        }
    }

    private void checkIntersectingMediaTypes(ResourceClass resource, String httpMethod, InvocableResourceMethod im1, InvocableResourceMethod im2, List<ResourceModelIssue> issueList) {
        List<MediaType> outputTypes2;
        List<MediaType> outputTypes1;
        List<MediaType> inputTypes2;
        List<MediaType> inputTypes1 = this.getEffectiveInputTypes(im1);
        if (this.intersectingMediaTypes(inputTypes1, inputTypes2 = this.getEffectiveInputTypes(im2), outputTypes1 = this.getEffectiveOutputTypes(im1), outputTypes2 = this.getEffectiveOutputTypes(im2))) {
            String rcName = resource.getResourceClass().getName();
            if (im1.hasEntity()) {
                issueList.add(new ResourceModelIssue(resource, LocalizationMessages.AMBIGUOUS_RMS_IN(rcName, httpMethod, im1.getMethod(), im2.getMethod()), true));
            } else {
                issueList.add(new ResourceModelIssue(resource, LocalizationMessages.AMBIGUOUS_RMS_OUT(rcName, httpMethod, im1.getMethod(), im2.getMethod()), true));
            }
        }
    }

    private List<MediaType> getEffectiveInputTypes(InvocableResourceMethod invocableMethod) {
        if (!invocableMethod.getSupportedInputTypes().isEmpty()) {
            return invocableMethod.getSupportedInputTypes();
        }
        LinkedList<MediaType> result = new LinkedList<MediaType>();
        if (this.workers != null) {
            for (Parameter p : invocableMethod.getParameters()) {
                if (p.getSource() != Parameter.Source.ENTITY) continue;
                Type paramType = p.getParameterType();
                Class<?> paramClass = p.getParameterClass();
                result.addAll(this.workers.getMessageBodyReaderMediaTypes(paramClass, paramType, p.getDeclaredAnnotations()));
            }
        }
        return result.isEmpty() ? StarTypeList : result;
    }

    private List<MediaType> getEffectiveOutputTypes(InvocableResourceMethod invocableMethod) {
        if (!invocableMethod.getSupportedOutputTypes().isEmpty()) {
            return invocableMethod.getSupportedOutputTypes();
        }
        LinkedList<MediaType> result = new LinkedList<MediaType>();
        if (this.workers != null) {
            result.addAll(this.workers.getMessageBodyWriterMediaTypes(invocableMethod.getReturnType(), invocableMethod.getGenericReturnType(), invocableMethod.getMethod().getDeclaredAnnotations()));
        }
        return result.isEmpty() ? StarTypeList : result;
    }

    private boolean sameHttpMethod(AbstractResourceMethod m1, AbstractResourceMethod m2) {
        return m1.getHttpMethod().equals(m2.getHttpMethod());
    }

    private boolean intersectingMediaTypes(List<MediaType> i1, List<MediaType> i2, List<MediaType> o1, List<MediaType> o2) {
        return MediaTypes.intersect(i1, i2) && MediaTypes.intersect(o1, o2);
    }

    private boolean samePath(PathAnnotated m1, PathAnnotated m2) {
        return new UriTemplate(m1.getPath().getValue()).equals((Object)new UriTemplate(m2.getPath().getValue()));
    }
}

