/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.hk2.BinderFactory;
import org.glassfish.hk2.ComponentException;
import org.glassfish.hk2.DynamicBinderFactory;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.HK2;
import org.glassfish.hk2.Module;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.hk2.scopes.Singleton;
import org.glassfish.jersey.FeaturesAndProperties;
import org.glassfish.jersey.internal.ContextResolverFactory;
import org.glassfish.jersey.internal.ExceptionMapperFactory;
import org.glassfish.jersey.internal.MappableException;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.ServiceProviders;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.internal.util.CommittingOutputStream;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.HeaderValueException;
import org.glassfish.jersey.message.internal.MessageBodyFactory;
import org.glassfish.jersey.message.internal.Requests;
import org.glassfish.jersey.message.internal.Responses;
import org.glassfish.jersey.process.internal.ChainableAcceptor;
import org.glassfish.jersey.process.internal.FilteringAcceptor;
import org.glassfish.jersey.process.internal.InflectorNotFoundException;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.InvocationContext;
import org.glassfish.jersey.process.internal.LinearAcceptor;
import org.glassfish.jersey.process.internal.LinearRequestProcessor;
import org.glassfish.jersey.process.internal.MessageBodyWorkersInitializer;
import org.glassfish.jersey.process.internal.RequestInvoker;
import org.glassfish.jersey.process.internal.RequestProcessor;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.process.internal.TreeAcceptor;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerResponseWriterCallback;
import org.glassfish.jersey.server.InflectorExtractingStage;
import org.glassfish.jersey.server.PreMatchRequestFilteringStage;
import org.glassfish.jersey.server.ReferencesInitializer;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ResourceMatchingStage;
import org.glassfish.jersey.server.ServerModule;
import org.glassfish.jersey.server.TimingOutInvocationCallback;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.routing.RouterModule;
import org.glassfish.jersey.server.internal.routing.RuntimeModelBuilder;
import org.glassfish.jersey.server.model.BasicValidator;
import org.glassfish.jersey.server.model.ModelValidationException;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceModelIssue;
import org.glassfish.jersey.server.model.ResourceModelValidator;
import org.glassfish.jersey.server.spi.ContainerRequestContext;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.server.spi.RequestScopedInitializer;
import org.glassfish.jersey.spi.CloseableService;
import org.glassfish.jersey.spi.ContextResolvers;
import org.glassfish.jersey.spi.ExceptionMappers;
import org.jvnet.hk2.annotations.Inject;

public final class ApplicationHandler {
    private static final Logger LOGGER = Logger.getLogger(ApplicationHandler.class.getName());
    private static final SecurityContext DEFAULT_SECURITY_CONTEXT = new SecurityContext(){

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return false;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public String getAuthenticationScheme() {
            return null;
        }
    };
    @Inject
    private RequestScope requestScope;
    @Inject
    private Factory<RouterModule.RoutingContext> routingContextFactory;
    @Inject
    private Factory<Ref<SecurityContext>> securityContextRefFactory;
    @Inject
    private Factory<CloseableService> closeableServiceFactory;
    private Services services;
    private RequestInvoker invoker;
    private final ResourceConfig configuration;
    private References refs;

    public ApplicationHandler() {
        this.initServices();
        this.configuration = new ResourceConfig();
        this.initialize();
    }

    public ApplicationHandler(Class<? extends Application> jaxrsApplicationClass) {
        this.initServices();
        this.configuration = ResourceConfig.class.isAssignableFrom(jaxrsApplicationClass) ? (ResourceConfig)this.createApplication(jaxrsApplicationClass) : ResourceConfig.forApplicationClass(jaxrsApplicationClass);
        this.initialize();
    }

    public ApplicationHandler(Application application) {
        this.initServices();
        this.configuration = ResourceConfig.forApplication(application);
        this.initialize();
    }

    private void initServices() {
        this.services = HK2.get().create(null, new Module[]{new ServerModule(), new ApplicationModule()});
    }

    private void initialize() {
        this.registerAdditionalModules(this.configuration.getCustomModules());
        Class<? extends Application> applicationClass = this.configuration.getApplicationClass();
        if (applicationClass != null) {
            Application application = this.createApplication(applicationClass);
            if (application instanceof ResourceConfig) {
                this.registerAdditionalModules(((ResourceConfig)application).getCustomModules());
            }
            this.configuration.setApplication(application);
        }
        this.configuration.lock();
        LinkedList resourceModelIssues = Lists.newLinkedList();
        HashMap pathToResourceBuilderMap = Maps.newHashMap();
        LinkedList<Resource.Builder> resourcesBuilders = new LinkedList<Resource.Builder>();
        for (Class<?> c : this.configuration.getClasses()) {
            Path path = Resource.getPath(c);
            if (path == null) continue;
            try {
                String pathValue = path.value();
                Resource.Builder builder = Resource.builder(c, (List<ResourceModelIssue>)resourceModelIssues);
                Resource.Builder existing = (Resource.Builder)pathToResourceBuilderMap.get(pathValue);
                if (existing != null) {
                    existing.mergeWith(builder);
                    continue;
                }
                resourcesBuilders.add(builder);
                pathToResourceBuilderMap.put(pathValue, builder);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warning(ex.getMessage());
            }
        }
        for (Resource programmaticResource : this.configuration.getResources()) {
            Resource.Builder builder = (Resource.Builder)pathToResourceBuilderMap.get(programmaticResource.getPath());
            if (builder != null) {
                builder.mergeWith(programmaticResource);
                continue;
            }
            resourcesBuilders.add(Resource.builder(programmaticResource));
        }
        Injector injector = (Injector)this.services.forContract(Injector.class).get();
        this.refs = (References)injector.inject(References.class);
        ServiceProviders providers = ((ServiceProviders.Builder)this.services.forContract(ServiceProviders.Builder.class).get()).setProviderClasses(Sets.filter(this.configuration.getClasses(), (Predicate)new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                boolean acceptable = Resource.isAcceptable(input);
                if (!acceptable) {
                    LOGGER.warning(LocalizationMessages.NON_INSTANTIATABLE_CLASS(input));
                }
                return acceptable;
            }
        })).setProviderInstances(this.configuration.getSingletons()).build();
        this.refs.providers.set((Object)providers);
        MessageBodyFactory workers = new MessageBodyFactory(providers);
        this.refs.workers.set((Object)workers);
        this.refs.mappers.set((Object)new ExceptionMapperFactory(providers));
        this.refs.resolvers.set((Object)new ContextResolverFactory(providers));
        List<Resource> resources = this.buildAndValidate(resourcesBuilders, resourceModelIssues, (MessageBodyWorkers)workers);
        RuntimeModelBuilder runtimeModelBuilder = (RuntimeModelBuilder)this.services.byType(RuntimeModelBuilder.class).get();
        runtimeModelBuilder.setWorkers((MessageBodyWorkers)workers);
        for (Resource r : resources) {
            runtimeModelBuilder.process(r);
        }
        TreeAcceptor rootResourceMatchingAcceptor = runtimeModelBuilder.buildModel();
        PreMatchRequestFilteringStage preMatchRequestFilteringStage = (PreMatchRequestFilteringStage)((Object)injector.inject(PreMatchRequestFilteringStage.class));
        ResourceMatchingStage resourceMatchingStage = ((ResourceMatchingStage.Builder)injector.inject(ResourceMatchingStage.Builder.class)).build(rootResourceMatchingAcceptor);
        FilteringAcceptor resourceFilteringStage = (FilteringAcceptor)injector.inject(FilteringAcceptor.class);
        InflectorExtractingStage inflectorExtractingStage = (InflectorExtractingStage)injector.inject(InflectorExtractingStage.class);
        LinearAcceptor rootStageAcceptor = Stages.acceptingChain((Function)((Function)injector.inject(ReferencesInitializer.class))).to((Function)injector.inject(MessageBodyWorkersInitializer.class)).to((Function)preMatchRequestFilteringStage).to((Function)resourceMatchingStage).to((ChainableAcceptor)resourceFilteringStage).build((LinearAcceptor)inflectorExtractingStage);
        this.invoker = ((RequestInvoker.Builder)injector.inject(RequestInvoker.Builder.class)).build((RequestProcessor)new LinearRequestProcessor(rootStageAcceptor));
        injector.inject((Object)this);
    }

    private Application createApplication(Class<? extends Application> applicationClass) {
        if (applicationClass == ResourceConfig.class) {
            return new ResourceConfig();
        }
        if (applicationClass == Application.class) {
            return new Application();
        }
        return (Application)this.services.forContract(applicationClass).get();
    }

    public void registerAdditionalModules(Set<Module> modules) {
        DynamicBinderFactory dynamicBinderFactory = this.services.bindDynamically();
        for (Module module : modules) {
            module.configure((BinderFactory)dynamicBinderFactory);
        }
        dynamicBinderFactory.commit();
    }

    private List<Resource> buildAndValidate(List<Resource.Builder> resources, List<ResourceModelIssue> modelIssues, MessageBodyWorkers workers) {
        ArrayList<Resource> result = new ArrayList<Resource>(resources.size());
        BasicValidator validator = new BasicValidator(modelIssues, workers);
        for (Resource.Builder rb : resources) {
            Resource r = rb.build();
            result.add(r);
            validator.validate(r);
        }
        this.processIssues(validator);
        return result;
    }

    private void processIssues(ResourceModelValidator validator) {
        List<ResourceModelIssue> issueList = validator.getIssueList();
        if (!issueList.isEmpty()) {
            String allIssueMessages = this.allIssueLogMessages(validator.getIssueList());
            if (validator.fatalIssuesFound()) {
                LOGGER.severe(LocalizationMessages.ERRORS_AND_WARNINGS_DETECTED_WITH_RESOURCE_CLASSES(allIssueMessages));
            } else {
                LOGGER.warning(LocalizationMessages.WARNINGS_DETECTED_WITH_RESOURCE_CLASSES(allIssueMessages));
            }
        }
        if (validator.fatalIssuesFound()) {
            throw new ModelValidationException(issueList);
        }
    }

    private String allIssueLogMessages(List<ResourceModelIssue> issueList) {
        StringBuilder errors = new StringBuilder("\n");
        StringBuilder warnings = new StringBuilder();
        for (ResourceModelIssue issue : issueList) {
            if (issue.isFatal()) {
                errors.append(LocalizationMessages.ERROR_MSG(issue.getMessage())).append('\n');
                continue;
            }
            warnings.append(LocalizationMessages.WARNING_MSG(issue.getMessage())).append('\n');
        }
        return errors.append((CharSequence)warnings).toString();
    }

    public Future<Response> apply(final Request request) {
        final ContainerResponseWriter containerResponseWriter = new ContainerResponseWriter(){

            @Override
            public OutputStream writeResponseStatusAndHeaders(long contentLength, Response response) throws ContainerException {
                if (contentLength >= 0L) {
                    response.getHeaders().asMap().putSingle((Object)"Content-Length", (Object)Long.toString(contentLength));
                }
                return new OutputStream(){

                    @Override
                    public void write(int i) throws IOException {
                    }
                };
            }

            @Override
            public void suspend(long timeOut, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) throws IllegalStateException {
            }

            @Override
            public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
            }

            @Override
            public void cancel() {
            }

            @Override
            public void commit() {
            }
        };
        TimingOutInvocationCallback callback = new TimingOutInvocationCallback(){

            @Override
            protected Response handleResponse(Response response) {
                ApplicationHandler.this.writeResponse(containerResponseWriter, request, response);
                return request.getMethod().equals("HEAD") ? ApplicationHandler.this.stripEntity(response) : response;
            }

            @Override
            protected Response handleFailure(Throwable exception) {
                Response response = ApplicationHandler.handleFailure(exception);
                ApplicationHandler.this.writeResponse(containerResponseWriter, request, response);
                return response;
            }

            @Override
            protected Response handleTimeout(InvocationContext context) {
                Response response = ApplicationHandler.prepareTimeoutResponse(context);
                ApplicationHandler.this.writeResponse(containerResponseWriter, request, response);
                return response;
            }
        };
        this.apply(request, callback, DEFAULT_SECURITY_CONTEXT, null);
        return callback;
    }

    private Response stripEntity(Response originalResponse) {
        if (originalResponse.hasEntity()) {
            Response.ResponseBuilder result = Response.status((int)originalResponse.getStatus());
            Responses.fillHeaders((Response.ResponseBuilder)result, (Map)originalResponse.getHeaders().asMap());
            return result.build();
        }
        return originalResponse;
    }

    public void apply(final ContainerRequestContext containerContext) {
        this.checkContainerRequestContext(containerContext);
        ContainerResponseWriterCallback callback = new ContainerResponseWriterCallback(containerContext.getRequest(), containerContext.getResponseWriter()){

            @Override
            protected void writeResponse(Response response) {
                ApplicationHandler.this.writeResponse(containerContext.getResponseWriter(), this.request, response);
            }

            @Override
            protected void writeResponse(Throwable exception) {
                ApplicationHandler.this.writeResponse(containerContext.getResponseWriter(), this.request, ApplicationHandler.handleFailure(exception));
            }

            @Override
            protected void writeTimeoutResponse(InvocationContext context) {
                ApplicationHandler.this.writeResponse(containerContext.getResponseWriter(), this.request, ApplicationHandler.prepareTimeoutResponse(context));
            }
        };
        this.apply(containerContext.getRequest(), callback, containerContext.getSecurityContext(), containerContext.getRequestScopedInitializer());
        callback.suspendWriterIfRunning();
    }

    private void checkContainerRequestContext(ContainerRequestContext containerContext) {
        if (containerContext.getSecurityContext() == null) {
            throw new IllegalArgumentException("SecurityContext from ContainerRequestContext must not be null.");
        }
        if (containerContext.getRequest() == null) {
            throw new IllegalArgumentException("Request from ContainerRequestContext must not be null.");
        }
        if (containerContext.getResponseWriter() == null) {
            throw new IllegalArgumentException("ResponseWriter from ContainerRequestContext must not be null.");
        }
    }

    private void apply(final Request request, final InvocationCallback callback, final SecurityContext securityContext, final RequestScopedInitializer requestScopeInitializer) {
        this.requestScope.runInScope(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ApplicationHandler.this.initRequestScopeInjections(securityContext, requestScopeInitializer);
                    ApplicationHandler.this.invoker.apply(request, callback);
                }
                finally {
                    ((CloseableService)ApplicationHandler.this.closeableServiceFactory.get()).close();
                }
            }
        });
    }

    private void initRequestScopeInjections(SecurityContext securityContext, RequestScopedInitializer requestScopeInitializer) {
        Ref secReference = (Ref)this.securityContextRefFactory.get();
        secReference.set((Object)securityContext);
        if (requestScopeInitializer != null) {
            requestScopeInitializer.initialize(this.services);
        }
    }

    private static Response prepareTimeoutResponse(InvocationContext context) {
        Response response = context.getResponse();
        if (response == null) {
            response = Response.serverError().entity((Object)"Request processing has timed out.").type("text/plain").build();
        }
        return response;
    }

    private static Response handleFailure(Throwable failure) {
        Response.Status statusCode = Response.Status.INTERNAL_SERVER_ERROR;
        String message = failure.getMessage();
        if (failure instanceof ProcessingException) {
            if (failure instanceof HeaderValueException) {
                statusCode = Response.Status.BAD_REQUEST;
            } else if (failure instanceof InflectorNotFoundException) {
                statusCode = Response.Status.NOT_FOUND;
                message = "Requested resource not found.";
            }
        }
        if (statusCode == Response.Status.INTERNAL_SERVER_ERROR) {
            LOGGER.log(Level.SEVERE, message, failure);
        } else {
            LOGGER.log(Level.FINE, message, failure);
        }
        return Response.status((Response.StatusType)statusCode).entity((Object)message).type("text/plain").build();
    }

    private void writeResponse(final ContainerResponseWriter writer, Request request, Response response) {
        CommittingOutputStream committingOutput = null;
        final MessageBodySizeCallback messageBodySizeCallback = new MessageBodySizeCallback();
        try {
            boolean entityExists = response.hasEntity();
            MessageBodyWorkers workers = Requests.getMessageWorkers((Request)request);
            if (entityExists) {
                Object entity = response.getEntity();
                RouterModule.RoutingContext routingContext = (RouterModule.RoutingContext)this.routingContextFactory.get();
                MediaType outputMediaType = response.getMetadata().containsKey((Object)"Content-Type") ? MediaType.valueOf((String)((List)response.getMetadata().get((Object)"Content-Type")).get(0).toString()) : routingContext.getEffectiveAcceptableType();
                Annotation[] outputAnnotations = routingContext.getResponseMethodAnnotations();
                Type entityType = routingContext.getResponseMethodType();
                if (entityType == null || Void.TYPE == entityType || Void.class == entityType || entityType == Response.class) {
                    Type type = entityType = entity instanceof GenericEntity ? ((GenericEntity)entity).getType() : entity.getClass();
                }
                if (entity instanceof GenericEntity) {
                    entity = ((GenericEntity)entity).getEntity();
                }
                if (response.getHeaders().getMediaType() == null) {
                    response = Responses.toBuilder((Response)response).type(outputMediaType).build();
                }
                final Response outResponse = response;
                committingOutput = new CommittingOutputStream(){
                    private OutputStream output;

                    protected void commit() throws IOException {
                        this.output = writer.writeResponseStatusAndHeaders(messageBodySizeCallback.getSize(), outResponse);
                    }

                    protected OutputStream getOutputStream() throws IOException {
                        return this.output;
                    }
                };
                workers.writeTo(entity, GenericType.of(entity.getClass(), entityType), outputAnnotations, outputMediaType, response.getMetadata(), response.getProperties(), (OutputStream)committingOutput, (MessageBodyWorkers.MessageBodySizeCallback)messageBodySizeCallback, true, !request.getMethod().equals("HEAD"));
            } else {
                writer.writeResponseStatusAndHeaders(0L, response);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ApplicationHandler.class.getName()).log(Level.SEVERE, null, ex);
            throw new MappableException((Throwable)ex);
        }
        finally {
            this.commitOutputStream(committingOutput);
            writer.commit();
        }
    }

    private void commitOutputStream(CommittingOutputStream committingOutput) {
        if (committingOutput == null) {
            return;
        }
        if (!committingOutput.isCommitted()) {
            try {
                committingOutput.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Services getServices() {
        return this.services;
    }

    public ServiceProviders getServiceProviders() {
        return (ServiceProviders)this.refs.providers.get();
    }

    public ResourceConfig getConfiguration() {
        return this.configuration;
    }

    private class MessageBodySizeCallback
    implements MessageBodyWorkers.MessageBodySizeCallback {
        private long size = -1L;

        private MessageBodySizeCallback() {
        }

        public void onRequestEntitySize(long size) throws IOException {
            this.size = size;
        }

        public long getSize() {
            return this.size;
        }
    }

    private class ApplicationModule
    extends AbstractModule {
        private ApplicationModule() {
        }

        protected void configure() {
            ResourceConfigProvider rcp = new ResourceConfigProvider();
            this.bind(ResourceConfig.class, new Class[0]).toFactory((Factory)rcp).in(Singleton.class);
            this.bind(FeaturesAndProperties.class, new Class[0]).toFactory((Factory)rcp).in(Singleton.class);
            this.bind(Application.class, new Class[0]).toFactory((Factory)new JaxrsApplicationProvider()).in(Singleton.class);
            this.bind(ApplicationHandler.class, new Class[0]).toInstance((Object)ApplicationHandler.this);
        }

        private class ResourceConfigProvider
        implements Factory<ResourceConfig> {
            private ResourceConfigProvider() {
            }

            public ResourceConfig get() throws ComponentException {
                return ApplicationHandler.this.configuration;
            }
        }

        private class JaxrsApplicationProvider
        implements Factory<Application> {
            private JaxrsApplicationProvider() {
            }

            public Application get() throws ComponentException {
                return ApplicationHandler.this.configuration.getApplication();
            }
        }
    }

    private static class References {
        @Inject
        private Ref<ServiceProviders> providers;
        @Inject
        private Ref<ExceptionMappers> mappers;
        @Inject
        private Ref<MessageBodyWorkers> workers;
        @Inject
        private Ref<ContextResolvers> resolvers;

        private References() {
        }
    }
}

