/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public class ChunkedResponse<T> {
    private final BlockingDeque<T> queue = new LinkedBlockingDeque<T>();
    private final Class<T> clazz;
    private final long interval;
    private final TimeUnit timeUnit;
    private boolean closed = false;

    public ChunkedResponse(Class<T> clazz) {
        this(clazz, null, null);
    }

    public ChunkedResponse(Class<T> clazz, Long interval, TimeUnit timeUnit) {
        this.clazz = clazz;
        this.interval = interval == null ? 5L : interval;
        this.timeUnit = timeUnit == null ? TimeUnit.SECONDS : timeUnit;
    }

    public void write(T t) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (t != null) {
            this.queue.add(t);
        }
    }

    public void close() {
        this.closed = true;
    }

    boolean isClosed() {
        return this.closed;
    }

    protected Class<T> getChunkType() {
        return this.clazz;
    }

    protected T getChunk() throws InterruptedException {
        if (this.closed) {
            return null;
        }
        return this.queue.poll(this.interval, this.timeUnit);
    }
}

